
Uses Dos, Crt;
Type
  CallRec    = String[10];
  QTHStr     = String[40];
  LUserFRec  = Record { users.clu }
               Call,                    { Callsign }
               Name      : CallRec;     { Name }
               Locator   : String[6];   { WW locator }
               Personal  : String[40];  { Some personal description }
               Logins,                  { How many connects }
               Time,                    { Last logged in/out (packed datetime) }
               NewsTime  : LongInt;     { Unused. }
               Messages,                { Messages flags }
               Beeps,                   { Beeps flags }
               Flags,                   { General flags }
               Rights    : Word;        { Permission flags }
               CharSet,                 { Character conversion table }
               Prompt    : Byte;        { Prompt type }
               End;

  NUserFRec  = Record { nusers.clu }
               Call      : CallRec;    { Kutsu }
               PC        : CallRec;    { Node }
               Name      : CallRec;    { Nimi }
               QTH       : QTHStr;     { QTH }
               PCQuality : Byte;       { Kuinka varma tieto kotinodesta on:
                                         0 - ei harmainta aavistusta
                                         2 - DX/ANN/WWV etc info
                                         5 - User login
                                         7 - Set manually }
               Time      : LongInt;    { Muutettu viimeksi }
               Index     : LongInt;
               End;

  NUTableType = Array[0..0] of NUserFRec;

Const
  Cr     = #$0D;
  Lf     = #$0A;
  CrLf   = Cr+Lf;
  Copyright               = 'Copyright 1994, 1995, 1996 Heikki Hannikainen';
  Author_Address          = 'hessu@pspt.fi - oh7lzb@gw.oh7rba.ampr.org - OH7LZB@OH7RBA.#KUO.FIN.EU';

Var

 NUserFile : File of NUserFRec;
 LUserFile : File of LUserFRec;

 NU        : NUserFRec;
 LU        : LUserFRec;

 NUTable   : ^NUTableType;

 Ch        : Char;
 w         : Word;
 Pos       : LongInt;
 Len       : LongInt;

 DT        : DateTime;

{ ***************************************************************** }

Function Int2Str(int:LongInt):string;
var s: string[11];
begin
str(int,s);
int2str := s;
end;

 { ***************************************************************** }

Function Spaces(Len:Byte):String;
Var S:String;
    L:Byte;
Begin
 S := '';
 For L := 0 to Len do S := S + ' ';
 Spaces := S;
End;

 { ********************************************************************** }

Function PadLeft(Len:Byte;Str:String):String;
Var L:Byte;
Begin
 If Length(Str) >= Len
   then PadLeft := Copy(Str,1,Len)
   else PadLeft := Str + Spaces(Len-Length(Str)-1);
End;

 { ********************************************************************** }

Function PadRight(Len:Byte;Str:String):String;
Var L:Byte;
Begin
 If Length(Str) >= Len
   then PadRight := Copy(Str,1,Len)
   else PadRight := Spaces(Len-Length(Str)-1) + Str;
End;

 { ***************************************************************** }

Function BackSpaces(Len:Byte):String;
Var
  b : Byte;
  s : String;
Begin

 s := '';
 For b := 1 to Len
  do s := s + Chr(8);
 BackSpaces := s;

End;

{ ***************************************************************** }

procedure QuickSort;

procedure Sort(l, r: LongInt);
var
  i, j: LongInt;
  x   : CallRec;
  y   : NUserFRec;
begin

  i := l;
  j := r;
  x := NUTable^[(l+r) DIV 2].Call;

  repeat

    while NUTable^[i].Call < x
      do Inc(i);

    while x < NUTable^[j].Call
      do Dec(j);

    if i <= j
      then begin
           y := NUTable^[i];
           NUTable^[i] := NUTable^[j];
           NUTable^[j] := y;
           Inc(i);
           Dec(j);
           end;

  until i > j;

  if l < j
    then Sort(l, j);
  if i < r
    then Sort(i, r);

end;

begin {QuickSort};
  Sort(0,Pos);
end;

{ ***************************************************************** }

Begin

 HighVideo;
 WriteLn(CrLf + '   Clusse 0.30 to 0.30a update' + CrLf + CrLf + '  ' + Copyright + CrLf + '  ' + Author_Address + CrLf);
 NormVideo;
 WriteLn('   Execute this program ONLY ONCE and delete it afterwards to prevent yourself' + CrLf
       + ' from running it again by accident!' + CrLf);

 WriteLn('   This program must be run in the DATA directory of Clusse. If you are not' + CrLf
       + ' updating from Clusse version 0.30 or older, there is no need to run this' + CrLf
       + ' program.' + CrLf);

 Write(' Are you sure you want to run this program now (Yes/NO)? ');
 Ch := ReadKey;

 If not (UpCase(Ch) = 'Y')
  then Halt(0);

 WriteLn(CrLf + CrLf + ' Creating netusers.clu based on users.clu...');

 Assign(LUserFile,'users.clu');

 Reset(LUserFile);
 If IOResult <> 0
  then Begin
       WriteLn(' Cannot find users.clu. Make sure you''re in the Clusse DATA directory.');
       Halt(1);
       End;

 Len := FileSize(LUserFile);
 GetMem(NUTable,Len * SizeOf(NUserFRec));
 Dec(Len);

 Pos := 0;
 GetTime(DT.Hour,DT.Min,DT.Sec,w);
 GetDate(DT.Year,DT.Month,DT.Day,w);
 PackTime(DT,NU.Time);
 NU.PC := '';
 NU.PCQuality := 0;
 NU.QTH := '';
 Write(' Converting to memory:     0');

 While not eof(LUserFile)
  do Begin

     Read(LUserFile,LU);
     If IOResult <> 0
       then Begin
            WriteLn(CrLf + ' Trouble: Cannot read users.clu!');
            Halt(1);
            End;

     NU.Call := LU.Call;
     NU.Name := LU.Name;
     NUTable^[Pos] := NU;
     Inc(Pos);
     Write(BackSpaces(4) + PadRight(4,Int2Str(Pos)));
     End;

 Dec(Pos);

 Close(LUserFile);
 Write(CrLf + ' Sorting...');
 QuickSort;

 Write(' Writing to disk...');

 Assign(NUserFile,'netusers.clu');
 Rewrite(NUserFile);
 For w := 0 to Pos
  do Write(NUserFile,NUTable^[w]);
 Close(NUserFile);

 If IOResult <> 0
  then Begin
       WriteLn(CrLf + ' Trouble: Cannot write netusers.clu!');
       Halt(1);
       End;
 WriteLn(' Done.');

End.
