#!/bin/sh

DATE=`date +%Y%m%d`
CURRTGZ="clussed-$DATE.tar.gz"
SNAPDIR="snaptmp-$DATE-$$"

echo "Snapshot.sh: Creating snapshot dated $DATE"
cd ..

rm -f clussed-$DATE.tar.gz

PREVTGZ=`ls | grep clussed-*.tar.gz | sort | tail -1`
echo "Previous found in $PREVTGZ"

echo "Creating $CURRTGZ ..."
mv clussed clussed-$DATE
tar cfz $CURRTGZ clussed-$DATE
mv clussed-$DATE clussed

mkdir $SNAPDIR
cd $SNAPDIR
echo "Extracting $CURRTGZ ..."
tar xfz ../$CURRTGZ
echo "Extracting $PREVTGZ ..."
tar xfz ../$PREVTGZ
echo "Running diff ..."
diff -urN clussed-* | gzip -c - > ../patch-$DATE.gz
cd ..
echo "Cleaning up ..."
rm -rf $SNAPDIR

echo "Patch in patch-$DATE.gz"



