
/*
 *	net_link.c
 *
 *	This module acts as a multiplexer for outgoing network
 *	messages to different protocol modules.
 */

#include <stdio.h>

#include "net_link.h"
#include "network.h"
#include "net_pc.h"

/*
 *	Beacon
 */

void link_beacon(struct link_t *l)
{
	pc_beacon(l);
}

/*
 *	Send a ping
 */

void link_ping(struct link_t *l, call_t *to, call_t *from, int flag)
{
	pc_ping(l, to, from, flag);
}

/*
 *	Request link closing
 */

void link_reqclose(struct link_t *l, char *reason)
{
	pc_reqclose(l, reason);
}

/*
 *	Nodes
 */

void link_nodeadd(struct node_t *n)
{
	pc_nodeadd(n);
}

void link_nodedel(struct node_t *n, char *reason)
{
	pc_nodedel(n, reason);
}

/*
 *	Users
 */
 
void link_useradd(struct nuser_t *nu)
{
	pc_useradd(nu);
}

void link_userdel(struct nuser_t *nu)
{
	pc_userdel(nu);
}

void link_useraway(struct nuser_t *nu)
{
	pc_useraway(nu);
}

void link_userhere(struct nuser_t *nu)
{
	pc_userhere(nu);
}

/*
 *	Cluster events
 */

void link_dx(struct dx_t *dx)
{
	pc_dx(dx);
}

void link_announce(struct ann_t *ann)
{
	pc_announce(ann);
}

void link_wwv(struct wwv_t *wwv)
{
	pc_wwv(wwv);
}

void link_talk(struct talk_t *talk)
{
	pc_talk(talk);
}

