
#ifndef NET_PING_H
#define NET_PING_H

#include <time.h>

#include "network.h"
#include "csock.h"

#define PING_TIMEOUT     1200	/* Pinger timeout */

struct ping_t {
	struct node_t *node;	/* Node being pinged */
	time_t time;		/* Seconds pinged */
	int rtt_max;		/* Seconds to wait */
	call_t fromcall;	/* Who is pinging */
	struct ping_t *next;	/* Next record */
};

extern void ping_add(struct node_t *node, call_t *fromcall, int rtt_max);
extern void net_ping(struct link_t *l, call_t *tocall, call_t *fromcall, int flag);
extern int ping_del(struct node_t *node);			/* Drop a ping */
extern void ping_abort(struct node_t *node, char *reason);	/* Abort a ping */

extern void pinger_second(void);

extern int cmd_ping(struct csock_t *s, int argc, char **argv); /* The Ping command for users */
extern int cmd_pstatus(struct csock_t *s, int argc, char **argv); /* PStat command for users */

extern int ping_jobs;		/* Amount of pinger jobs */
extern struct ping_t *pings;	/* Pinger list */

#endif

