
#include "f_mid.h"
#include "log.h"
#include "db.h"
#include "config.h"
#include "hmalloc.h"
#include "timer.h"

struct db_t *mid_db = NULL;

/*
 *	Insert a new mid in database. If it exists already, return 0,
 *	if it doesn't, return 1.
 */
 
int new_mid(mid_t *mid)
{
	datum key, content;
	
	key.dptr = (void *)mid;
	key.dsize = sizeof(mid_t);
	
	content.dptr = (void *)&now;
	content.dsize = sizeof(time_t);
	
	return !(db_store(mid_db, key, content, DB_INSERT));
}

/*
 *	Open mid file
 */
 
int open_midf(void)
{
	mid_db = db_open(mid_f);
	if (!mid_db) {
		log(L_CRIT, "open_midf(): db_open() failed for %s, abandon ship.", mid_f);
		exit(1);
	}
	return 0;
}

/*
 *	Close mid file
 */
 
int close_midf(void)
{
	db_close(mid_db);
	return 0;
}

