
/*
 *	telnet.c
 *
 *	telnet option negotiation
 */

#include <string.h>

#include "telnet.h"
#include "csock.h"

/*
 *	Some telnet option switchers:
 */

void tn_do_linemode(struct csock_t *s)
{
	csrwritec(s, IAC);
	csrwritec(s, DO);
	csrwritec(s, TN_LINEMODE);
	csflush(s);
	s->tn_linemode = 1;
}

void tn_will_echo(struct csock_t *s)
{
	csrwritec(s, IAC);
	csrwritec(s, WILL);
	csrwritec(s, TN_ECHO);
	csflush(s);
	s->tn_echo = 1;
}

void tn_wont_echo(struct csock_t *s)
{
	csrwritec(s, IAC);
	csrwritec(s, WONT);
	csrwritec(s, TN_ECHO);
	csflush(s);
	s->tn_echo = 0;
}

/*
 *	Scan input buffer for telnet commands, interpret and remove them.
 */
 
int telnet_handle(struct csock_t *s)
{
	unsigned char *p, *cp;
	int opt, c;
	int i;
	
	opt = 0; /* silence warning */
	p = s->ibuf.buf;
	i = 0;
	while (i < s->ibuf.pos) {
		if (*p == IAC) {
			cp = p; /* Mark the beginning of the sequence */
			
			p++; i++;
			if (i == s->ibuf.pos)
				return -1; /* Need more! */
			c = *p;
			if (c > 249 && c < 255) {
				p++; i++;
				if (i == s->ibuf.pos)
					return -1; /* Need more! */
				opt = *p;
			}
			switch (c) {
			case SB:	/* Subnegotiation begin */
					/* Read until IAC SE */
				p++; i++;
				if (i == s->ibuf.pos)
					return -1; /* Need more! */
				c = *p;
				p++; i++;
				if (i == s->ibuf.pos)
					return -1; /* Need more! */
				opt = *p;
				while (!(c == IAC && opt == SE)) {
					c = opt;
					p++; i++;
					if (i == s->ibuf.pos)
						return -1; /* Need more! */
					opt = *p;
				}
				break;
				
			case WILL:
				if (opt == TN_LINEMODE && s->tn_linemode) {
					csrwritec(s, IAC);
					csrwritec(s, SB);
					csrwritec(s, TN_LINEMODE);
					csrwritec(s, TN_LINEMODE_MODE);
					csrwritec(s, TN_LINEMODE_MODE_EDIT);
					csrwritec(s, IAC);
					csrwritec(s, SE);
				} else {
					csrwritec(s, IAC);
					csrwritec(s, DONT);
					csrwritec(s, opt);
				}
				csflush(s);
				break;
			
			case DO:
				if (!(opt == TN_ECHO && s->tn_echo)) {
					csrwritec(s, IAC);
					csrwritec(s, WONT);
					csrwritec(s, opt);
					csflush(s);
				}
				break;
			
			case IAC:       /* Escaped IAC */
				cp++;
				break;
			
			case WONT:
			case DONT:
			default:
				break;
			} /* case */
			
			/* Then, remove the sequence from the input buffer */
			i++;
			p++;
			memmove(cp, p, s->ibuf.pos - i);
			s->ibuf.pos -= (p - cp);
			i -= (p - cp);
			p = cp;
		} else {
			i++;
			p++;
		}
	} /* end of buffer */
	
	return 0;
}

