#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dir.h>
#include <dos.h>
#include <conio.h>
#include "file.h"
#include "main.h"
#include "emulib.h"

/*--------------------------------------------------------------------------
  ------ Main function -----------------------------------------------------
  ------------------------------------------------------------------------*/
void main(int Argc, char * Argv[])
{
  char	szLockFile[MAXPATH];		/*lock file name*/
  char  szDestFile[MAXPATH];		/*Destination file*/
  char	szCallFile[MAXPATH];		/*Callsign to search*/
  char	szCbPath[MAXPATH];		/*Callbook path*/
  char	szLuPrg[MAXPATH];		/*Lookup program*/
  char	szFileName[MAXPATH];		/*Used to store a file name*/
  char	szCallsign[128];		/*Searched callsign*/
  char	cDrive;				/*CD-ROM drive letter*/
  FILE *fLock;
  FILE *fOutput;
  int	nKey;

  if (check_emu() == 0)
  {
    printf("Dosemu not detected.\n");
    printf("This program is intended for Dosemu only.\n");
    exit (EXIT_FAILURE);
  }

  /*Check arguments*/
  if( Argc != 4 )
    MAIN_error();

  strlwr(Argv[1]);
  strlwr(Argv[2]);
  strlwr(Argv[3]);

  //Check CD-ROM drive error
  if( *Argv[1] < 'd' || *Argv[1] > 'z' )
  {
    printf("*** Error : bad CD-ROM drive letter.\n");
    MAIN_error();
  }

  /* Build file and path name variables */
  cDrive = *Argv[1];
  strcpy(szLuPrg,  Argv[2]);
  strcpy(szCbPath, Argv[3]);

  if( szCbPath[ strlen(szCbPath)-1 ] == '\\' )
    szCbPath[ strlen(szCbPath)-1 ] = '\0';

  sprintf(szLockFile, "%s\\lock", szCbPath);
  sprintf(szDestFile, "%s\\output", szCbPath);
  sprintf(szCallFile, "%s\\input", szCbPath);

  printf("Running BUCK4LIN interface - Press ALT-Q to stop ...\n");

  for(;;)
  {
    int old_hog;

    if( kbhit() )
    {
      if( getch() == 0 )	 /*Extended key*/
	if( getch() == 16 )	 /*Code for ALT-Q*/
	  exit (EXIT_SUCCESS);
    }

    if( FILE_exist(szLockFile) )
    {
      if( ! FILE_getCall(szCallFile, szCallsign) )
	continue;

      //The searched callsign must be in upper-case !...
      strupr (szCallsign);

      sprintf(szFileName, "%s %s %c: > DATA", szLuPrg, szCallsign, cDrive);
      system (szFileName); 		         /*Run the lookup program*/

      FILE_copy("DATA", szDestFile, szCallsign); /*Copy the data to the destination*/

      FILE_delete(szLockFile);			 /*Data are copied, delete lock*/
      FILE_delete("DATA");
    }

    /*Wait 1 second before testing again*/
    old_hog = MAIN_setHog (1);	/*Ask dosemu to use the lowest CPU time*/
    sleep (1);
    MAIN_setHog (old_hog);	/*Set back the normal hogthreshold*/
  }
}

/*This code is part of SPEED.C (c) 12/27/95 by Kang-Jin Lee, provided with
  the DOSEMU package*/
unsigned int MAIN_setHog(unsigned int hogthreshold_value)
{
  _AX = 0x12;
  _BX = hogthreshold_value;
  geninterrupt(DOS_HELPER_INT);

  _AX = 0x28;
  geninterrupt(DOS_HELPER_INT);
  return _BX;
}

void MAIN_error(void)
{
  printf("Buckmaster's Hamcall CD-ROM interface for DxNet for Linux.\n");
  printf("Version 1.00 Copyright (c) 1998, F5MZN.\n");
  printf("\n");
  printf("Syntax  : BUCK4LIN <CD-drive> <lookup_prg> <dxnet_path>\n");
  printf("          <drive>      : CD-ROM drive letter.\n");
  printf("          <lookup_prg> : lookup program path.\n");
  printf("          <dxnet_path> : callbook DxNet directory path.\n");
  printf("\n");
  printf("Example : BUCK4LIN E: E:\\ICALL-S\\ICALL.EXE D:\\USR\\LOCAL\\DXNET\\CALLBOOK\n");
  exit(EXIT_FAILURE);
}