#include <alloc.h>	//Needed for linux compatibility
#include <string.h>
#include <dir.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "purgmail.h"

//This program is intended to purge both the DirMes.bin file and the
//messages files

/* PURGEMAIL [d=DirMesPath] [m=MailPath] [b=#n_days] [p=#n_days]

   where : - [d=DirMes path] specifies the directory in where dirmes.bin file
	     is located.
	     The default directory is SYSTEM\BIN.

	   - [m=MailPath] specifies the mail directory.
	     By default, this directory is set to MAIL

	   - [b=#n_days] sets the number of day (#n_days) after which a
	     bulletin will be deleted.
	     By default, this value is set to 30.

	   - [p=#n_days] sets the number of day (#n_days) after which a
	     private mail will be deleted.
	     By default, this value is set to 30.

   Example : PURGMAIL p=C:\DXNET\SYSTEM\BIN m=C:\DXNET\MAIL p=10 b=15
	or : PURGMAIL p=20

*/

int		nBullDelete = 30;
int		nPrivDelete = 30;
DirMesStruct	tDirMes;
char	       *pszMonth[12] = { "Jan", "Fev", "Mar", "Apr", "May",
				 "Jun", "Jul", "Aug", "Sep", "Oct",
				 "Nov", "Dec" };

//---------------------------------------------------------------------------
//------ main function ------------------------------------------------------
//---------------------------------------------------------------------------
void main(int Argc, char * Argv[])
{
  int	index;
  char	szBinPath[MAXDIR];
  char	szMailPath[MAXDIR];
  char	szBin[MAXPATH];
  char	szOld[MAXPATH];
  char	szMsg[MAXPATH];
  FILE *fDirMes;
  FILE *fDirOld;
  BYTE	byDeleteMsg;
  struct tm	tTmTime;
  time_t	tMsgTime;

#ifdef LINUX
  strcpy(szBinPath,  "system/bin/");
  strcpy(szMailPath, "mail/");
#else
  strcpy(szBinPath,  "system\\bin\\");
  strcpy(szMailPath, "mail\\");
#endif

  //Get the arguments
  for(index = 1; index <= Argc; index++)
  {
    strlwr( Argv[index] );

    switch( Argv[index][0] )
    {
      case 'p' :
	if( Argv[index][1] == '=' )
	  nPrivDelete = atoi( Argv[index] + 2 );
	break;

      case 'b' :
	if( Argv[index][1] == '=' )
	  nBullDelete = atoi( Argv[index] + 2 );
	break;

      case 'd' :
	if( Argv[index][1] == '=' )
	  strcpy(szBinPath, Argv[index] + 2);
	break;

      case 'm' :
	if( Argv[index][1] == '=' )
	  strcpy(szMailPath, Argv[index] + 2);
	break;
    }/*End SWITCH*/
  }/*End FOR*/

  //Arguments can not be null or minus zero
  if( nBullDelete <= 0 )
    nBullDelete = 1;
  if( nPrivDelete <= 0 )
    nPrivDelete = 1;

  //Open DirMes.bin and DirMes.old
#ifdef LINUX
  sprintf(szBin, "%s/%s", szBinPath, "dirmes.bin");
  sprintf(szOld, "%s/%s", szBinPath, "dirmes.old");
#else
  sprintf(szBin, "%s\\%s", szBinPath, "dirmes.bin");
  sprintf(szOld, "%s\\%s", szBinPath, "dirmes.old");
#endif

  fDirMes = fopen(szBin, "rb");

  if( ! fDirMes )	//Error opening the file
  {
    perror("PURGMAIL -> fopen in MAIN (fDirMes 1)");
    return;
  }

  fDirOld = fopen(szOld, "w+b");

  if( ! fDirOld )	//Error opening the file
  {
    perror("PURGMAIL -> fopen in MAIN (fDirOld)");
    return;
  }

  //Copy dirmes.bin in dirmes.old
  printf("Creating dirmes.old\n");
  for(;;)
  {
    if( ! fread(&tDirMes, sizeof(DirMesStruct), 1, fDirMes) )
      break;	//EOF

    fwrite(&tDirMes, sizeof(DirMesStruct), 1, fDirOld);
  }

  //Close dirmes.bin, and then open it again in write mode (the file
  //is then deleted)
  fclose( fDirMes );
  fDirMes = fopen(szBin, "wb");

  if( ! fDirMes )	//Error opening the file
  {
    perror("PURGMAIL -> fopen in MAIN (fDirMes 2)");
    return;
  }

  //Beginning of dirmes.old
  fseek(fDirOld, 0L, SEEK_SET);

  for(;;)
  {
    byDeleteMsg = FALSE;	//Reset the flag

    if( ! fread(&tDirMes, sizeof(DirMesStruct), 1, fDirOld) )
      break;	//EOF

    //Is the mail killed ?
    if( tDirMes.cStatus == STATUS_K )
    {
      //Delete the message file
      byDeleteMsg = TRUE;
    }
    else
    {
      //Convert the date
      memset(&tTmTime, 0, sizeof(struct tm));

      //Day
      tTmTime.tm_mday = atoi( tDirMes.szDate );

      //Month
      for(index = 0; index < 12; index++)
      {
	if( ! strncmp(tDirMes.szDate+3, pszMonth[index], 3) )
	{
	  tTmTime.tm_mon = index;
	  break;
	}
      }

      //Year
      tTmTime.tm_year = atoi( tDirMes.szDate + 9 );

      //Hour and Minutes
      tTmTime.tm_hour  = (int) tDirMes.byTi_Hour;
      tTmTime.tm_min   = (int) tDirMes.byTi_Min;

      //Convert
      tMsgTime = mktime( &tTmTime );

      //Must one kill the message ?
      if( tDirMes.cType == 'P' )
      {
	if( difftime(time(NULL), tMsgTime) > (86400 * nPrivDelete) )
	  byDeleteMsg = TRUE;
      }
      else
      {
	if( difftime(time(NULL), tMsgTime) > (86400 * nBullDelete) )
	  byDeleteMsg = TRUE;
      }/*End IF*/
    }/*End IF*/

    if( byDeleteMsg && ! tDirMes.byNoAutoDelete)
    {
      //Delete the mail
      printf("Deleting message #%ld ...\n", tDirMes.dwNumber);
      sprintf(szMsg, "%sm%07ld.msg", szMailPath, tDirMes.dwNumber);
      unlink( szMsg );
    }
    else
    {
      //Copy the header
      fwrite(&tDirMes, sizeof(DirMesStruct), 1, fDirMes);
    }/*End IF*/
  }/*End FOR*/

  fclose( fDirOld );
  fclose( fDirMes );

  printf("PURGMAIL completed.\n");
}

