
/******************************************************
 *                                                    *
 * FPAC project.            FPAC PAD                  *
 *                                                    *
 * route.c - does like traceroute                     *
 *                                                    *
 * F6FBB 03-2000                                      *
 *                                                    *
 ******************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <signal.h>
#include <syslog.h>
#include <ctype.h>
#include <stdarg.h>

#include <time.h>
#include <sys/types.h>
#include <sys/fcntl.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <netinet/in.h>

#ifndef SOL_ROSE
#define SOL_ROSE 260
#endif
#ifndef SOL_AX25
#define SOL_AX25 257
#endif

#include "ax25compat.h"
#include "fpad.h"
#include "wp.h"

#define	AX25_HBIT 0x80

int trace_route(int fd)
{
	int new;
	int yes;
	int axfd;
	char txt[80];
	char rsaddr[11];
	struct timeval tv;
	struct timezone tz;
	struct full_sockaddr_ax25 rec, exp;

	/* Accept the connection */
	yes = TRUE;
	ioctl(fd, FIONBIO, &yes);

	addrlen = sizeof(struct full_sockaddr_ax25);
	new = accept(fd, (struct sockaddr *)&exp, &addrlen);

	yes = FALSE;
	ioctl(fd, FIONBIO, &yes);
	
	if (new < 0) 
	{
		if (errno == EWOULDBLOCK)
			return(-1);	/* It's gone ??? */

		syslog(LOG_ERR, "accept error %m\n");
		return(-1); 
	}

	addrlen = sizeof(rec);
	getsockname(new, (struct sockaddr *)&rec, &addrlen);
            
	pl2 = calloc(sizeof(user_t), 1);
	pl2->fd = new;
	pl2->queue = 0;
	pl2->type = AF_AX25;
	pl2->state = CONNECTED;
	pl2->peer = NULL;
	pl2->verbose = FALSE;
	strcpy(pl2->user, ax25_ntoa(&exp.fsa_ax25.sax25_call));

	/* Insert the new connection into the list */
	pl2->next = head;
	head = pl2;

	/* Send the ID text */
	sprintf(txt, "%s %s %s\r", node, address, qth);
	write(new , txt, strlen(txt));
	
	/* Look for the position of the node digi */
	for (ndigi = 0, npos = -1, n = exp.fsa_ax25.sax25_ndigis-1 ; n >=0 ; n--)
	{
		if (exp.fsa_digipeater[n].ax25_call[6] & AX25_HBIT)
		{
			ndigi = npos = n;
			break;
		}
	}
			
	strcpy(rsaddr, cfg.fulladdr);

	ok = FALSE;

	if (ndigi > 0)
	{
		int len;
		char dnic[5];
		wp_t wpt;

		--ndigi;	/* Digi-Callsign of the node */

		memset(&dnic, 0, sizeof(dnic));

		ptr = ax25_ntoa(&exp.fsa_digipeater[ndigi]);
		len = rose_add(ptr);

		/* Check if a country */
		strcpy(digi, ptr);
		pdig = strrchr(digi, '-');
		if (pdig)
			*pdig = '\0';
		if ((strlen(digi) == 3) && (ndigi > 0) && ((pdig = des2dnic(digi)) != NULL))
		{
			memcpy(dnic, pdig, 4);

			--ndigi;
			ptr = ax25_ntoa(&exp.fsa_digipeater[ndigi]);
			len = rose_add(ptr);
		}
		else if ((len == 4) && (ndigi > 0))
		{
			/* Check if dnic */			
			memcpy(dnic, ptr, 4);

			--ndigi;
			ptr = ax25_ntoa(&exp.fsa_digipeater[ndigi]);
			len = rose_add(ptr);
		}

		/* Check if it is a node callsign from wp */
		if ((wp_get(&exp.fsa_digipeater[ndigi], &wpt) == 0) && (wpt.is_node) && (!wpt.is_deleted))
		{
			memcpy(rsaddr, rose_ntoa(&wpt.address.srose_addr), 10);
		}
		else if (len == 6)
		{
			if (*dnic)
				memcpy(rsaddr, dnic, 4);
			memcpy(rsaddr+4, ptr, 6);
			--ndigi;
			ok = TRUE;
		}
	}

	/* route address in rsaddr */
	if (last(rsaddr)) {
		/* Last node ... Disconnect */
		close(xx);
		return;
	}

	/* Find the adjacent node from the route information */
	if (!find_route(rsaddr)) {
		/* No route ... Disconnect */
		close(xx);
		return;
	}
	
	axfd = socket (AF_AX25, SOCK_SEQPACKET, 0)) < 0)
	{
		syslog(LOG_ERR, "socket_rs\n");
		end(pl2);
		return(-1);
	}
	
	gettimeofday(&tv, &tz);
	
	/* Connect the adjacent */
	connect()
}

int trace_connected()
{
	/* Send the connection delay, 1st message delay to the caller */
}

int trace_in()
{
	/* Send the connection delay, 1st message delay to the caller */
}
