// ListFiles.cpp : implementation file
//

#include "stdafx.h"
#include "fbbw.h"
#include "fbbWDlg.h"
#include "ListFiles.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

static int CALLBACK CompareFunc(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort)
{
	if (lParam1 > lParam2)
		return -1;
	else if (lParam1 < lParam2)
		return 1;
	else
		return 0;
}

/////////////////////////////////////////////////////////////////////////////
// CListFiles dialog


CListFiles::CListFiles(char* FileName, CWnd* pParent /*=NULL*/)
	: CDialog(CListFiles::IDD, pParent)
{
	//{{AFX_DATA_INIT(CListFiles)
	m_FileName = _T("");
	m_Directory = _T("/");
	m_Path = _T("/");
	//}}AFX_DATA_INIT
	m_pFileName = FileName;
	m_FileNameType = 0;
	pFbbMain = pParent;
}


void CListFiles::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CListFiles)
	DDX_Control(pDX, IDC_FILELIST, m_FileList);
	DDX_Control(pDX, IDC_DIRUP, m_DirUp);
	DDX_Text(pDX, IDC_FILENAME, m_FileName);
	DDX_Text(pDX, IDC_DIRECTORY, m_Directory);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CListFiles, CDialog)
	//{{AFX_MSG_MAP(CListFiles)
	ON_BN_CLICKED(IDC_DIRUP, OnDirup)
	ON_BN_CLICKED(IDOK, OnOpen)
	ON_NOTIFY(NM_DBLCLK, IDC_FILELIST, OnDblclkFilelist)
	ON_NOTIFY(NM_CLICK, IDC_FILELIST, OnClickFilelist)
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_FILELIST, OnItemchangedFilelist)
	ON_NOTIFY(LVN_COLUMNCLICK, IDC_FILELIST, OnColumnclickFilelist)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CListFiles message handlers

void CListFiles::OnDirup() 
{
	// TODO: Add your control notification handler code here
	char *ptr = m_Path.GetBuffer(256);
	char *p = strrchr(ptr, '/');
	if (p)
		*p = '\0';
	m_Path.ReleaseBuffer(-1);
	if (m_Path == "")
		m_Path = "/";
	m_Directory = m_Path;
	UpdateData(FALSE);
	((CFbbWDlg *)pFbbMain)->RequestDirectory(ptr);
}

void CListFiles::OnOpen() 
{
	// TODO: Add your control notification handler code here

//	UpdateData();

	if (m_FileNameType == 0)
		return;

	CString Str;

	if (m_Path == "/")
		Str.Format("/%s",m_FileName);
	else
		Str.Format("%s/%s",m_Path, m_FileName);

	char *ptr = Str.GetBuffer(256);

	if (m_FileNameType == 'd')
	{
		m_Path= Str;
		m_Directory = (m_Path.GetLength()) ? m_Path : "/";
		UpdateData(FALSE);
		((CFbbWDlg *)pFbbMain)->RequestDirectory(ptr+1);
	}
	else
	{
		((CFbbWDlg *)pFbbMain)->RequestFile(ptr+1);
		CDialog::OnOK();
	}
}

BOOL CListFiles::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	if (m_Bitmap.LoadBitmap(IDC_DIRUP))
    	m_DirUp.SetBitmap(m_Bitmap);

	int res;
	res = m_ImageList.Create(IDR_FILELIST,16,4,0xffffff);
	res = m_ImageList.GetImageCount();
	m_FileList.SetImageList(&m_ImageList, LVSIL_SMALL);
	
	// TODO: Add extra initialization here
	m_FileList.InsertColumn(0, "Name", LVCFMT_LEFT, 214);
	m_FileList.InsertColumn(1, "Date", LVCFMT_LEFT, 100);
	m_FileList.InsertColumn(2, "Size", LVCFMT_LEFT, 70);

	m_FileList.SetExtendedStyle(m_FileList.GetExtendedStyle() | LVS_EX_FULLROWSELECT);

	((CFbbWDlg *)pFbbMain)->RequestDirectory("");

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CListFiles::EndTransfer(char *szFileName)
{
	FILE *fptr;
	char szName[256];
	char szLen[80];
	char szDate[80];
	char szBuf[300];
	int nI = 0;
	int nNb;
	char cType;
	LVITEM LvItem;

	// Open the file and display the content of the directory
	fptr = fopen(szFileName, "r");
	if (fptr == NULL)
		return;

	// Clear the control
	m_FileList.DeleteAllItems();

	// Set the directory Path
	m_Directory = m_Path;

	while (fgets(szBuf, sizeof(szBuf), fptr))
	{
		szDate[0] = '\0';
		nNb = sscanf(szBuf, "%c %s %s %s", &cType, szLen, szName, szDate);
		if (nNb < 3)
			continue;

		int nDay;
		char szMonth[20];
		char szYear[20];
		sscanf(szDate, "%[^-]-%d-%s", szMonth, &nDay, szYear);

		char *mon[12] = { "jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "ocr", "nov", "dec" };
		for (int i=0 ; i < 12 ; i++)
		{
			if (stricmp(mon[i], szMonth) == 0)
				break;
		}

		sprintf(szDate, "%02d/%02d    %s", nDay, i+1, szYear);

		LvItem.mask = LVIF_TEXT | LVIF_IMAGE | LVIF_PARAM | LVIF_STATE;
		LvItem.iItem = nI++;
		LvItem.lParam = cType;
		LvItem.iSubItem = 0;
		LvItem.iImage = 1;
		LvItem.state = 0;
		LvItem.stateMask = 0;
		LvItem.pszText = szName;

		switch (cType)
		{
		case 'd':
			LvItem.iImage = 1;
			m_FileList.InsertItem(&LvItem);

			LvItem.mask = LVIF_TEXT;
			LvItem.iSubItem = 1;
			LvItem.pszText = szDate;
			m_FileList.SetItem(&LvItem);

			break;
		default:
			LvItem.iImage = 0;
			m_FileList.InsertItem(&LvItem);

			LvItem.mask = LVIF_TEXT;
			LvItem.iSubItem = 1;
			LvItem.pszText = szDate;
			m_FileList.SetItem(&LvItem);

			LvItem.mask = LVIF_TEXT;
			LvItem.iSubItem = 2;
			LvItem.pszText = szLen;
			m_FileList.SetItem(&LvItem);

			break;
		}
	}

	fclose (fptr);
	unlink(szFileName);

	m_FileList.SortItems(CompareFunc, 0);
}

void CListFiles::OnDblclkFilelist(NMHDR* pNMHDR, LRESULT* pResult) 
{
	OnOpen();
	*pResult = 0;
}

void CListFiles::OnClickFilelist(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	
	*pResult = 0;
}

void CListFiles::OnItemchangedFilelist(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;

	// TODO: Add your control notification handler code here
	m_FileName = m_FileList.GetItemText(pNMListView->iItem, 0);
	m_FileNameType = (char) m_FileList.GetItemData(pNMListView->iItem);

	UpdateData(FALSE);

	*pResult = 0;
}

void CListFiles::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

void CListFiles::OnColumnclickFilelist(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	// TODO: Add your control notification handler code here
	
	m_FileList.SortItems(CompareFunc, 0);

	*pResult = 0;
}

