// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include <afxpriv.h>
#include "MainFrame.h"
#include "FbbW.h"
#include "FbbWDlg.h"

#include "FbbWeditDoc.h"
#include "FbbWeditView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define MYWM_NOTIFYICON		(WM_USER+1)
#define ID_ICON_SYSTRAY		1

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_MESSAGE(MYWM_NOTIFYICON, OnMYWM_NOTIFYICON)
	ON_WM_CLOSE()
	ON_COMMAND(IDM_MAINEXIT, OnExit)
	ON_WM_MOVE()
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	m_pFbbWDlg = NULL;
	m_bInit = false;
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)		
		return -1;	

	if (!m_wndToolBar.CreateEx(this, 0, WS_CHILD | WS_VISIBLE | CBRS_TOP
		| CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}

	// TODO: Delete these three lines if you don't want the toolbar to
	//  be dockable
	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndToolBar);

	MoveWindow(2000, 2000, 0, 0);

/*
	NOTIFYICONDATA tnid;	
	CString szDummy;						
	
	// Mettre l'icne dans la barre de tches
	szDummy.LoadString(IDS_SYSTRAY_TEXT);	// Nom du toolTip

	tnid.cbSize = sizeof(NOTIFYICONDATA); 	
	tnid.hWnd = m_hWnd; 
	tnid.uID = ID_ICON_SYSTRAY;   // ID de l'icne dans le systray
	tnid.uFlags = NIF_MESSAGE | NIF_ICON | NIF_TIP; 
	tnid.uCallbackMessage = MYWM_NOTIFYICON;			// Message  envoyer pour un vnement
	tnid.hIcon = AfxGetApp()->LoadIcon(IDI_SYSTRAY);	// Icne  afficher dans la barre de tches

	lstrcpyn(tnid.szTip, (LPCTSTR)szDummy, sizeof(tnid.szTip)); 

	if(!Shell_NotifyIcon(NIM_ADD, &tnid))	
	{		// Message si pas OK
		AfxMessageBox(IDS_ERROR_TASKBAR, MB_OK | MB_ICONEXCLAMATION);
		DestroyWindow();
	}
	
	// Autres init ncessaires...	

*/
	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	// the CREATESTRUCT cs
	
//	cs.style = WS_DISABLED;
	
	return CFrameWnd::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

LONG CMainFrame::OnMYWM_NOTIFYICON(WPARAM wParam, LPARAM lParam)
{
	CMenu menu;		
	CPoint point;		

	switch( (UINT) lParam )
	{					
	case WM_RBUTTONDOWN : 
		// Show popup menu		
		GetCursorPos(&point);
		
		if (menu.LoadMenu(IDR_MAINFRAME)) // Load menu		
		{
			CMenu* pPopup = menu.GetSubMenu(0);			
			ASSERT(pPopup != NULL);
			SetForegroundWindow();			
			pPopup->TrackPopupMenu(
					TPM_RIGHTALIGN | TPM_RIGHTBUTTON | TPM_LEFTBUTTON,				point.x, point.y,
					(CWnd*)this);		
		}
		break;

	case WM_LBUTTONDBLCLK :
		if( m_pFbbWDlg == NULL )
		{
			m_pFbbWDlg = new CFbbWDlg;
			m_pFbbWDlg->DoModal();
			delete m_pFbbWDlg;
			m_pFbbWDlg = NULL;
		}
		break;
	}	
	
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

void CMainFrame::OnExit()
{
	if( m_pFbbWDlg != NULL )
	{
		MessageBox("Can't exit until fbbW is in use", NULL, 
			MB_ICONEXCLAMATION);
		return;
	}

	delete this;
}

void CMainFrame::OnClose() 
{
	// TODO: Add your message handler code here and/or call default
	CSingleDocTemplate *cDT = ((CFbbWApp*)AfxGetApp())->pDocTemplate;
	POSITION rPos = cDT->GetFirstDocPosition();
	CFbbWeditDoc *cDoc = (CFbbWeditDoc *)cDT->GetNextDoc(rPos);
	CString csPathName = cDoc->GetPathName();

	cDoc->OnSaveDocument(csPathName.GetBuffer(256));
}

void CMainFrame::OnMove(int x, int y) 
{
	CFrameWnd::OnMove(x, y);
	
	// TODO: Add your message handler code here
	if (!m_bInit)
		return;
	
	RECT Rect;
	GetWindowRect(&Rect);

	char szName[80];
	sprintf(szName, "Position_e");

	char szStr[80];
	sprintf(szStr, "%04d %04d", Rect.left, Rect.top);
	((CFbbWApp *)AfxGetApp())->WriteIni("Settings", szName, szStr);
}

void CMainFrame::OnSize(UINT nType, int cx, int cy) 
{
	CFrameWnd::OnSize(nType, cx, cy);
	
	// TODO: Add your message handler code here
	if (!m_bInit)
		return;

	RECT Rect;
	GetWindowRect(&Rect);

	char szName[80];
	sprintf(szName, "Size_e");
	
	char szStr[80];
	sprintf(szStr, "%04d %04d", Rect.right-Rect.left, Rect.bottom-Rect.top);
	((CFbbWApp *)AfxGetApp())->WriteIni("Settings", szName, szStr);
	

}

