// UserInfos.cpp : implementation file
//

#include "stdafx.h"
#include "fbbw.h"
#include "UserInfos.h"
#include "fbb_orb.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CUserInfos dialog


CUserInfos::CUserInfos(CWnd* pParent /*=NULL*/)
	: CDialog(CUserInfos::IDD, pParent)
{
	//{{AFX_DATA_INIT(CUserInfos)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CUserInfos::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CUserInfos)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CUserInfos, CDialog)
	//{{AFX_MSG_MAP(CUserInfos)
	ON_WM_SHOWWINDOW()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CUserInfos message handlers

void CUserInfos::SetInfoLine(char *pLine, UINT uLength)
{
	pLine[uLength] = '\0';
	
	char *ptr;

	// skip "INFO" line
	ptr = strtok(pLine, "\n");
	
	// Get the command
	while (ptr = strtok(NULL, "\n"))
	{
		
		int nControl = atoi(ptr);
		
		while (isdigit(*ptr))
			++ptr;
		
		while (isspace(*ptr))
			++ptr;
		
		switch(nControl)
		{
		case IYapp :
			nControl = IDC_INFO;
			break;
		case ICall :
			nControl = IDC_CALLSIGN;
			break;
		case IDigis :
			nControl = IDC_DIGIS;
			break;
		case IName :
			OemToChar(ptr, ptr);
			nControl = IDC_NAME;
			break;
		case IHome :
			nControl = IDC_HOME;
			break;
		case IChan :
			nControl = IDC_CHANNEL;
			break;
		case IPort :
			nControl = IDC_PORT;
			break;
		case IN1N2N3 :
			nControl = IDC_LEVEL;
			break;
		case IFlags :
			nControl = IDC_FLAGS;
			break;
		case IPaclen :
			nControl = IDC_PACLEN;
			break;
		case IStatus :
			nControl = IDC_STATUS;
			break;
		case IMem :
			nControl = IDC_MEMORY;
			break;
		case IBuf :
			nControl = IDC_BUFFERS;
			break;
		case IRet :
			nControl = IDC_RETRIES;
			break;
		case IPerso :
			nControl = IDC_PRIVATE;
			break;
		case IUnread :
			nControl = IDC_UNREAD;
			break;
		}
		
		if (nControl)
			SendDlgItemMessage(nControl, WM_SETTEXT, 0, (LPARAM)ptr);
	}
}

void CUserInfos::OnShowWindow(BOOL bShow, UINT nStatus) 
{
	CDialog::OnShowWindow(bShow, nStatus);

	if (!bShow)
	{
		char *ptr = "";
		SendDlgItemMessage(IDC_INFO, WM_SETTEXT, 0, (LPARAM)ptr);
		SendDlgItemMessage(IDC_CALLSIGN, WM_SETTEXT, 0, (LPARAM)ptr);
		SendDlgItemMessage(IDC_DIGIS, WM_SETTEXT, 0, (LPARAM)ptr);
		SendDlgItemMessage(IDC_NAME, WM_SETTEXT, 0, (LPARAM)ptr);
		SendDlgItemMessage(IDC_HOME, WM_SETTEXT, 0, (LPARAM)ptr);
		SendDlgItemMessage(IDC_CHANNEL, WM_SETTEXT, 0, (LPARAM)ptr);
		SendDlgItemMessage(IDC_PORT, WM_SETTEXT, 0, (LPARAM)ptr);
		SendDlgItemMessage(IDC_LEVEL, WM_SETTEXT, 0, (LPARAM)ptr);
		SendDlgItemMessage(IDC_FLAGS, WM_SETTEXT, 0, (LPARAM)ptr);
		SendDlgItemMessage(IDC_PACLEN, WM_SETTEXT, 0, (LPARAM)ptr);
		SendDlgItemMessage(IDC_STATUS, WM_SETTEXT, 0, (LPARAM)ptr);
		SendDlgItemMessage(IDC_MEMORY, WM_SETTEXT, 0, (LPARAM)ptr);
		SendDlgItemMessage(IDC_BUFFERS, WM_SETTEXT, 0, (LPARAM)ptr);
		SendDlgItemMessage(IDC_RETRIES, WM_SETTEXT, 0, (LPARAM)ptr);
		SendDlgItemMessage(IDC_PRIVATE, WM_SETTEXT, 0, (LPARAM)ptr);
		SendDlgItemMessage(IDC_UNREAD, WM_SETTEXT, 0, (LPARAM)ptr);
	}
}

void CUserInfos::OnOK() 
{
	ShowWindow(SW_HIDE);
}

void CUserInfos::OnCancel() 
{
	ShowWindow(SW_HIDE);
}
