// fbbWeditDoc.cpp : implementation of the CFbbWeditDoc class
//

#include "stdafx.h"
#include "fbbW.h"
#include "fbbWDlg.h"

#include "fbbWeditDoc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFbbWeditDoc

IMPLEMENT_DYNCREATE(CFbbWeditDoc, CDocument)

BEGIN_MESSAGE_MAP(CFbbWeditDoc, CDocument)
	//{{AFX_MSG_MAP(CFbbWeditDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFbbWeditDoc construction/destruction

CFbbWeditDoc::CFbbWeditDoc()
{
	// TODO: add one-time construction code here
}

CFbbWeditDoc::~CFbbWeditDoc()
{
}

BOOL CFbbWeditDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	((CEditView*)m_viewList.GetHead())->SetWindowText(NULL);

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)

	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
// CFbbWeditDoc serialization

void CFbbWeditDoc::Serialize(CArchive& ar)
{
	// CEditView contains an edit control which handles all serialization
	((CEditView*)m_viewList.GetHead())->Serialize(ar);

}

/////////////////////////////////////////////////////////////////////////////
// CFbbWeditDoc diagnostics

#ifdef _DEBUG
void CFbbWeditDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CFbbWeditDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CFbbWeditDoc commands

BOOL CFbbWeditDoc::OnSaveDocument(LPCTSTR lpszPathName) 
{
	CDocument::OnSaveDocument(lpszPathName);

	if (MainDlg->m_bMessage)
	{
		switch(MessageBox(AfxGetMainWnd()->GetSafeHwnd(), "Send message", "Editor", MB_YESNOCANCEL))
		{
		case IDYES:
			if (SaveFormattedText(lpszPathName))
			{
				AfxGetMainWnd()->ShowWindow(SW_HIDE);
				MainDlg->ShowWindow(SW_SHOWNORMAL);
				MainDlg->SendMsgData((char *)lpszPathName, false);
				MainDlg->m_bMessage = false;	
				MainDlg->ConsoleFocus();
				DeleteContents();
				return 1;
			}
			else
				return 0;
		case IDNO:
			// SaveFormattedText(lpszPathName);	// **** A SUPPRIMER !!! ***
			AfxGetMainWnd()->ShowWindow(SW_HIDE);
			MainDlg->ShowWindow(SW_SHOWNORMAL);
			MainDlg->SendMsgData((char *)lpszPathName, true);
			MainDlg->m_bMessage = false;
			MainDlg->ConsoleFocus();
			DeleteContents();
			return 1;
		case IDCANCEL:
			return 0;
		}
	}
	else
	{
		switch(MessageBox(AfxGetMainWnd()->GetSafeHwnd(), "Upload document", "Editor", MB_YESNOCANCEL))
		{
		case IDYES:
			AfxGetMainWnd()->ShowWindow(SW_HIDE);
			MainDlg->ShowWindow(SW_SHOWNORMAL);
			MainDlg->SendFile((char *)lpszPathName);
			MainDlg->ConsoleFocus();
			DeleteContents();
			return 1;
		case IDNO:
			unlink((char *)lpszPathName);
			AfxGetMainWnd()->ShowWindow(SW_HIDE);
			MainDlg->ShowWindow(SW_SHOWNORMAL);
			MainDlg->ConsoleFocus();
			DeleteContents();
			return 1;
		case IDCANCEL:
			return 0;
		}
	}
	
	return 0;
}

void CFbbWeditDoc::DeleteContents() 
{
	// TODO: Add your specialized code here and/or call the base class
	
	if (m_viewList.IsEmpty()) 
		return;

	CEditView* pView = (CEditView*)m_viewList.GetHead(); 
	ASSERT_KINDOF(CEditView, pView); 

	pView->SetWindowText("");

	CEdit& Edit = pView->GetEditCtrl();
	Edit.SetModify();

	// Update the control shadow cache !
	pView->LockBuffer();
	pView->UnlockBuffer();
}

#define LINE_LEN 78

BOOL CFbbWeditDoc::SaveFormattedText(LPCTSTR lpszPathName)
{
	char szLine[82];
	int nScan;

	// Get the CEditView
	if (!MainDlg->m_bBreak || m_viewList.IsEmpty()) 
		return true; 

	dump();

	CEditView* pView = (CEditView*)m_viewList.GetHead(); 
	ASSERT_KINDOF(CEditView, pView); 

	int nLen = pView->GetBufferLength();
	LPCSTR pStr = pView->LockBuffer();

	FILE * fPtr;
	fPtr = fopen(lpszPathName, "wb");
	if (fPtr == NULL)
	{
		pView->UnlockBuffer();
		return false;
	}

	int nPos = 0;
	char c;

	for (nScan = 0 ; nScan < nLen ; )
	{
		c = pStr[nScan++];

		if (c == '\n')
			continue;

		if (c == '\r')
		{
			szLine[nPos++] = '\r';
			szLine[nPos++] = '\n';

			if (fwrite(szLine, nPos, 1, fPtr) != 1)
			{
				fclose(fPtr);
				pView->UnlockBuffer();
				return false;
			}

			nPos = 0;
			continue;
		}

		szLine[nPos++] = c;

		if (nPos >= LINE_LEN)
		{
			// Search the previous space to insert a CrLf
			int nCur = nPos;
			int nBack = nScan;

			while (nCur >= 0)
			{
				if (szLine[nCur] == ' ')
				{
					nScan = nBack+1;
					nPos = nCur;

					if (MainDlg->m_bJust)
					{
						// Justify the text ...
						szLine[nPos] = '\0';
						nPos = justifie(szLine);
					}

					break;
				}
				--nBack;
				--nCur;
			}

			szLine[nPos++] = '\r';
			szLine[nPos++] = '\n';

			if (fwrite(szLine, nPos, 1, fPtr) != 1)
			{
				fclose(fPtr);
				pView->UnlockBuffer();
				return false;
			}

			nPos = 0;
		}
	}

	if (nPos && fwrite(szLine, nPos, 1, fPtr) != 1)
	{
		fclose(fPtr);
		pView->UnlockBuffer();
		return false;
	}

	fclose(fPtr);
	pView->UnlockBuffer();

	dump();

	return true;
}

int CFbbWeditDoc::justifie(char *buffer)
{
	char ligne[83];
	char *ptr, *ptri, *ptro;
	int nb_sp = 0;
	int nb_mot = 1;
	int nb_car = 0;
	int k, sp_int, sp_rst, i_sp, j_sp, nb_int;
	BOOL ds_mot, k_sp;

	ptri = buffer;
	ptro = ligne;
	while ((*ptri) && (*ptri == ' '))
	{
		++nb_car;
		*ptro++ = *ptri++;
	}

	if (*ptri)
	{
		ptr = ptri;
		ds_mot = true;

		while (*ptr)
		{
			++nb_car;
			if (*ptr == ' ')
			{
				++nb_sp;
				if (ds_mot)
				{
					ds_mot = false;
					nb_mot++;
				}
			}
			else
				ds_mot = true;
			++ptr;
		}

		if (nb_mot > 1)
		{
			nb_int = nb_mot - 1;
			nb_sp += (LINE_LEN - nb_car);
			sp_int = nb_sp / nb_int;
			sp_rst = nb_sp % nb_int;
			if (sp_rst > (nb_int / 2))
			{
				k_sp = false;
				sp_rst = nb_int - sp_rst;
				i_sp = (sp_rst % 2) ? nb_int / (sp_rst + 1) : nb_int / sp_rst;
			}
			else
			{
				k_sp = true;
				if (sp_rst)
					i_sp = (sp_rst % 2) ? nb_int / (sp_rst + 1) : nb_int / sp_rst;
				else
					i_sp = 0;
			}
			j_sp = 0;

			while (*ptri)
			{
				if (*ptri == ' ')
				{
					for (k = 0; k < sp_int; k++)
						*ptro++ = ' ';
					while (*++ptri == ' ')
						;
					if (k_sp)
					{
						if (sp_rst)
						{
							if (++j_sp == i_sp)
							{
								*ptro++ = ' ';
								j_sp = 0;
								sp_rst--;
							}
						}
					}
					else
					{
						if (sp_rst)
						{
							if (++j_sp != i_sp)
							{
								*ptro++ = ' ';
							}
							else
							{
								j_sp = 0;
								sp_rst--;
							}
						}
						else
						{
							*ptro++ = ' ';
						}
					}
				}
				else
					*ptro++ = *ptri++;
			}
			*ptro = '\0';
			ptr = ligne;
			ptri = buffer;
			while (*ptri++ = *ptr++);
		}
	}

	return strlen(buffer);
}

BOOL CFbbWeditDoc::OnOpenDocument(LPCTSTR lpszPathName) 
{
	if (!CDocument::OnOpenDocument(lpszPathName))
		return FALSE;
	
	dump();

	MainDlg = (CFbbWDlg *)((CFbbWApp*)AfxGetApp())->MainDlg;

	if (MainDlg->m_bMessage)
	{
		Prefix();
		Signature();
	}

	return TRUE;
}

void CFbbWeditDoc::Prefix()
{
	// Get the CEditView
	if (!MainDlg->m_bPrefix || m_viewList.IsEmpty()) 
		return; 

	CEditView* pView = (CEditView*)m_viewList.GetHead(); 
	ASSERT_KINDOF(CEditView, pView); 

	UINT nLen = pView->GetBufferLength();
	if (nLen == 0)
		return;

	CEdit& Edit = pView->GetEditCtrl();

	// Insert all prefixes
	nLen = pView->GetBufferLength();
	if (nLen == 0)
		return;

	while (pView->FindText("\r\n"))
		Edit.ReplaceSel("\r\n>");

	// Back to the beginning of the message
	Edit.SetSel(0, 0);

	// First line
	Edit.ReplaceSel("\r\n>");

	// Back to the beginning of the message
	Edit.SetSel(0, 0);
}

void CFbbWeditDoc::Signature()
{
	if (!MainDlg->m_bSignature)
		return;

	CEditView* pView = (CEditView*)m_viewList.GetHead(); 
	ASSERT_KINDOF(CEditView, pView); 

	UINT nLen = pView->GetBufferLength();
	CEdit& Edit = pView->GetEditCtrl();

	Edit.SetSel(nLen, nLen, FALSE);

	// First line
	Edit.ReplaceSel(MainDlg->m_cSignature);

	// Back to the beginning of the message
	Edit.SetSel(0, 0);
}

void CFbbWeditDoc::dump()
{
	static int nb=1;
	char filename[256];

	wsprintf(filename, "debug_%d.txt", nb++);
	FILE *fptr = fopen(filename, "w");
	if (fptr == NULL)
		return;

	CEditView* pView = (CEditView*)m_viewList.GetHead(); 
	ASSERT_KINDOF(CEditView, pView); 

	int nLen = pView->GetBufferLength();
	LPCSTR pStr = pView->LockBuffer();

	int nPos = 0;

	while (nPos < nLen)
	{
		int nI;
		int nNb = nLen - nPos;
		if (nNb > 16)
			nNb = 16;

		fprintf(fptr, "%04d", nPos);

		for (nI = 0 ; nI < nNb ; nI++)
		{
			fprintf(fptr, " %02x", pStr[nPos+nI]);
		}
		for (nI = nNb ; nI < 16 ; nI++)
		{
			fprintf(fptr, "   ");
		}
		fprintf(fptr, " ");

		for (nI = 0 ; nI < nNb ; nI++)
		{
			fprintf(fptr, "%c", (pStr[nPos+nI] > 0x20) ? pStr[nPos+nI] : '.');
		}
		fprintf(fptr, "\n");

		nPos += nNb;
	}

	pView->UnlockBuffer();
	fclose(fptr);
}
