// Buffer.cpp: implementation of the CBuffer class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "fbbW.h"
#include "Buffer.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CBuffer::CBuffer(UCHAR *buf, int len)
{
	pBuf = new UCHAR[len+1];
	if (pBuf)
	{
		memcpy(pBuf, buf, len);
		pBuf[len] = '\0';
	}
	nLen = len;
	pNext = NULL;
}

CBuffer::~CBuffer()
{
}

//////////////////////////////////////////////////////////////////////
// CBufList Class
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CBufList::CBufList()
{
	pHead = pLast = NULL;
}

CBufList::~CBufList()
{
	CBuffer *pBuffer = pHead;

	// Detruire la liste !
	while (pHead)
	{
		pBuffer = pHead;
		pHead = pHead->pNext;
		delete [] pBuffer->pBuf;
		delete pBuffer;
	}
}

BOOL CBufList::Put(UCHAR *buf, int len)
{
	if (pHead)
	{
		pLast->pNext = new CBuffer(buf, len);
		if (pLast->pNext == NULL)
			return FALSE;
		pLast = pLast->pNext;
	}
	else
	{
		pHead = pLast = new CBuffer(buf, len);
		if (pHead == NULL)
			return FALSE;
	}

	return TRUE;
}

UCHAR *CBufList::Get(int *len)
{
	CBuffer *pBuffer = pHead;

	if (pBuffer)
	{
		pHead = pHead->pNext;
		UCHAR *ptr = pBuffer->pBuf;
		*len = pBuffer->nLen;
		delete pBuffer;
		return ptr;
	}

	return NULL;
}

