// fbbW.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include <afxpriv.h>
#include "fbbW.h"
#include "fbbWDlg.h"
#include "MainFrame.h"
#include "fbbWeditDoc.h"
#include "fbbWeditView.h"
#include "ListFiles.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

class CCommandLine : public CCommandLineInfo
{
// Construction
public:
	CCommandLine()  // standard constructor
	{
		m_strHostName = "";
	}

	void ParseParam( LPCTSTR lpszParam, BOOL bFlag, BOOL bLast );

	CString m_strHostName;
	/*
	enum {
		FileRemoteHost
	} m_nShellCommand;
	*/
};

void CCommandLine::ParseParam( LPCTSTR lpszParam, BOOL bFlag, BOOL bLast )
{
	if (!bFlag && bLast)
		m_strHostName = lpszParam;
	/*	
	if (bFlag && strcmp(lpszParam, "host") == 0)
	{
		m_nShellCommand = FileRemoteHost;
		return;
	}

	if (m_nShellCommand == FileRemoteHost)
		m_strHostName = lpszParam;
	else
		CommandLineInfo::ParseParam(lpszParam, bFlag, bLast); 
	*/
}

/////////////////////////////////////////////////////////////////////////////
// CFbbWApp

BEGIN_MESSAGE_MAP(CFbbWApp, CWinApp)
	//{{AFX_MSG_MAP(CFbbWApp)
	//}}AFX_MSG_MAP
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
	// Standard print setup command
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFbbWApp construction

CFbbWApp::CFbbWApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance

	CHAR szBuffer[_MAX_DIR];
	GetWindowsDirectory(szBuffer, sizeof szBuffer);
	m_strIniFile.Format("%s\\FbbW.ini", szBuffer);
	m_nNumConfig = -1;
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CFbbWApp object

CFbbWApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CFbbWApp initialization

BOOL CFbbWApp::InitInstance()
{
#ifdef _DEBUG
	afxTraceEnabled = 1;
	afxTraceFlags = 1;
#endif

	if (!AfxSocketInit())
	{
		AfxMessageBox(IDP_SOCKETS_INIT_FAILED);
		return FALSE;
	}

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	AfxInitRichEdit();
/*

#ifdef _NOSYSTRAY	// Non systray appl

	CFbbWDlg dlg;
	m_pMainWnd = &dlg;
	int nResponse = dlg.DoModal();
	if (nResponse == IDOK)
	{
		// TODO: Place code here to handle when the dialog is
		//  dismissed with OK
	}
	else if (nResponse == IDCANCEL)
	{
		// TODO: Place code here to handle when the dialog is
		//  dismissed with Cancel
	}

#else	// _NOSYSTRAY

	CMainFrame* pMainFrame = new CMainFrame;
	if (!pMainFrame->LoadFrame(IDR_MAINFRAME))		
		return FALSE;
	m_pMainWnd = pMainFrame;	
	
	m_pMainWnd->ShowWindow(SW_HIDE);
	m_pMainWnd->UpdateWindow();

	return TRUE;

#endif // _NOSYSTRAY

	// Since the dialog has been closed, return FALSE so that we exit the
	//  application, rather than start the application's message pump.
	return FALSE;
*/
	// Change the registry key under which our settings are stored.
	// TODO: You should modify this string to be something appropriate
	// such as the name of your company or organization.
	SetRegistryKey(_T("Local AppWizard-Generated Applications"));

	LoadStdProfileSettings(0);  // Load standard INI file options (including MRU)

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

//	CSingleDocTemplate* pDocTemplate;
	pDocTemplate = new CSingleDocTemplate(
		IDR_MAINFRAME,
		RUNTIME_CLASS(CFbbWeditDoc),
		RUNTIME_CLASS(CMainFrame),       // main SDI frame window
		RUNTIME_CLASS(CFbbWeditView));
	AddDocTemplate(pDocTemplate);

	// Parse command line for standard shell commands, DDE, file open
	CCommandLine cmdInfo;
	ParseCommandLine(cmdInfo);

	m_strHostName = cmdInfo.m_strHostName;

	// Dispatch commands specified on the command line
	if (!ProcessShellCommand(cmdInfo))
		return FALSE;

	// The one and only window has been initialized, so show and update it.
	m_pMainWnd->ShowWindow(SW_HIDE);
	m_pMainWnd->UpdateWindow();

	MainDlg = new CFbbWDlg;
	MainDlg->Create(IDD_FBBW_DIALOG, m_pMainWnd);
	MainDlg->ShowWindow(SW_SHOW);

	char szStr[80];
	int nXPos = 0;
	int nYPos = 0;
	int nWidth = 600;
	int nHeight = 400;
	if (ReadIni("Settings", "Size_e", szStr))
	{
		sscanf(szStr, "%04d %04d", &nWidth, &nHeight);
		if (ReadIni("Settings", "Position_e", szStr))
		{
			sscanf(szStr, "%04d %04d", &nXPos, &nYPos);
		}
	}

	m_pMainWnd->MoveWindow(nXPos, nYPos, nWidth, nHeight);

	((CMainFrame *)m_pMainWnd)->m_bInit = true;

	return TRUE;
}

BOOL CFbbWApp::RunEditor(char *FileName)
{
	MainDlg->ShowWindow(SW_SHOWMINIMIZED);
	m_pMainWnd->ShowWindow(SW_SHOW);

	// if (FileName)
	pDocTemplate->OpenDocumentFile(FileName);
	/*else
		pDocTemplate->CreateNewDocument(); */

	return TRUE;
}


BOOL CFbbWApp::OnIdle(LONG lCount) 
{
	// TODO: Add your specialized code here and/or call the base class
	if (lCount == 0 && MainDlg->IsWindowVisible())
		MainDlg->SendMessageToDescendants(WM_IDLEUPDATECMDUI,
				(WPARAM)TRUE, 0, TRUE, TRUE);
	
	return CWinApp::OnIdle(lCount);
}

void CFbbWApp::WriteIni(LPSTR szName, LPSTR szString)
{
	CString strSegment;
	strSegment.Format("Remote %d", m_nNumConfig);
	WritePrivateProfileString(strSegment, szName, szString, m_strIniFile);
}

void CFbbWApp::WriteIni(LPSTR szChap, LPSTR szName, LPSTR szString)
{
	WritePrivateProfileString(szChap, szName, szString, m_strIniFile);
}

int CFbbWApp::ReadIni(LPSTR szName, int nDef)
{
	char szVal[80];
	CString strSegment;
	strSegment.Format("Remote %d", m_nNumConfig);
	if (GetPrivateProfileString(strSegment, szName, "", szVal, 80, m_strIniFile) != 0)
		return atoi(szVal);
	return nDef;
}

BOOL CFbbWApp::ReadIni(LPSTR szName, LPSTR szString)
{
	CString strSegment;
	strSegment.Format("Remote %d", m_nNumConfig);
	return (GetPrivateProfileString(strSegment, szName, "", szString, 80, m_strIniFile) != 0);
}

BOOL CFbbWApp::ReadIni(LPSTR szChap, LPSTR szName, LPSTR szString)
{
	// Set the dialog position
	return (GetPrivateProfileString(szChap, szName, "" , szString, 80, m_strIniFile) != 0);
}

BOOL CFbbWApp::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: Add your specialized code here and/or call the base class
	if (pMsg->message == WM_KEYDOWN)
	{
		switch(pMsg->wParam)
		{
		case VK_F2:
			MainDlg->SendMessage(WM_COMMAND, IDM_CONSOLE);
			return true;
		case VK_F4:
			MainDlg->SendMessage(WM_COMMAND, IDM_FORWARD);
			return true;
		case VK_F5:
			MainDlg->SendMessage(WM_COMMAND, IDM_MONITORING);
			return true;
		case VK_F6:
			MainDlg->SendMessage(WM_COMMAND, IDM_ALLCHANNELS);
			return true;
		}
	}
	
	
	return CWinApp::PreTranslateMessage(pMsg);
}


void CFbbWApp::SetEditorFont(CFont *pFont)
{
	POSITION Pos = pDocTemplate->GetFirstDocPosition();
	if (Pos == NULL)
		return;

	CFbbWeditDoc *pDoc = (CFbbWeditDoc *)pDocTemplate->GetNextDoc(Pos);
	if (pDoc == NULL)
		return;

	Pos = pDoc->GetFirstViewPosition();
	if (Pos == NULL)
		return;

    CFbbWeditView *pView = (CFbbWeditView *)pDoc->GetNextView(Pos);
	if (pView == NULL)
		return;

    pView->SetFont(pFont);
}
