REM Recover Program
REM Written by N5VGC, Presley
REM 
REM This program was written when my system hung up and required a reload
REM from a previous backup.  There were a series of priviate files with a
REM status of PN that I did not want to loose.  In order to use the program,
REM if you have such a problem, you must keep the DIRMES.SYS file and all
REM the MAIL directories.  I backed all that up before I reloaded the system
REM from a previous backup...
REM This program will read the DIRMES.SYS file that has been saved and will
REM create a header for each PN message file.  It will then read that message
REM file and add it to the output file thus creating an import file in the 
REM FBB import format.   When completed, you import that file and have 
REM Recovered the message files...
REM  
REM  This program can be run with QBASIC that is shipped on all DOS systems.
REM  You will need to set the file names and directories correctly.
REM  Obviously, if you DIRMES.SYS is destroyed, this will NOT work.
REM
REM  The Author makes no claims as to how this will work, but it did the 
REM  job for me.  I wanted to share it with others.  If you have questions
REM  or problems with it, I can be reached at N5VGC @ N5VGC.#DFW.TX.USA.NA
REM  of via internet at psmith@convex.com
REM
REM  Good luck with your recovery.    73 Presley  N5VGC
REM
REM

REM  This is the structure of the DIRMES.SYS record...

TYPE Header
Typex   AS STRING * 1
Statx   AS STRING * 1
Long1   AS LONG
Long2   AS LONG
Long3   AS LONG
Bbsf    AS STRING * 7
Bbsv    AS STRING * 41
Exped   AS STRING * 7
Desti   AS STRING * 7
Bid     AS STRING * 13
Titre   AS STRING * 61
Freex   AS STRING * 16
Datesd  AS LONG
Datech  AS LONG
Fbbs    AS STRING * 10
Forw    AS STRING * 10
END TYPE

DIM Head AS Header

REM OPEN THE DIRMES.SYS FILE AND THE IMPORT FILE

OPEN "DIRMES.SYS" FOR RANDOM AS #3 LEN = 194
OPEN "LIST.XXX" FOR OUTPUT AS #4 

j% = 0

rem  FOR i% = 1 to 1000
i% = 1

DO UNTIL EOF (3)

GET #3, i%, Head

i% = i% + 1

x% = LEN (Head.Typex)
y% = LEN (Head.Statx)
z% = LEN (Head.Titre)

REM select only PN records and PH records... you many change this.

IF Head.Typex < > "P" GOTO nexit
IF Head.Statx = "H" GOTO outit
IF Head.Statx = "N" GOTO outit
GOTO nexit

REM  Since C ends each string with hex 00, I must scan for that and set
REM  the string length accordingly... that's what getstr () does...

outit:

form$ = "\\\\ ###### ###### \      \\       \\              \\                          \"
PRINT "TYPE:      ", Head.Typex
PRINT "STATUS:    ", Head.Statx
PRINT "MES NUMBR: ", Head.Long1
PRINT "MES SIZE:  ", Head.Long2
PRINT "MES DATE:  ", Head.Long3
PRINT "ADJ BBS:   ", Head.Bbsf

z% = 41
CALL getstr (z%,l%,Head.Bbsv,atbbs$)
IF l% = 0  THEN atbbs$ = "N5VGC"
PRINT "ROUTE:     ", Head.Bbsv, atbbs$

z% = 7
CALL getstr (z%,l%,Head.Exped,initbbs$)
PRINT "DESTIN:    ", Head.Exped, initbbs$

z% = 7
CALL getstr (z%,l%,Head.Desti,to$)
PRINT "TO:        ", Head.Desti, to$

z% = 13
CALL getstr (z%,l%,Head.Bid,bid$)
PRINT "BID/MID:   ",Head.bid, bid$

z% = 61
CALL getstr (z%,l%,Head.Titre,title$)
PRINT "Title:     ", Head.Titre, title$

PRINT "Reserve:   ", Head.Freex
PRINT "Date Frst: ", Head.Datesd
PRINT "Date Stat: ", Head.Datech
PRINT "FWD MSK:   ", Head.Fbbs
PRINT "DONE MSK:  ", Head.Forw

REM  This just prints the record so I can verify it's okay...

PRINT using form$;  Head.Typex, Head.Statx, Head.Long1, Head.Long2, Head.Exped, Head.Desti,bid$,title$

REM  This sets up the SP line for the import file...

header$ = "SP " + to$ + " @ " + atbbs$ + " < " + initbbs$ + " $" + bid$

PRINT header$
PRINT title$

num$ = str$(Head.Long1)
num2$ = str$(Head.Long2)

REM  This determines the right file name in the MAIL directory to open...

IF LEN(num$) = 4 THEN numz$ = RIGHT$(num$, 3)
IF LEN(num$) = 5 THEN numz$ = RIGHT$(num$, 4)
IF LEN(num$) = 6 THEN numz$ = RIGHT$(num$, 5)

IF LEN(numz$) = 3 THEN numz1$ = "000" + numz$
IF LEN(numz$) = 4 THEN numz1$ = "00" + numz$
IF LEN(numz$) = 5 THEN numz1$ = "0" + numz$

dir$ = RIGHT$(numz1$, 1)

filenamex$ = "d:\fbb\mail\mail" + dir$ + "\m_" + numz1$ + ".mes"

PRINT filenamex$

REM  This opens the MAIL file...

OPEN filenamex$ FOR INPUT AS #6

REM This outpus the header file and the title of the message.

PRINT #4, header$
PRINT #4, title$

REM  This reads the detail MAIL file and outputs to the import file...

DO UNTIL EOF (6)
LINE INPUT #6, file6$
PRINT #4, file6$
PRINT file6$

LOOP

REM  This outputs the /ex 

CLOSE #6
PRINT "/EX"
PRINT #4, "/EX"

nexit:
CLS
LOOP

REM  DONE !!!! 

CLOSE #3
CLOSE #4

END

REM Get real length of the string from the C record...
REM z% length of input string
REM l% length of output string  0 = null string
REM in$ input string
REM out$ output string

SUB getstr (z%,l%,in$,out$)
for k% = 1 to z%

char$ = MID$(in$,k%,1)
num% = ASC(char$)
rem Print num%
if num% = 0 goto stopscan2
next

stopscan2:
out$ = MID$(in$,1,k%-1)
l% = LEN (out$)
END SUB
