
Unit s_Conv;

Interface

Uses Drivers, Objects, Views, Dialogs, Strings, Validate, ConfFile, SetForm;

Type

   { Conversd parameters }
  PConv = ^TConv;
  TConv = object(TDialog)
    Backup       : PConfig;
    Abandon      : Boolean;
    Usr_Timeout  : PWordEntry;

    DefaultChan  : PWordEntry;
    ConvHostName : PCStr;

    constructor Init;
    destructor Done; virtual;
    constructor Load(var S: TStream);
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure Store(var S: TStream);
  end;

Const
  RConv: TStreamRec = (
     ObjType: 10047;
     VmtLink: Ofs(TypeOf(TConv)^);
     Load:    @TConv.Load;
     Store:   @TConv.Store
  );

Procedure RegisterConvForm;

Implementation { ********************************************************* }

Uses
  MsgBox;

 { *** TConv *** *** *** *** *** *** *** *** *** *** *** *** *** }

Constructor TConv.Init;
Var
  R : TRect;
Const
  InfoXEnd   = 25;
  EntryXPos  = 26;
Begin

  R.Assign(0, 0, 41, 9);
  inherited Init(R,'Conference mode settings');


  R.Assign(EntryXPos,2,EntryXPos + 7,3);
  DefaultChan := New(PWordEntry, Init(R,@Conf^.Conv.DefaultChan,5,1,32767));
  Insert(DefaultChan);

  R.Assign(2, 2, InfoXEnd, 3);
  Insert(New(PLabel, Init(R, 'Default ~c~hannel:', DefaultChan)));

  R.Assign(EntryXPos,4,EntryXPos + 12, 5);
  ConvHostName := New(PCStr, Init(R,@Conf^.Conv.ConvHostName,10));
  Insert(ConvHostName);

  R.Assign(2, 4, InfoXEnd, 5);
  Insert(New(PLabel, Init(R, 'Conference ~h~ost name:', ConvHostName)));


  R.Assign(9, 6, 19, 8);
  Insert(New(PButton, Init(R, 'O~K~', cmOk, bfDefault)));
  Inc(R.A.X, 12); Inc(R.B.X, 12);
  Insert(New(PButton, Init(R, 'Cancel', cmCancel, bfNormal)));

  SelectNext(False);
  Options := Options or ofCentered or OfSelectable;
  EventMask := evKeyDown + evCommand + evBroadcast;
  Abandon := False;
  New(Backup);
  Backup^ := Conf^;

End;

Destructor TConv.Done;
Begin

 inherited Done;

 If Abandon
   then Begin
        Dispose(Conf);
        Conf := Backup;
        End
   else Dispose(Backup);

End;

Constructor TConv.Load(var S: TStream);
Begin
  inherited Load(S);
End;

Procedure TConv.HandleEvent(var Event: TEvent);
Begin

  Case Event.What of
    evCommand: Case Event.Command of
                 cmCancel : Abandon := True;
               End;
  End;
  inherited HandleEvent(Event);

End;

Procedure TConv.Store(var S: TStream);
Begin
  TView.Store(S);
{  S.Write(Status, SizeOf(Status) + SizeOf(Number) + SizeOf(Sign) +
    SizeOf(Operator) + SizeOf(Operand));}
End;


Procedure RegisterConvForm;
Begin
  RegisterType(RConv);
End;

End.
