
#include <stdio.h>
#include <string.h>

#include "csock.h"
#include "cmd_net.h"
#include "network.h"
#include "net_user.h"

/*
 *	Node listing, with fancy 2-column display
 */

char *nodestr(struct node_t *n)
{
	static char s[40];
	
	sprintf(s, "%-10.10s", n->call);
	if (n->via)
		sprintf(s + strlen(s), "%-10.10s", n->via->call);
	else
		strcat(s, "          ");
		
	return s;
}

int cmd_nodes(struct csock_t *s, int argc, char **argv)
{
	struct node_t *n1 = nodes, *n2 = nodes;
	int i;
	
	for (i = 0; i <= node_count/2; i++)
		n2 = n2->next; /* Halfway up the list */
	
	csprintf(s, "Nodes: %d (max %d), %d links\n",
		node_count, node_max, link_count);
	csputs(s, "Node      Via       Node      Via\n");
	while (n1) {
		csputs(s, nodestr(n1));
		if (n2) {
			csputc(s, ' ');
			csputs(s, nodestr(n2));
			n2 = n2->next;
		}
		csputc(s, '\n');
		n1 = n1->next;
	}
	
	return 0;
}

/*
 *	User listing
 */

int cmd_users(struct csock_t *s, int argc, char **argv)
{
	struct node_t *n;
	struct nuser_t *u;
	char st[80];
	int i;
	
	csprintf(s, "Users: %d (max %d) on %d nodes, %d links\n",
		nuser_count, nuser_max, node_count, link_count);
	csputs(s, "Node      Users\n");
	
	for (n = nodes; (n); n = n->next) {
		sprintf(st, "%-9.9s", n->call);
		i = 0;
		
		for (u = nusers; (u); u = u->next)
		
			if (u->node == n) {
				i++;
				sprintf(st + strlen(st), " %s%s%s", 
					(u->here) ? "" : "(",
					u->call,
					(u ->here) ? "" : ")");
				if (strlen(st) > 78 - 12) {
					csprintf(s, "%s\n", st);
					strcpy(st, "         ");
					i = 0;
				}
			}
			
		if (i > 0)
			csprintf(s, "%s\n", st);
	}
	
	return 0;
}

