
/*
 *	cmd_cluster.c
 *
 *	cluster user interface commands
 */
 
#include <string.h>

#include "csock.h"
#include "cmd_cluster.h"
#include "hmalloc.h"
#include "network.h"
#include "net_user.h"
#include "cstring.h"
#include "config.h"
#include "cfgfile.h"

int cmd_bye(struct csock_t *s, int argc, char **argv)
{
	csputs(s, "73!\n");
	csflush(s);
	sock_disconnect(s);
	
	return -2;
}

/*
 *	Talking
 */
 
int construct_talk(struct csock_t *s, char *to, int arg, int argc, char **argv)
{
	struct talk_t t;
	struct nuser_t *u;
	char *msg, *tonode = NULL;
	
	time(&t.time);
	hstrncpy(t.fromcall, s->lu->nu->call, sizeof(t.fromcall));
	strcpy(t.fromnodec, (char *)clucall);
	t.via = NULL;
	
	hstrupr(to);
	
	if ((tonode = strchr(to, '@'))) {
		/* User-supplied destination node */
		*tonode = '\0';
		tonode++;
		if (!(t.tonode = get_node((call_t *)tonode))) {
			csprintf(s, "Node %s is not known.\n");
			return 0;
		}
	} else {
		/* Verify that the user exists, get his node */
		if ((u = get_nuser((call_t *)to))) {
			/* To an user */
			t.tonode = u->node;
		} else {
			/* To a node */
			if (!(t.tonode = get_node((call_t *)to))) {
				csprintf(s, "%s is not a known user or node.\n", to);
				return 0;
			}
		}
	}
	
	if (valid_call((call_t *)to)) {
		csprintf(s, "%s is not a valid callsign.\n", to);
		return 0;
	}
	
	hstrncpy(t.tocall, to, sizeof(t.tocall));
	
	msg = argstr(arg, argc, argv);
	if (strlen(msg) + 1 > sizeof(t.message))
		csprintf(s, "Maximum length of a talk message is %d bytes. Your message was truncated.\n", sizeof(t.message)-1);
	hstrncpy(t.message, msg, sizeof(t.message));
	
	net_talk(&t);
	
	return 0;
}

int cmd_talk(struct csock_t *s, int argc, char **argv)
{
	if (argc <= 2) {
		csputs(s, "Usage: Talk <user[@node]> <message>\n");
		return 0;
	}
	
	return construct_talk(s, argv[1], 2, argc, argv);
}

int cmd_treply(struct csock_t *s, int argc, char **argv)
{
	if (argc <= 1) {
		csputs(s, "Usage: TReply <message>\n");
		return 0;
	}
	
	return construct_talk(s, s->lu->last_talk_from, 1, argc, argv);
}
