
/*
 *	cmd_net.c
 *
 *	cluster network related commands
 */
 
#include <stdio.h>
#include <string.h>

#include "csock.h"
#include "cmd_net.h"
#include "network.h"
#include "net_user.h"
#include "ctime.h"

/*
 *	Node listing, with fancy 2-column display
 */

char *nodestr(struct node_t *n)
{
	static char s[40];
	
	sprintf(s, "%-9.9s %-9.9s %c %-3d %-3d %-3.3s %-4d",
		n->call, (n->via) ? n->via->call : "",
		(n->here) ? 'H' : ' ', n->users,  n->hops, 
		(n->rtt_ok) ? secs2str_s(n->rtt) : (n->pinging) ? "?" : "-",
		n->version);
		
	return s;
}

int cmd_nodes(struct csock_t *s, int argc, char **argv)
{
	struct node_t *n1 = nodes, *n2 = nodes, *n2s;
	int i, l;
	
	/* dang. this part looks ugly. but works */
	/* bottle of beer for the one who cleans this up */
	l = node_count/2;
	if ((node_count % 2 != 0) && (node_count > 1))
		l++;
	if (node_count == 1)
		n2 = NULL;
	for (i = 1; (i <= l) && (n2); i++)
		n2 = n2->next; /* Halfway up the list */
	
	n2s = n2;
	
	csprintf(s, "Nodes: %d (max %d), %d of %d links\n",
		node_count, node_max, link_count, link_max);
	csputs(s,   "Node      Via       H Usr Hop Rtt Ver");
	if (node_count > 1)
	csputs(s, "  Node      Via       H Usr Hop Rtt Ver");
	csputs(s, "\n");
	while (n1 && n1 != n2s) {
		csputs(s, nodestr(n1));
		if (n2) {
			csputc(s, ' ');
			csputs(s, nodestr(n2));
			n2 = n2->next;
		}
		csputc(s, '\n');
		n1 = n1->next;
	}
	
	return 0;
}

/*
 *	Node route listing
 */
 
int cmd_nroutes(struct csock_t *s, int argc, char **argv)
{
	struct link_t *l;
	struct node_t *n;
	char st[80];
	int i;
	
	csprintf(s, "Node routes: %d nodes, %d of %d links up\n",
		node_count, link_count, link_max);
	for (l = links; (l); l = l->next) {
		sprintf(st, "%-9.9s (%d)", l->name, l->routes);
		i = 0;
		for (n = nodes; (n); n = n->next)
			if (n->via == l) {
				sprintf(st + strlen(st), " %s", n->call);
				i++;
				if (strlen(st) > 78 - 12) {
					csprintf(s, "%s\n", st);
					sprintf(st, "          ");
					i = 0;
				}
			}
		if (i)
			csprintf(s, "%s\n", st);
	}
	
	return 0;
}

/*
 *	Link listing
 */
 
char *lm_str(enum linkmode_t lm)
{
	static char s[7];
	
	switch (lm) {
	case lm_normal:
		sprintf(s, "Normal");
		break;
	case lm_incoming:
		sprintf(s, "In");
		break;
	case lm_listen:
		sprintf(s, "Listen");
		break;
	default:
		sprintf(s, "?!?");
		break;
	}
	
	return s;
}

char *ls_str(enum linkstate_t ls)
{
	static char s[7];
	
	switch (ls) {
	case ls_disc:
		sprintf(s, "Disc");
		break;
	case ls_init:
		sprintf(s, "Init");
		break;
	case ls_linked:
		sprintf(s, "Linked");
		break;
	case ls_backup:
		sprintf(s, "Backup");
		break;
	case ls_held:
		sprintf(s, "Held");
		break;
	default:
		sprintf(s, "?!?");
		break;
	}
	
	return s;
}

int cmd_links(struct csock_t *s, int argc, char **argv)
{
	struct link_t *l;
	
	csprintf(s, "Links: %d of %d up\n",
		link_count, link_max);
	csputs(s, "Link      Mode   State  Ver  fd\n");
	for (l = links; (l); l = l->next) {
		csprintf(s, "%-9.9s %-6.6s %-6.6s %-4d %d\n",
			l->name, lm_str(l->mode), ls_str(l->state), l->version,
			l->sock ? l->sock->fd : 0);
	}
	
	return 0;
}

/*
 *	User listing
 */

int show_user(struct csock_t *s, struct nuser_t *nu)
{
	return 0;
}

int cmd_users(struct csock_t *s, int argc, char **argv)
{
	struct node_t *n, *nonly = NULL;
	struct nuser_t *u;
	char st[80];
	int i;
	
	if (argc > 1) {
		strncpy(st, argv[1], sizeof(st));
		hstrupr(st);
		if ((u = guess_nuser((call_t *)st))) {
			/* show only this user */
			return show_user(s, u);
		} if ((nonly = guess_node((call_t *)st))) {
			/* show only users on this node */
		} else {
			/* check if in network / local user file */
		}
	}
	
	csprintf(s, "Users: %d (max %d) on %d nodes, %d links\n",
		nuser_count, nuser_max, node_count, link_count);
	csputs(s, "Node      Users\n");
	
	for (n = nodes; (n); n = n->next) {
		if ((nonly) && n != nonly)
			continue;
		sprintf(st, "%-9.9s", n->call);
		i = 0;
		
		for (u = nusers; (u); u = u->next)
		
			if (u->node == n) {
				i++;
				sprintf(st + strlen(st), " %s%s%s", 
					(u->here) ? "" : "(",
					u->call,
					(u ->here) ? "" : ")");
				if (strlen(st) > 78 - 12) {
					csprintf(s, "%s\n", st);
					strcpy(st, "         ");
					i = 0;
				}
			}
			
		if (i > 0)
			csprintf(s, "%s\n", st);
	}
	
	return 0;
}

