#ifndef _NQCONF_H
#define _NQCONF_H

#include <math.h>

#define WindowLen       64
#define WindowLenLog    6
#define SymbolLen       (WindowLen/2)			/* 32     */
#define AliasFilterLen  64
#define DecimateRatio   3
#define SampleFreq	9600
#define RxPipeLen	4

#define SymbolBits	2
#define PhaseLevels	(1<<SymbolBits)

#define DataCarriers    15
#define FirstDataCarr	12
#define DataCarrSepar	3

#define TuneCarriers    ((DataCarriers+1)/4)		/* 4      */
#define FirstTuneCarr	(FirstDataCarr+DataCarrSepar)	/* 15     */
#define TuneCarrSepar	(DataCarrSepar*4)		/* 12     */

#define RxTuneTimeout	56

#define RxAverFollow	4
#define RxMinTune	16
#define RxMinSync	16

#define RxUpdateHold	16
#define DCDTuneAverWeight	(1.0/16.0)
#define RxDataSyncFollow	5
#define DCDThreshold	(0.3*M_PI*M_PI)
#define DCDMaxDrop	12

#define	Hertz		(DecimateRatio*2.0*M_PI/SampleFreq)

#define TxMinIdle	50
#define TxTuneLen	32
#define TxSyncLen	32
#define TxPreData	2
#define TxPostData	1
#define TxJamLen	16

#define MaxInlv		16

#define	RxAvoidPTT	1

#endif
