/*****************************************************************************/

/*
 *      hdlc.h  --  HDLC encoder/decoder.
 *
 *      Copyright (C) 1996-1998  Thomas Sailer (sailer@ife.ee.ethz.ch)
 *        Swiss Federal Institute of Technology (ETH), Electronics Lab
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 *  Please note that the GPL allows you to use the driver, NOT the radio.
 *  In order to use the radio, you need a license from the communications
 *  authority of your country.
 *
 */

#ifndef _HDLC_H
#define _HDLC_H 1

/* --------------------------------------------------------------------- */

#include <sys/types.h>
#include <string.h>

/* --------------------------------------------------------------------- */

#define MAXFLEN           512
#define RXBUFFER_SIZE     ((MAXFLEN*6/5)+8)
#define TXBUFFER_SIZE     8192

/* --------------------------------------------------------------------- */

struct hdlc_receiver {
	unsigned int bitbuf, bitstream, numbits, state;
	unsigned char *bufptr;
	int bufcnt;
	unsigned char buf[RXBUFFER_SIZE];
};

struct hdlc_transmitter {
	unsigned rd, wr;
	u_int8_t buf[TXBUFFER_SIZE];
};

/* --------------------------------------------------------------------- */

extern int hdlc_enqueue(struct hdlc_transmitter *h, u_int8_t *pkt, int len);

extern inline u_int8_t hdlc_getbits(struct hdlc_transmitter *h)
{
	u_int8_t ret = h->buf[h->rd];
	if (h->rd != h->wr)
		h->rd = (h->rd + 1) % TXBUFFER_SIZE;
	return ret;
}

extern inline int hdlc_txempty(struct hdlc_transmitter *h)
{
	return (h->rd == h->wr);
}

extern inline void hdlc_inittx(struct hdlc_transmitter *h)
{
	h->rd = h->wr = 0;
}

/* --------------------------------------------------------------------- */

extern void sm_rxpacket(void **state, u_int8_t *pkt, unsigned len);

extern void hdlc_putbits(struct hdlc_receiver *h, u_int8_t bits, void **state);

extern inline void hdlc_initrx(struct hdlc_receiver *h)
{	
	memset(h, 0, sizeof(struct hdlc_receiver));
	h->bufptr = h->buf;
}

/* --------------------------------------------------------------------- */
#endif /* _HDLC_H */
