#ifndef _NEWQPSKRX_H
#define _NEWQPSKRX_H

/* --------------------------------------------------------------------- */

struct rxstate {
	struct hdlc_receiver hdlc;
	struct fecstate fec;
	unsigned bps, shreg;
	void (*rxroutine) (void **);
	float *rxwindowfunc;
	float rxbuf[1024];
	unsigned bufptr, skip, rxptr;
	complex rxpipe[RxPipeLen][DataCarriers];
	float carrierfreq, rxphase;
	complex rxwin[WindowLen];
	complex fftbuf[WindowLen];
	int rxphasecorr, acceptance, atsymbol, statecntr, updhold, bitbatches;

	/* tune mode power and correlations */
	float tunepower[TuneCarriers];
	float tunephase[TuneCarriers];
	complex tunecorr[TuneCarriers];

	/* sync mode at-symbol power and correlations */
	float power_at[TuneCarriers];
	complex corr1_at[TuneCarriers];
	complex corr2_at[TuneCarriers];

	/* sync mode inter-symbol power and correlations */
	float power_inter[TuneCarriers];
	complex corr1_inter[TuneCarriers];
	complex corr2_inter[TuneCarriers];

	float syncphase[TuneCarriers];
	float syncdelay[TuneCarriers];

	/* data mode */
	float pherr[DataCarriers];	/* Phase error                  */
	float pheavg[DataCarriers];	/* Phase error average          */
	float dcdavg[DataCarriers];	/* Phase error power average    */
	float power[DataCarriers];	/* Carrier power average        */
	float correl[DataCarriers];	/* Sync correlation average     */

	int fecerrors[DataCarriers];	/* FEC errors per carrier       */
};

/* --------------------------------------------------------------------- */

extern void init_newqpskrx(void **);
extern void newqpskrx(void **);

/* --------------------------------------------------------------------- */

#endif
