/*****************************************************************************/

/*
 *      soundmodem.h  --  User soundmodem driver header.
 *
 *      Copyright (C) 1996-1998  Thomas Sailer (sailer@ife.ee.ethz.ch)
 *        Swiss Federal Institute of Technology (ETH), Electronics Lab
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 *  Please note that the GPL allows you to use the driver, NOT the radio.
 *  In order to use the radio, you need a license from the communications
 *  authority of your country.
 *
 */

#ifndef _SOUNDMODEM_H
#define _SOUNDMODEM_H

/* --------------------------------------------------------------------- */

#include <sys/types.h>
#include <syslog.h>

/* --------------------------------------------------------------------- */

struct soundmodem_modulator {
	const char *modename;
	const char *copyright;

	void *(*init)(const char *config, unsigned *samplerate);
	int (*setup)(void **state, unsigned samplerate);
	int (*modulate)(void **state, int16_t *samples, int numsamp);
	int (*modulate_calib)(void **state, int16_t *samples, int numsamp);
	int (*enqueue)(void **state, u_int8_t *pkt, int pktlen);
	int (*can_send)(void **state);
};

struct soundmodem_demodulator {
	const char *modename;
	const char *copyright;

	void *(*init)(const char *config, unsigned *samplerate);
	int (*setup)(void **state, unsigned samplerate, unsigned *overlap);
	void (*demodulate)(void **state, int16_t *samples, int numsamp);
};

/* --------------------------------------------------------------------- */

#define SEV_FATAL    LOG_CRIT
#define SEV_ERROR    LOG_ERR
#define SEV_WARNING  LOG_WARNING
#define SEV_NOTICE   LOG_NOTICE
#define SEV_INFO     LOG_INFO
#define SEV_DEBUG    LOG_DEBUG

extern void errprintf(int severity, const char *fmt, ...);
extern void errstr(int severity, const char *st);

/* --------------------------------------------------------------------- */

extern void sm_rxpacket(void **state, u_int8_t *pkt, unsigned len);
extern void sm_diag(void **state, unsigned nr, unsigned mode, int sync, int16_t *samp, int numsamp);
extern void sm_rawbits(void **state, unsigned nr, u_int8_t *rawb, int numraw);
extern void sm_setdcd(void **state, int dcd);
extern int sm_getptt(void **state);

/* --------------------------------------------------------------------- */

extern int16_t sm_costab[512];

#define COS(x) sm_costab[((x)>>7)&0x1ff]
#define SIN(x) COS((x)+0xc000)

/* --------------------------------------------------------------------- */
#endif /* _SOUNDMODEM_H */
