/*************************************************************
 *  MBMAIL.C - 11/13/86
 *************************************************************
 * PRMBS - Packet Radio Mailbox System  Copyright 1987
 *   by  Brian B. Riley (ka2bqe)
 *       Dave Trulli    (nn2z)
 * This code was initially based on a pre-release of the CBBS
 * code by W0RLI and VE3GYQ. It has been re-worked to the point
 * that only some structural resemblance remains. It is for the
 * most part orginal work of the authors, where other code has 
 * been incorporated appropriate credit is given.
 *    This code is hereby freely placed into the public domain
 * for use by any and all with the stipulations that (1) credit
 * line must be retained, both ours and in the case of other
 * code the appropriate authors and (2) no fee may be charged
 * for this code beyond simple expenses in transfer of the code
 * to another person to include postage, phone charges, media 
 * costs, mailers, etc)
 *************************************************************/

#include "mb.h"

#define MAXMSG   0xffff	

#define UFWDM	32
#define BFWDM	32
#define SFWDM	128


#define	LISTL	0
#define READL	1
#define MAILL	2

char *msgtemp, *msgtmp2;
char *ufwd, *subj;
int ufwdn, subjn;

MAIL_HDR *mfhs;
MSG_HDR  *mmhs;

void mail_hdr();
int mfl;

	/* header info for message being created */


char mtitle[MHTITL+2];
char mtyp, mfprty;
char mto[CALLLEN+1], mfrom[CALLLEN+1], mbbs[MHTITL], msgID[17], msgID2[17];
char mnewsg[17];

char *add2date();

char handle[NAMELEN+1];	/* used for rcf822 header */
char tobuf[2*LINELEN];	/* use to build to user lists in rfc822 header    */

int forward;			/* message sweeper direction indicator			  */
unsigned int highread;	/* highest message sector read by user */
long int	 high_seq;	/* highest message read by user */
unsigned int new_highread;	/* highest message read by user this session*/
int islocal;			/* tells if message is local or coming from a bbs */		
unsigned int m_start, m_end; /* message sweeper internal pointers		  */
int x_to_from;			/* whether or not to copy numeric TO field to an
                           empty @ field								  */
char *mail_st;

extern char *EXstr;
extern char *EOMstr;
extern char *xltFIL;
extern char *zipFIL;

char *msgdir, *mbfile;
char *msgfname;
char *mail_user			= "BGKQRSUV? \r";
char *mail_user_str		= "b,g,k,q,r,s,u,v,?, [cr] : ";
char *mail_sysop		= "ABCDEFGHKNOQRSTVWXY? \r";
char *mail_sysop_str	= "a,b,c,d,e,f,g,h,k,n,o,q,r,s,t,v,w,x,y,?, [cr] : ";
extern char *mperm, *mkilld;


char *mfound = "$V found $S messages of $L\n";
char *chop_at();

/*
	message_stat() - message status report
*/
message_stat(nr,cp)
unsigned nr;
char *cp;
{
	
	tprintf("Msg #%u - %s\n",nr,cp);
}

aloc_mail()
{
		/*  Allocate space for the mail file records. */

	mfhs = (MAIL_HDR *) mballoc(MAIL_RECSIZE);
	mmhs = (MSG_HDR *) mballoc(MAIL_RECSIZE);

		/*  Allocate the "who has mail" list. */

	ufwd = mballoc ((unsigned)(CALLLEN+1) * UFWDM);

		/*  Allocate the "subject" list. */

	subj = mballoc ((unsigned)(CALLLEN+1) * SFWDM);


}


/*
	alter_rec() - sets up record locking for mail.dat record
			      alterations
*/
alter_rec()
{
	mwlock();
    resync(); /* get the current directory and file info */
    read_rec(mfl, mmhs->rn, (char *)mmhs);
}


/*************************************************************
 * disp_edit() - sweeps messages to user and edit format
 *************************************************************/
disp_edit(cp, newonly)
char *cp;
int newonly;
{
	
	char tcmd[LINELEN];

	strcpy(tcmd,cp);	/* synthesize a list mine	*/
	if (newonly)
		strcat(tcmd," -n");	
	tcmd[0] = 'L';
	if (parse_cmd(lstmsg,tcmd) == FALSE) {
							/* change to 'edit mine'	*/
			sendnl();
			tcmd[0] = 'E';
			parse_cmd(lstmsg,tcmd);
	}

}

disp_hdr(listlen,title)
int listlen, title;
{
	extern char *months[12];
	char static tline[CMDLEN];
	char *bbs_date();
	char tlin1[64];
	char tlin2[32];
	char *ttl, *p, tbbs[CALLLEN+1+MTOLEN+9];
		
	sprintf(tlin2,"%6ld %-9.9s %-4.4s",
		mmhs->size,bbs_date(mmhs->date),mmhs->time);

	sprintf(tlin1,"%5u %c%c%c%s",
			mmhs->rn,	mmhs->type,		mmhs->stat,
			mmhs->fprty,	tlin2);
			

	if (mmhs->bbs[0] != '\0')
		sprintf(tbbs,"%s@%s",mmhs->to,mmhs->bbs);
	else
		strcpy(tbbs,mmhs->to);
	
	switch(listlen) {
	case READL:
		ttl = "\n  Msg# TS   Size  Date/Time      Arrived #Rd  Seq #      Msg ID      Route\n";
		sprintf(tline,"\n %sz %-6.6s  %3u (%06ld - %-12s) [%s]\n  %-6s ==>  %s\n  \"%s\"\n", 
			tlin1, 			bbs_date(mmhs->arrived), 	mmhs->read,	
			mmhs->number,	mmhs->msgID,				mmhs->route,
			mmhs->from, 	tbbs, 						mmhs->title);

		break;

	case LISTL:
		ttl = "\n Msg# TS   Size  Date/Time     From   To            Title\n";

		p = chop_at(tbbs,'.');
	
    	sprintf(tline,"%s %-6s %-13s %.27s\n", 
    		tlin1,	mmhs->from,	tbbs,	mmhs->title);
		break;

	case MAILL:
		ttl = "\n Msg#    Size  Date/Time     From   Title\n";
		sprintf(tline, "%5u%c %s %-6s %.44s\n",
    		mmhs->rn,	mmhs->stat == 'N' ? '*' : ' ',
      		tlin2, mmhs->from,	mmhs->title);
		break;
	}

	if (title)
		outstr(ttl);
	outstr(tline);
		
}



/***************************************************************
 * disp_msg() - displays message already found by findmsg()
 * checks for message window size
 ***************************************************************/
disp_msg(show_hdr)
short show_hdr;
{
    if (port->dl_size && chktime(port->dl_time)) {
      if (mmhs->size > port->dl_size) {
		prtx_err(MMSGWND);
        return;
      }
    }
    

   	disp_hdr(READL,TRUE); 

	sendnl();
       
	read_fil(msgname(mmhs->number),show_hdr);
	
					/* update highest message read */
	if ( mmhs->rn > new_highread) {
		new_highread	= mmhs->rn;
		high_seq		= mmhs->number;
	}
	
		/* this boost read count only for your own mail */

	if ((port->mode & REMOTE) || is_to_me()) {
		alter_rec();	/****** lock mail file ******/
		mmhs->read++;
		if (is_to_me() && mmhs->stat == 'N') {
			mmhs->stat = 'Y';
		}
		wrt_altered();	/****** write and unlock mail file ******/
	}
}

/*************************************************************
 * edmsg() - message sweeper actions
 *************************************************************/
edmsg(listf)
int listf;
{


	char	c, *fname, *cp, *p, *msgname();
	static  char tline[80];
	char 	tline2[16];
	char	tcmd[LINELEN];
	char	*fmt_token();
	extern int edit();
	unsigned int x;
	int svc_msg = FALSE;
	int	c1;
			
	while (TRUE) {
		if (disk_check(disk_full))
			prtx_err(MDFULL);
		disp_hdr(listf,FALSE);

		c = '\r';
		if (!get_byte(port->mode != REMOTE ? 
				mail_sysop_str : mail_user_str,&c))
					return (ERROR);
		if (strchr(port->mode != REMOTE ? mail_sysop : mail_user,c) == NULL) {
			prtx("\7\n");
			continue;
		}
		
		switch(c) {
		case 'B':
			port->mode = DISCON
			;
		case 'Q':
			return(ERROR);

		case 'C':
			forward 	= !forward;
			x 			= m_start;
			m_start		= m_end;
			m_end		= x;					

		case '\r':		/* skip this one */
			return(FALSE);

		case 'E':
			edit_msg();
			continue;
			
		case 'X':
			re_trans();
			continue;

		case 'D':
			if (!getedit("Flood to route: "))
				return (ERROR);
			flood_msg(fld[0]);
			continue;

		case 'A':
		case 'F':
			if (msgfname != NULL) 
				(void) tprintf("File is %s, <cr> to append or : ",msgfname);
			else
				(void) tprintf("Enter filename: ");

			if (!getcmd()) 
				return(ERROR);
					
			if (flds) {
				strcpy(tline,fld[0]);
				msgfname = tline;
				remnl(msgfname);
			}
			if (msgfname == NULL            ||
				*msgfname == '/'			||
			    msg2fil(msgfname,EXstr) == FALSE  ||
			    c == 'F'  ) 
				continue;

				/* fall thru and kill it too, if (a)rchive specified */

		case 'K':			
			if (permit('K')) {
				kill_msg(FALSE /* no query*/);					
			} else {
				prtx_err(MPERM);
			}
			return(FALSE);

		case 'S':
			if (parse_cmd(sndmsg,"sp #") == ERROR)
				return (ERROR);
			continue;

		case 'R':
			disp_msg(FALSE);
		case ' ':
			continue;
				
		case 'U':
			c = 'N';
		case 'H':
		case 'N':
		case 'O':
		case 'W':
		case 'Y':
			if (permit('K'))
				set_msgstat(c);
			else
				prtx_err(MPERM);
			continue;

		case 'V':
			disp_msg(TRUE);
			continue;

		case 'T':
			if ( port == cport ) {
				edit(msgname(mmhs->number));

				alter_rec();	/*** lock mail file ***/
				mmhs->size = fil_xst(msgname(mmhs->number));
				wrt_altered();	/*** unlock mail file ***/

				continue;
			}

			
		case '?':
			prtx_err(port->mode == REMOTE ? MEDUMNU : MEDSMNU);
			continue;
			
		case 'G':
			if (!getedit("Goto msg#: "))
				return(ERROR);
			if (x = atou(eat_white(fld[0]))) {
				getprev(x+1);
				continue;
			}
		}
	}


}


#define PARSE	TRUE
#define	NOPARSE	FALSE

/****************************************************************
 * edit_msg() actual message edit routine
 ****************************************************************/
edit_msg()
{
	char tline[32];
	char c, *msgIDstr();
			
	alter_rec();		/****** lock mail file ******/
	
	if (getfield("Edit: To :",mmhs->to,CALLLEN,PARSE)) {
		if (getfield("      At :",mmhs->bbs,MTOLEN,PARSE)) {
			if (getfield(" MID/BID :",mmhs->msgID,IDLEN,PARSE)) {
				if (getfield("   Route :",mmhs->route,CALLLEN,PARSE)) {

					if (getfield("    From :",mmhs->from,CALLLEN,PARSE)) {

						if (getfield(" Subject :",mmhs->title,MHTITL,NOPARSE)) {

							if (get_byte("    Type :",&mmhs->type)) {

								if (get_byte("  Status :",&mmhs->stat)) {
									write_rec(mfl, mmhs->rn, (char *)mmhs);
								}
							}
						}
					}
				}
			}
		}
	}
	resync();
	mulock();	
}
/*
	is_mine() - returns true if message is to you or from you
*/
is_mine()
{
	return(is_to_me() || (strcmp(port->user->call, mmhs->from) == 0));
}


/*
	is_to_me() function returns TRUE if message TO field is the current
			  logged user or if message is to SYSOP and a current caller
			  is the sysop
*/
is_to_me()
{
	return ( strcmp(port->user->call, mmhs->to) == 0	||
			 ( strcmp(port->user->call,ocall) == 0		&& 
			   strl2cmp(mmhs->to, "SYSOP") == 0			&&
			   strl2cmp(ocall,edit_route(mmhs->bbs,rt_edit)) == 0 ));
}

/*******************************************************************
 * lstmsg() - pre-process list command - list messages
 *******************************************************************/
lstmsg(argc,argv)
int argc;
char **argv;
{
	int found;
	char *ntos(), *cmnd;
		
	cmnd = argv[0];

	switch (found = lstmsg2(argc,argv)) {
	
	case 0:
		outstr(mnfind);
		return (TRUE);

	case ERROR:
		return (ERROR);

	default:
		if (found > 1 || *cmnd == 'C') {
			token_lin = ntos(found);
			prtx(mfound);
		}
		return(0);
	}
}

/*******************************************************************
 * lstmsg2() - list messages
 *******************************************************************/
lstmsg2(argc,argv)
int argc;
char **argv;
{
	char *scall =  NULL;
	char comnd, opt_2, *p, cc;
	register int ok;


#define	FLOODOP	TRUE
#define FILEOP	FALSE
	int curhdr;
	int	arrived		= FALSE;
	int onlybull	= FALSE;
	int onlytraf	= FALSE;
	int done 		= FALSE;
	int	floodop		= FALSE;
	int	flood_ptrs	= FALSE;
	int	found		= 0;
	int j;
	int just_one	= FALSE;
	int query 		= TRUE;
	int last_rel	= FALSE;
	int listlen		= LISTL;
	int mine;
	int	onlypriv	= FALSE;
	int rel_dat		= 0;
	int read_cnt	= 0;
	int showall		= FALSE;	
	int special		= FALSE;
	int lines;
	char specstat	= 'K';

	char *ntos();
	char *stat_str;
	char *range 	= NULL;
	char *search_str= NULL;
	char *BID_str	= NULL;
	char *exp_file	= "PRMBS.EXP";

	p = argv[0];
	comnd = *p++;
	opt_2 = *p;

	lines = port->user->lines;

	if (comnd == 'F') {
		if (opt_2 == 'L')
			floodop++;
		opt_2 = '\0';
	}
    if (comnd == 'A' && opt_2 == 'R')
    	opt_2 = '\0';

    if (comnd == 'C' && opt_2 == 'O')
    	opt_2 = '\0';

    if (comnd == 'T' && opt_2 == 'R') {
    	listlen = READL;
    	opt_2 = '\0';
	}
	
	if (opt_2 && strchr("R@<>",opt_2)) {
		if (argc > 1)  {
			if (*argv[1] != '-') {
				scall = argv[1];
				argv++;
				argc--;
			}
		}  else {
			prtx_err(MLIST);
			return(ERROR);
		}
	}
	
	while( --argc > 0 && (*++argv)[0] == '-') {
		for ( p = argv[0]+1; *p != '\0'; p++) {
			switch(*p) {

				/* these selectors modify list behaviour	*/
			case 'J':
				just_one++;	 /* by implication just_one sets no_query */
			case 'Z':
				query	= FALSE;
				break;

				/* these select expiration age by creation or arrival dates */
			case 'X':
				if (*(p+1) == 'A') {
					p++;
					arrived++;
				}
				rel_dat = atoi(argv[1]);
				argc--;
				argv++;
				break;

			case 'R':
				read_cnt = atoi(argv[1]);
				argc--;
				argv++;
				break;
				
				/* these selectors are for type	*/

			case 'B':
				onlybull++;
				break;
			case 'T':
				onlytraf++;
				break;
			case 'P':
				onlypriv++;
				break;

			case '$':
				flood_ptrs++;
				break;

			case 'S':
				search_str = argv[1];
				argc--;
				argv++;
				break;

			case 'F':
				exp_file = argv[1];
				argc--;
				argv++;
				break;

				/* these selectors of message status */
			case 'D':
			case 'H':
			case 'K':
			case 'N':
			case 'O':
			case 'W':
			case 'Y':
			case '?':
				special++;
				specstat = *p;
				break;
				
				/*  searches against BID IDs - falls through and defaults to
					LONG list length, unless over-ridden
				*/
			case 'I':
				BID_str = argv[1];
				argc--;
				argv++;

				/* these selectors of list display */
				
			case 'L':
				listlen = READL;
				break;
			case 'M':
				listlen = MAILL;
				break;
				
			case '*':
				showall++;
				break;
			}
		}
	}

			
	
	/* set the default search information for 'new' messages */

	m_end	= mfhs->last;	
	m_start	= highread;
	
	switch(opt_2) {
	case 'L':
		m_start = mfhs->last;
		m_end   = 1;
		last_rel++;
		if (argc)
			m_end = atoi(argv[0]);
		break;

	case 'T':
	case 'M':
		m_start	= 1;
	default: 
		if (argc)
			range = argv[0];
		break;
	}
		
	if (range) 
		if (set_range(&m_start,&m_end,range) == ERROR)
			return (ERROR);

	forward = m_start < m_end;

	msgfname = NULL;

	curhdr = getprev(m_start+1);

	while (curhdr) {

		if (last_rel) {
			done = (found == m_end);
		} else {
			 if (forward)
				done = (mmhs->rn > m_end);
			 else
				done = (mmhs->rn < m_end);
		}
		if (!done) { 
			switch(opt_2) {
			case 'L':
				ok = TRUE;
				break;
			case 'R':
				ok = wildmatch(scall, mmhs->route);
				break;
			case '@':
				ok = wildmatch(scall, mmhs->bbs);
				break;
			case '<':
				ok = wildmatch(scall, mmhs->from);
				break;
			case '>':
				ok = wildmatch(scall, mmhs->to);
				break;
			case 'M':
				ok = is_to_me() &&  ((comnd != 'K') || (mmhs->stat == 'Y'));
				break;
			default:
				ok = (opt_2 == '\0') || (mmhs->type == opt_2);
				break;
			}	
			
			if (ok && onlybull)	
				ok = (mmhs->type == 'B');

			if (ok && onlytraf)
				ok = (mmhs->type == 'T');

			if (ok && onlypriv)
				ok  = (mmhs->type == 'P');			

			if (ok && flood_ptrs)
				ok  = (mmhs->fprty == '$');			

			if (ok && BID_str)	/* covers 'BID search string' '-$ xxxxx'	*/
				ok = (strstr(mmhs->msgID,BID_str) != NULL);	
							
			if (ok && search_str)	/* covers 'search string' '-s xxxxx'	*/
				ok = (strstr(uc(mmhs->title),uc(search_str)) != NULL);	

			if (ok && rel_dat)
				ok = (strcmp(add2date(
				(arrived) ? mmhs->arrived : mmhs->date,rel_dat),l_date) <= 0);

			if (ok && read_cnt)
				ok = (mmhs->read < read_cnt);

			if (port->mode == REMOTE)	
				if (ok && !is_mine())
					ok = (mmhs->fprty != '$');
					
					
				/* checks for permission, if yes checks '-h' and '-k' */
					
			if (ok && (ok = permit(comnd))) { 
				if (!showall) {
					if (special)
						ok = (mmhs->stat == specstat);
					else 
						ok = (strchr("DHKO",mmhs->stat) == NULL);
				}
			} else {
				if (just_one) 
					message_stat(mmhs->rn,mperm);
			}

			if (ok) {		/* execute the actual command */
				switch (comnd) {
				case 'A':
				case 'F':
					if (floodop) 
						flood_msg(mmhs->bbs);
					else
						msg2fil(exp_file,EXstr);

					if (comnd == 'F')
						break;

				case 'K':
				
						/*  this is cheating a bit - if 'special' then '-' 
							option must be have been selected if mmhs->stat 
							is 'DHKO' to have gotten 'ok' to this point, then
							will it let you kill Held, visible Held (W), Dupe,
							Old, or already Killed messages 
							
							if 'showall' then killed, held, 'W'ed, whatever, 
							SAYONARA! they get 'K'ed
						*/
						
					if (showall || (strchr("DHKOW",mmhs->stat) == NULL) || special)
						done = kill_msg(query);
					break;
						
				case 'T':
					re_trans();
				case 'L':
					disp_hdr(listlen,!found);
					done = paging(&lines, found, (smart_sys == ERROR));
						
				case 'C':
					break;
					
				case 'E':
					done = edmsg(listlen);
					curhdr = mmhs->rn;
					break;
					
				case 'R':
				case 'V':
					disp_msg(comnd == 'V');
					if (!just_one && lines > 0 &&  
					    get_yes_no("Continue Read ? (Y,n) ") == FALSE)
					    done = TRUE;
					    
					break;
				}
				found++;
			}
		} 

		if (abort_dl() || done || just_one)
			break;

		if (forward) {
			curhdr = getnext(curhdr);
		} else {
			curhdr = getprev(curhdr);
		}
	}
	return(found);
}


/*
	kill_msg() - actual traffic killer with check for query
*/

kill_msg(query)
int query;
{
	char tline[LINELEN];
	int	disp;
		
	if (query) {
		disp_hdr(LISTL,FALSE);
		if ((disp = get_yes_no("Kill msg? (y,N,q) ")) != TRUE)
			return (disp == ERROR);
	}
	message_stat(mmhs->rn,mkilld);
	(void) sprintf(tline,"%ld %u",mmhs->number,mmhs->read);
	log('M', 'K', mmhs->type , tline);	

	set_msgstat('K');
	return (FALSE);
}

readnews(argc,argv)
int argc;
char **argv;
{
	register int i=0;
	char tcmd[LINELEN];
	char c, options[LINELEN];
	char *jopt, *p;
	char *comnd_end;
	extern	char *subj;
	extern	int	subjn;

	char *startn = "1";
	char startnumb[8];
	
	strcpy(options,"-m");

	sprintf(startnumb,"%u", highread);
	
	while( --argc > 0 && (*++argv)[0] == '-') {
		switch(argv[0][1]) {
		case '#':
			strcpy (startnumb,argv[0]+2);
		case 'N':
			startn = startnumb;
			break;
		case 'R':
		case 'S':
		case 'X':
			sprintf(options,"%s %s ",options,argv[0]);
			strcat(options, argv[1]);
			strcat(options, " ");
			argc--;
			argv++;
			break;
		default:
			sprintf(options,"%s %s ",options,argv[0]);
		}
	}
	if (argc) {
		for (i=0 ; i < argc ; i++) {
			if (abort_dl())	
				break;
			sprintf(tcmd,"L> %s %s %s",argv[i],options,startn);
			tprintf("  Subject search: %s\n",argv[i]);
			disp_edit(tcmd,FALSE);
		}
	} else {
		prtx_err(MSUBJ);
		for (i=0, p = subj ; i < subjn ; i++, p += CALLLEN+1) {
			tprintf(" %-8.8s",p);
			if ((i % 8) == 7) {
				sendnl();
			} 
		}
	}

	sendnl();
	return(0);
}




/*
	multi_msg() - upper level multiple read or kill message - 
				  does specific message numbers/ranges. checks 
				  existance and permissions
*/
multi_msg(argc,argv)
int argc;
char **argv;
{
	register int i=0;

	char tline[LINELEN];
	char *jopt, *p;
	char comnd[LINELEN];
	char *comnd_end;
	
	sprintf(comnd,"%s ",argv[0]);
	
	while( --argc > 0 && (*++argv)[0] == '-') {
		sprintf(comnd,"%s %s ",comnd,argv[0]);
		for (i=1,p = argv[0]+1; *p; p++) {
			if (strchr("SXFR$",*p)) {					
				sprintf(comnd,"%s%s ",comnd,argv[i++]);
				argc--;
				argv++;
			}
		}
	}

	for (i = 0 ; i < argc ; i++) {
		
		if (abort_dl())	
			break;
		strcpy(tline, comnd);
		
		if (!not_num(argv[i]))
			strcat(tline, " -j");

		sprintf(tline,"%s %s",tline,argv[i]);
		parse_cmd(lstmsg,tline);
	}
	
	return(0);


}

/**********************************************************************
 * newmsg() - tells user he has new messages
 **********************************************************************/
newmsg()
{
	register int i;
	char *p;
	char *caller;
	
	caller = port->user->call;
	
	if ((*mail_st == 'M' && stricmp(caller,ocall) == 0) || 
		findfwd(caller,ufwd,ufwdn))

		prtx_err(MNEWML);
}


/*************************************************************
 * permit() - is it permitted for this user to operate on
 *		this message  			|br| 12/1/86
 *************************************************************/
permit(cmnd)
char cmnd;
{
	if ((mmhs->type == 'T') || 
		is_mine()			||
		issysop()			)	/* Traffic , mine, or remote sysop*/
		return (TRUE);

							/* if it isn't Kill and not private */
	if ((cmnd != 'K') && (mmhs->type != 'P'))
		return (TRUE);

	return(FALSE);
}

/*
	re_trans() - will re-translate any address in a mail.dat header
*/
re_trans()
{
	extern char *xlat_fil;
	int xlatd=0;

	alter_rec();

	xlatd  =	xlat_addr(mmhs->to,mmhs->bbs,NULL,' ',
					usr_name(port->user->call,"XLT"));
	xlatd |=	xlat_addr(mmhs->to,mmhs->bbs,mmhs->title,mmhs->type,
					sys_name(xltFIL,""));

	xlat_addr(mmhs->to,mmhs->bbs,NULL,' ',sys_name(zipFIL,""));

	strnxcat(mmhs->route,set_route(mmhs->bbs,rt_edit),CALLLEN);
	
	wrt_altered();
}

#ifndef NEEDSPACE	
translat(tto,tbbs,tfrom,ttlstr)
char *tto,*tbbs,*tfrom,*ttlstr;
{
	int xlatd;
	xlatd =		xlat_addr(tto,tbbs,NULL,usr_name(tfrom,"XLT"));
	xlatd |=	xlat_addr(tto,tbbs,ttlstr,sys_name(xltFIL,""));

	return(xlatd);
}
#endif

/*********************************************************************
 * set_range() - take the numbers and parses out ranges , sets
 *		start, and end etc!!
 *********************************************************************/
set_range(start,end,cp)
unsigned int *start, *end;
char *cp;
{
    char  *p = NULL;
	char *t1str;
	char *t2str = NULL;
    unsigned t1;
    unsigned t2;

	t1 = mfhs->last;
	t2 = t1;

	t1str = cp;
	if (strnicmp(t1str,"ALL",2) ==  0) {
		t1 = 1;
	} else {
		if (strnicmp(t1str,"BACK",2) ==  0) {
			t2 = 1;
		} else {
			if (p = chop_at(cp,'-'))
				t2str = p;
			
			if (*t1str != '$')
				t1 = atou(t1str);
	

			if (t2str) {
				if (*t2str && *t2str != '$')
					t2 = atou(t2str);
			}
			if ((t1 == 0) && (t2 == 0)) {
				prtx_err(MMSGNUM);
				return (ERROR);
			}
		}
	}
    *start	= t1;
	*end	= t2;
	return(FALSE);

}

/***************************************************************
 * bldfwd() - build "Mail for:" list
 ***************************************************************/
bldfwd(buf)
char *buf;
{
	extern char *sysop;

	int	i, last_num;
	int	curhdr;

	char *cp;

	*ufwd = '\0';
	mail_st = "NONE";
	ufwdn 	= 0;
	subjn	= 0;

	rlock();		/* lock the mail file */

	curhdr = setlast();
	while ((curhdr = getprev(curhdr)) && !kb_abort()) {
	
		cp = mmhs->to;
		if ((stricmp(cp,ocall) == 0) ||
			(stricmp(cp,sysop) == 0)) {
			if (mmhs->stat == 'N') 
				mail_st = "MAIL";
		} else {	
			if (mmhs->type == 'T'								||
			 	(mmhs->bbs[0] == '\0' && val_call(cp))	){
				if (mmhs->stat == 'N') 
				 	ufwdn = addfwd(cp, ufwd, ufwdn, UFWDM);
			}  
			if (!val_call(cp)					&& 
				mmhs->fprty != '$'				&&
				strchr("HK?D",mmhs->stat) == NULL	)
				subjn = addfwd(cp, subj, subjn, SFWDM);
		}

	}
	rulock();		/* unlock the mail file */

		/* sort subjects array - this adds about 380 bytes to OBJ - arrrgghh*/

	qsort(subj, subjn, CALLLEN+1,stricmp);


	strcpy(buf,err_string(MMAILFOR));
	remnl(buf);
	
	if (*ufwd == '\0')
		strcpy(buf,err_string(MNOMAIL));
	else {
		for (i=0, cp = ufwd ; i < ufwdn ; i++, cp += CALLLEN+1) {
			strcat(buf," ");
			strcat(buf,cp);
		}
		strcat(buf,"\n");
	}
	
}




/*********************************************************************
 * setfwd() - set up forwarding beacon line
 *********************************************************************/
setfwd(pp,buf)
char *buf;
PORTS *pp;
{
	if (pp->beacon) {
		ioport(pp);

		if (strnicmp(buf,"BT",2) == 0) {
			strcpy(buf+118,"\n");
			device_cmds(pp,buf);
		} else {
			convtnc(2);
			outstr(buf);
			cmdtnc();
		}
	}
}


/*
	wrt_altered() - set the altered record, resync header, and unlock
*/
wrt_altered()
{
	write_rec(mfl, mmhs->rn, (char *)mmhs);
	resync();
	mulock();
}
