
/*****************************************************************
 *  MBMAIL.H - 11/8/86
 *****************************************************************
 *   RATS - The Radio Amateurs Telecommunications Society
 *			presents
 *        [PRMBS] - Packet Radio MailBox System
 *        created and written by Brian B. Riley, KA2BQE
 *        with Dave Trulli, NN2Z
 *  
 *  All code contained herein is copyrighted by Brian B. Riley, 
 *  STORMYLEA Ltd.,  Jan 1987, except where specific credit is
 *  given in the procedure and or module headers for materials 
 *  gained from other sources
 *
 *  This code in generic IBMPC form for external TNCs attached to
 *  COM ports is freely given into the public domain for non-commer-
 *  cial use.
 *****************************************************************/


#define MFL_VERSN		5
#define FIRST_MSG		1
#define MAIL_RECSIZE	256

extern char *mbfile;
extern int mfl;


extern int mfl;
extern char mtitle[MHTITL+2];
extern char mnewsg[17];
extern char mtyp, mfprty;
extern char handle[21];
extern char mto[CALLLEN+1], mfrom[CALLLEN+1], mbbs[MHTITL], msgID[17];
extern char tobuf[2*LINELEN];
extern char *thisHost;
extern char *replyHost;
extern char *reply_to;
extern char mexpire[7];
extern int priv_expir, othr_expir;

extern char *ufwd, *bfwd, *subj;
extern int ufwdm, ufwdn, bfwdm, bfwdn, subjn;

extern int setfirst(), setlast(), getnext(), getprec();
extern int islocal;
extern unsigned int highread;	/* high message read during this session */

/* status for mail record */
#define FREE_REC	-1
#define KILLED	1
#define INUSE	0

#define FWD_KILL	1
#define FWD_FSTAY	2

/* Message Flag bit */
#define HASHEADER	1		/* has internal header */
#define ISMASTER	2		/* is a master message to other slave headers */
#define ISSLAVE		4		/* is slaved to another message, not text of it*/

extern short fwdopt;

/* Message hdr sector. */

typedef struct
{
  unsigned int	rn;			/* this record number */
  char			type;
  char			stat;
#ifdef UNSGN
  unsigned int	number;		/* Message number */
  unsigned int	numb2;		/* when we go to long int */
#endif
  long int		number;
  long int 		size;		/* Message file size */
  unsigned int  read;
  short		flags;
  char		fprty;	  		/* forwarding priority and type	*/
  char		msgID[IDLEN+1];
  char 		from[CALLLEN+2+1];
  char		to[CALLLEN+2+1];
  char		bbs[MTOLEN+1];
  char 		arrived[6+1];
  char 		date[6+1];
  char 		time[4+1];
  char 		title[MHTITL+1];
  char 		route[9];
  char 		keywords[KEYLEN+1];
} MSG_HDR;

/* Mail file hdr sector. */

typedef struct
{
  char version;
  char date[6+1];
  char time[4+1];
  char unused1[3];			/* pads out to 16 bytes for DEBUG VIEWing */
  char lock[MAXPROCS];		/* locking for multi-user */
  char unused2[8];			/* pads out to 16 bytes for DEBUG VIEWing */
  unsigned int	first; 		/* First message header record */
  unsigned int	last;  		/* Last message header record */
  unsigned int  fmsgno;		/* lowest sequence number in file */
  unsigned int  next_msgo;	/* Next message number */
  char cr_date[6+1+1];		/* creation date		*/
  char up_date[6+1+1];		/* up-date notification date	*/
  long int		next_msg;	/* next message number, old thingie */
  
} MAIL_HDR;


extern MAIL_HDR *mfhs;
extern MSG_HDR  *mmhs;

/*****************************************************************
 * numbers of relative messages for mail prompts in config file
 *****************************************************************/

#define MSG_TITL	0
#define MSG_TXT		1
#define MSG_UNRD	2

extern  int cremsg();
extern  int dist_lst();
extern  int dump_msg();
extern  void fil_req();
extern  int getrec();
extern  int kmsg();
extern  int msg2fil();
extern  int prtmsg();
extern  int parse_hdr();
extern  int untmsg();
extern  void write_hdr();
extern  void muinit();
extern  void mwlock();
extern  void mulock();
extern  void rlock();
extern  void rulock();
extern  void resync();
extern  char *arpadate();
extern  void preamble();
extern  char *ftos();
extern  void list_hdr();
extern  void read_hdr();
