/* some multi user stuff */
	
/*
** check which multitasker is running. return appropriate values
*/
int
ismultitask()
{
	union REGS regs;
	
		/* check for doubledos */
	regs.h.ah = 0xe4;
	int86(0x21,&regs,&regs);
	if ( regs.h.al == 1 || regs.h.al == 2 ) 
		return (DOUBLEDOS);

		/* check for desqview */
	regs.x.ax = 0x2b01;
	regs.x.cx = 0x4445;
	regs.x.dx = 0x5351;
	int86(0x21,&regs,&regs);
	if ( regs.h.al != 0xff )
		return (DESQVIEW);
		
		/* failed all above .. no multitasker */
	return (NONE);
}
/* turn timesharing off */
void
tsoff()
{
	union REGS regs;

	switch(MultiTasker) {
	case	DOUBLEDOS:
		int86(0xfa,&regs,&regs);
		break;

	case	DESQVIEW:
		regs.x.ax = 0x101b;
		int86(0x15,&regs,&regs);
		break;
	}
}

/* turn timesharing on */
void
tson()
{
	union REGS regs;

	switch(MultiTasker) {
	case	DOUBLEDOS:
		int86(0xfb,&regs,&regs);
		break;

	case	DESQVIEW:
		regs.x.ax = 0x101c;
		int86(0x15,&regs,&regs);
		break;
	}
}

/* give up cpu for a while 
 * each unit is a 55ms interval for doubledos or
 * the whole slice for the DESQVIEW
*/
void
giveaway(x)
int x;
{
	union REGS regs;

	switch(MultiTasker) {
	case DOUBLEDOS:
		regs.h.al = x;
		int86(0xfe,&regs,&regs);
		break;

	case DESQVIEW:
		regs.x.ax = 0x1000;
		int86(0x15,&regs,&regs);
		break;
	}
}
