INCLUDE= mb.h mbuser.h mbmail.h

OBJ1= mb.obj mbcmd.obj mbfile.obj mbfwd.obj mbinit.obj rslog.obj
OBJ2= mbterm.obj mbtnc.obj mbuser.obj mbutil.obj mbibm.obj mbio.obj

SUPOBJ1= mbcmd mbfile mbfwd mbinit rslog mbterm mbtnc
SUPOBJ2= mbuser mbutil mbibm mbio

BOOTOBJS= rswindow msklibs rosesubs
XBOOTOBJS= rswindow mbio msklibs rosesubs

BOBJ1= roseboot.obj rosesubs.obj rose_ver.c msklibs.obj
BOBJ2= rswindows.obj

XBOBJ1= roseboot.obj rosesubs.obj rose_ver.c mbio.obj msklibs.obj
XBOBJ2= rswindows.obj

LIBLIST= mb.lib mbmailer.lib

LIBOBJ= rosesubs.obj msklibs.obj

MAILOBJ= header.obj mbmail.obj mbmail1.obj mbmail2.obj 

CFLAGS= -Zp -W 1 -DNEEDSPACE

WCFLAGS= /AS /DMSCV4=1

HCFLAGS= -AH -Zp -W 1 


mb.obj:		mb.c rose_ver.c $(INCLUDE)
	cl -c $(CFLAGS)  mb.c

mbcmd.obj:	mbcmd.c cmdparse.c cmdparse.h $(INCLUDE) 
	cl -c $(CFLAGS) mbcmd.c

mbmail1.obj:	mbmail1.c $(INCLUDE)
	cl -c $(CFLAGS)  mbmail1.c

mbmail2.obj:	mbmail2.c mbmultim.c $(INCLUDE)
	cl -c $(CFLAGS)  mbmail2.c

mbfile.obj:	mbfile.c $(INCLUDE)
	cl -c $(CFLAGS)  mbfile.c

mbfwd.obj:	mbfwd.c $(INCLUDE)
	cl -c $(CFLAGS)  mbfwd.c

mbibm.obj:	mbibm.c mbmltibm.c $(INCLUDE)
	cl -c $(CFLAGS) mbibm.c

mbio.obj:	mbio.c $(INCLUDE)
	cl -c $(CFLAGS) mbio.c

mbinit.obj:	mbinit.c $(INCLUDE)
	cl -c $(CFLAGS) mbinit.c

mbmail.obj:	mbmail.c $(INCLUDE)
	cl -c $(CFLAGS) mbmail.c

mbterm.obj:	mbterm.c $(INCLUDE)
	cl -c $(CFLAGS) mbterm.c

mbtnc.obj:	mbtnc.c rosecall.c $(INCLUDE)
	cl -c $(CFLAGS) mbtnc.c

mbuser.obj:	mbuser.c mbmultiu.c $(INCLUDE)
	cl -c $(CFLAGS)  mbuser.c

mbutil.obj:	mbutil.c $(INCLUDE)
	cl -c $(CFLAGS)  mbutil.c

mbutil2.obj:	mbutil2.c
	cl -c $(CFLAGS)  mbutil2.c

msklibs.obj:	msklibs.c 
	cl -c $(CFLAGS)  msklibs.c

header.obj:	header.c $(INCLUDE)
	cl -c $(CFLAGS) header.c

rslog.obj:	rslog.c $(INCLUDE)
	cl -c $(CFLAGS) rslog.c

rswindow.obj:	rswindow.c $(INCLUDE) rosewind.h
	cl -c $(WCFLAGS)  rswindow.c

roseboot.obj:	roseboot.c rose_ver.c rosewind.h $(INCLUDE) 
	cl -c $(CFLAGS)  roseboot.c

rosesubs.obj: rosesubs.asm
	masm rosesubs,rosesubs,nul,nul /mx

breakoff.obj: breakoff.asm
	masm breakoff,breakoff,nul,nul /mx

mb.lib: $(LIBOBJ)
	erase mb.lib
	lib mb+rosesubs+msklibs;

mbmailer.lib: $(MAILOBJ)
	erase mbmailer.lib
	lib mbmailer+header+mbmail+mbmail1+mbmail2;

roserver.pgm: $(OBJ1) $(OBJ2) $(LIBLIST)
	cl /Fm mb $(SUPOBJ1) $(SUPOBJ2) -link $(LIBLIST)
	exemod mb.exe -stack 8000 
        erase roserver.pgm
        ren mb.exe roserver.pgm

mailwork.exe: mbuntmsg.c rose_ver.c msklibs.obj $(INCLUDE)
	cl $(CFLAGS)  mbuntmsg.c msklibs.obj
	exemod mbuntmsg.exe -stack 1000 
        erase mailwork.exe
	ren mbuntmsg.exe mailwork.exe

rmailer.exe: rmailer.c rose_ver.c mbutil2.obj 
	cl $(CFLAGS) rmailer.c mbutil2.obj
	exemod rmailer.exe -stack 4000

roseboot.exe: $(BOBJ1) $(BOBJ2) 
	cl /Fm roseboot $(BOOTOBJS) -link swin.lib
	exemod roseboot.exe -stack 4000 

rsmakdir.exe: rsmakdir.c rose_ver.c msklibs.obj
	cl $(CFLAGS) rsmakdir.c msklibs.obj

rsbidmgr.exe: rsbidmgr.c rose_ver.c msklibs.obj
	cl $(CFLAGS) rsbidmgr.c msklibs.obj

rosepwd.exe: rosepwd.c rose_ver.c
	cl $(CFLAGS) rosepwd.c

rs_btoa.exe: rs_btoa.c rose_ver.c
	cl $(CFLAGS) rs_btoa.c

rswp.exe: rswhitep.c rose_ver.c msklibs.obj $(INCLUDE) 
	cl $(CFLAGS) rswhitep.c msklibs.obj
	erase rswp.exe
	ren rswhitep.exe rswp.exe

roseuser.exe: roseuser.c rosesubs.obj msklibs.obj rose_ver.c $(INCLUDE)
	cl $(CFLAGS)  roseuser.c msklibs.obj rosesubs.obj

