
/*
	ROSECALL.C - call validation tables, used in ROSEDIST 
				 ROSERVER
*/
#define MAXPATS	34
char *call_pats[MAXPATS];
char **hamcaltab;
char **servcaltab;

/*
	val_call() - generalized check for anykind of valid call
*/
val_call(cp)
char *cp;
{
	return(iscall(cp,hamcaltab) || iscall(cp,servcaltab));
}


/*************************************************************
 * iscall() - code to check for a legal call sign. It is called
 * with a sign  of up to 12 chars and a null, base upon CALLLEN.
 *************************************************************/
iscall(cp,table)
char *cp, *table[];
{
	char call[13];
	register char *p;
	int i;

	strnxcat(call,cp,12);
	if (*cp) {
		/* convert call to out format */
		for ( p = call ; *p != '\0' ; p++) {
			if (isalpha(*p)) 
				*p = 'a';
			else 
				if (isdigit(*p)) 
					*p = 'n';
		}		
		/* compare to table entries */
		for ( i = 0; table[i][0] != '\0' ; i++) {
			if ( stricmp(call,table[i]) == 0) 
				return(TRUE);
		}
	}
	return(FALSE);
}
