/***************************************************************

  BayCom(R)           Packet-Radio Terminal for DOS

  BayCom-Terminal

  
  --------------------------
  Standard-Text entry/output
  --------------------------


  Copyright (C) 1999 Flori Radlherr, DL8MBT, flori@baycom.org
      
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 ***************************************************************/

#include "bct.h"

#define biosminuten ((unsigned)(*((long far *)MK_FP(0x40,0x6c))/1092))

// Format der Texte wie bei Digicom
//  <CR>
//  A1 texttext<CR>
//  A2 texttext<CR>
//  Z0 text<CR>
//  <NULL>
//

static int staste=0;         // aktuell ausgelesener Text (IBM-Zeichencode)
static int stptr=0;          // Zeiger auf momentane Ausleseposition
static int stbufptr=0;       // Zeiger auf Ausleseposition innerhalb Buffer
static char stbuf[40];       // Buffer fr Makros etc. innerhalb Text


void stlist(char *id)
//**********************************************************************
//
//  Liste der Standardtexte am Bildschirm ausgeben
//
//**********************************************************************
{ int i=1;
  int anzeig=(id[0]==0);     // wenn nix angegeben dann ales anzeigen
  char ch;

  while((ch=st[i])!=0)
  { if(st[i-1]==13)
    { if(anzeig!=1)
      { if(st[i]==id[0])  // feststellen, ob angezeit wird oder nicht
	  anzeig=2;
	else
	  anzeig=0;
      }
      if(anzeig)
      { putprompt(0);
	putf("ST ");
      }
    }
    i++;
    if(anzeig) putv(ch);
  }
}

char *timestr(time_t time)
// *************************************************************************
//
//   Legt die Uhrzeit (UNIX-Format) in einem String ab
//
// *************************************************************************
{ static char zeit[8];
  struct tm *tt=localtime(&time);
  if(tt)
  {
    sprintf(zeit,"%02d:%02d",tt->tm_hour,tt->tm_min);
    //strftime(zeit,sizeof(zeit),"%H:%M",localtime(&time));
  }
  else
    zeit[0]=0;
  return zeit;
}

int next_st_char(void)
//**********************************************************************
//
//  Hier wird der nchste auszugebende ST-Buchstabe aufbereitet
//  liegt kein ST an, so wird 0 zurckgegeben
//
//  Diese Funktion wird neben bioskey() zyklisch aufgerufen, um statt
//  von der Tastatur von einem ST einzulesen
//
//**********************************************************************
{ char retch=0;

  if(staste)                           // gibts berhaupt was auszugeben?
  { if(stbufptr!=NIXDRIN)              // ist was im Ausgabepuffer?
    { retch=stbuf[stbufptr++];
      if(stbuf[stbufptr]==0)           // Ende erreicht?
	stbufptr=NIXDRIN;
    }
    else
    { if(st[stptr]==13)             // Zeilenende in einem ST?
      { if(st[stptr+1]!=staste)     // geht der Text noch weiter?
	{ staste=0;                    // nein, also fertig machen
	  return 13;
	}
	else
	{ stptr+=3;                    // auf nchste Zeile positionieren
	  if(st[stptr]==' ')        // ggf. Blank berspringen
	    stptr++;
	  return 13;                   // Return zurckgeben
	}
      }

      if(st[stptr]=='\\')           // kommt als nchstes ein Makro?
      { stptr+=2;                      // Makro berspringen
	stbuf[1]=0;                    // Puffer fr 1 Zeichen vorbereiten
	switch(toupper(st[stptr-1]))
	{ case 'R':
	    stbuf[0]=13;               // Return
	    break;
	  case '7':
	    stbuf[0]=7;                // Klingel
	    break;
	  case 'Z':
	    stbuf[0]=26;               // CTRL-Z
	    break;
	  case 'X':                    // Zeile lschen
	    stbuf[0]=255;
	    break;
	  case 'C':                    // Call des Partners zurckgeben
	    strcpy(stbuf,get_partner());
	    break;
	  case 'M':                    // eigenes Call zurckgeben
	    strcpy(stbuf,get_mycall());
	    break;
	  case 'V':                    // Version des Terminals zurckgeben
	    strcpy(stbuf,VNUMMER);
	    break;
	  case 'T':                    // Uhrzeit
	  { struct time zeit;
	    gettime(&zeit);
	    sprintf(stbuf,"%02d:%02d",zeit.ti_hour,zeit.ti_min);
	  } break;
	  case 'D':                    // Datum
	  { struct date datum;
	    getdate(&datum);
	    sprintf(stbuf,"%02d.%02d.%02d",datum.da_day,datum.da_mon,
						(datum.da_year-1900)%100);
	  } break;
	  case 'L':                    // Loginzeit
	    sprintf(stbuf,"%s",timestr(b->logintime));
	    break;
	  case 'A':
	  { unsigned t=(unsigned)((time(NULL)-b->logintime)/60);
	    sprintf(stbuf,"%02u:%02u",t/60,t%60);
	  } break;
	  case 'K':                    // Portnummer
	    sprintf(stbuf,"%d",b->port);
	    break;
	  case 'I':                    // Zeilenende ignorieren
	  { if(st[stptr]==13)       // wirklich Zeilenende?
	    { if(st[stptr+1]!=staste)
		return staste=0;       // Text zuende, nix zurck
	      else
	      { stptr+=3;                  // sonst mit nchstem Text weiter
		if(st[stptr]==' ')
		  stptr++;
		stbuf[0]=st[stptr++];   // nchsten Charakter im Text
	      }
	    }
	  } break;
	  case '\\':                   // Backslash zurckgeben
	    stbuf[0]='\\';
	    break;
          case 'N': //Deti 04/96
            strcpy(stbuf,getname(get_partner()));
            if(!stbuf[0])
              strcpy(stbuf," ");
            break;
	  case 'W':                    // auf Connect warten
	  { int i=0;
	    while(st[stptr]==' ')   // Blank berspringen
	      stptr++;
	    while(st[stptr]>='-')   // Call einlesen
	    { b->waitcall[i++]=st[stptr++];
	      b->waitcall[i]=0;
	      if(i==10)break;          // hartes Ende erzwingen
	    }
	    b->waitstptr=stptr;     // Position merken
	    b->waitstaste=staste;   // Tastencode merken
	    strupr(b->waitcall);    // Call in Grossbuchstaben
	    b->connscharf=1;        // auf Connected-Meldung warten
	    staste=0;                  // Text-Ausgabe beenden
	  } return 0;
	}
	stbufptr=1;                    // erstes Zeichen sofort return
	retch=stbuf[0];
	if(stbuf[1]==0)                // nur ein Zeichen -> weitermachen
	  stbufptr=NIXDRIN;
      }
      else
	retch=st[stptr++];
    }
  }
  return retch;
}

int st_beginn(int taste)
{ staste=taste;
  stptr=1;                         // Am Anfang der Texte anfangen
  while(st[stptr])              // Nach Buchstaben suchen
  { if((st[stptr-1]==13)&&(staste==st[stptr]))
      break;
    stptr++;
  }
  if(st[stptr]==0)              // Ende erreicht?
  { staste=0;                      // Text nicht gefunden, nix machen
    stptr=NIXDRIN;
  }
  else
  { stptr+=2;                      // Kennung berspringen
    if(st[stptr]==' ')          // ggf. Blank berspringen
      stptr++;
  }
  stbufptr=NIXDRIN;                // vorerst nichts im Puffer
  return staste;
}

int st_taste(int scan)
//**********************************************************************
//
//  wird mit dem Scancode (nicht Zeichen!) einer Taste aufgerufen
//
//
//**********************************************************************
{ static char tasttab[52]=
  { '1','2','3','4','5','6','7','8','9','0',0,0,0,0,0,0,
    'Q','W','E','R','T','Y','U','I','O','P',0,0,0,0,
    'A','S','D','F','G','H','J','K','L',0,0,0,0,0,
    'Z','X','C','V','B','N','M'
  };

  if(staste || (scan<16))
    return 0;                        // gegen Rekursionen

  if((scan>=104)&&(scan<=113))       // Funktionstasten ALT-F1 .. ALT-F10
    scan-=104;

  if(scan<51)                        // Buchstaben-Code ?
    st_beginn(tasttab[scan]);         // Taste umcodieren (scancode -> ibm)
  return staste;                     // boolean: 'Text gefunden'
}

int waitpoll(void)
//**********************************************************************
//
//  Hier wird untersucht, ob der Zustand 'warten auf Connect' erfllt
//  ist und ein evtl. empfangenes Rufzeichen auf bereinstimmung
//  geprft. Ist das der Fall, so wird im der Textausgabe weitergemacht.
//
//**********************************************************************
{ int a;

  if(b->waitstaste)
  { if(strcmp(b->waitcall,get_partner())==0)
    { staste=b->waitstaste;
      stptr=b->waitstptr;
      b->waitstaste=0;
      while((a=next_st_char())!=0)
	tnc_putf("%c",a);
      tnc_flush();
      return 1;
    }
  }
  return 0;
}

void stsend(char buchst)
//**********************************************************************
//
//
//**********************************************************************
{ int a;

  if(st_beginn(buchst))
  { while((a=next_st_char())!=0)
      tnc_putf("%c",a);
    tnc_flush();
  }
}

int stbereit(void)
//**********************************************************************
//
//  gibt zurck, ob Zeichen in der Standardtextausgabe bereit liegen
//
//**********************************************************************
{ return staste;
}


int stfree(void)
//**********************************************************************
//
//  Stellt freien Speicherplatz fr Standardtexte fest
//
//**********************************************************************
{ int i=0;

  while(st[i++]);
  return MAXSTLEN-i;
}

char *stfind(char *id)
//**********************************************************************
//
//  Sucht einen Text mit der Kennung id
//
//  Rckgabe: Pointer auf den Beginn des Textes
//
//**********************************************************************
{ int i=1;

  while(st[i])                                   // Ende mit Null
  { if((st[i-1]==13)&&(id[0]==st[i])&&
       (!id[1]||(st[i+1]==' ')||(id[1]==st[i+1])))
      return st+i;                           // wenn Kennung passt retour
    i++;
  }
  return NULL;
}

void stdelete(char *id)
//**********************************************************************
//
//  Lscht einen Text mit der Kennung id
//
//
//**********************************************************************
{ char *s;

  while((s=stfind(id))!=NULL)
  { int i=1,j=0;
    while(s[i-1]!=13)
      i++;
    while(s[i-1])
    { s[j]=s[i];
      i++;
      j++;
    }
  }
}

void stinput(char *befbuf)
//**********************************************************************
//
//  Eingabe eines neuen Textes
//
//  der Text muss in folgender Form vorliegen:
//
//  a0 text.............
//
//  ggf. wird ein alter Text mit gleicher Kennung vorher gelscht
//
//**********************************************************************
{ char id[3];
  int offset=strlen(befbuf);
  //
  // Kennung des eingegebenden Textes feststellen
  //
  befbuf[0]=toupper(befbuf[0]);
  if(isalnum(befbuf[0]))
  { id[0]=toupper(befbuf[0]);
    if(isdigit(befbuf[1]))     // Zahl an zweiter Stelle?
      id[1]=befbuf[1];
    else if(!befbuf[1] || (befbuf[1]==' '))    // nur ein Buchstabe
      id[1]=0;                 // also abschliessen
    else
      return;                  // weder Zahl noch Blank -> ungltig
    id[2]=0;
  }
  else
    return;             // Kein Buchstabe -> ungltige Textkennung

  stdelete(id);         // ggf. Text mit dieser Kennung lschen
  //
  // zum richtigen Einsortieren nun nach einer Kennung suchen, die
  // lexikalisch hoeher ist als die eingegebene
  //
  if(offset>2)
  { int i=1,last=0;
    while(st[i])
    { if((st[i-1]==13)&&(st[i]>=id[0])&&(!id[1]||(st[i+1]==' ')
	 ||(st[i+1]>=id[1])||(st[i]>id[0])))
      { if(last==0)
	  last=i;
      }
      i++;
    }
    if(last==0) last=i;
    //
    // Luecke schaffen
    //
    if(stfree()>offset)
    { while(i>=last)
      { st[i+offset+1]=st[i];
	i--;
      }
      strcpy(st+i+1,befbuf);
      st[i+offset+1]=13;
    }
    else
      putf(">>> Out of memory.\r");
  }
}
