#ifndef _DIRUTIL_H
#define _DIRUTIL_H

#ifndef _GLOBAL_H
#include "global.h"
#endif

#ifdef UNIX
#ifndef _TIME_H
#include <time.h>
#endif

#if !defined(_DIRENT_H) && !defined(__dj_include_dirent_h_)
#include <dirent.h>
#endif

struct ffblk
{
    char ff_name[256];		/* current filename result */
    struct tm ff_ftime;		/* modify date/time */
    long ff_fsize;		/* file size */
    int ff_attrib;		/* DOS-style attributes (ugh) */
    /* ...only visible to internals... */
    char *ff_pfx;		/* prefix for found patterns */
    char *ff_pat;		/* pattern for the current level */
    DIR *ff_dir;		/* directory scan for the current level */
    struct dirent *ff_cur;	/* current path component */
    long ff_sattr;		/* selected attributes */
};

#define FA_NORMAL	0	/* anything except the following: */
#define FA_SYSTEM	1	/* device node or unreadable file */
#define FA_HIDDEN	2	/* dot-files */
#define FA_DIREC	4	/* directory */
#define FA_RDONLY	8	/* read-only file */

extern int findfirst (const char *pat, struct ffblk *ff, int attr);
extern int findnext (struct ffblk *ff);
#if 0
extern void findlast (struct ffblk *ff);
#endif
#endif

#ifdef MSDOS
# ifndef __dj_include_dir_h_
#  include <dir.h>
# endif
# ifndef __dj_include_dos_h_
#  include <dos.h>
# endif
#endif

struct cur_dirs {
#if !defined(TNOS_68K) && !defined(UNIX)
           int drv;
           char * curdir[27];
#endif
           char const * dir;                
};	/*lint !e770 */

/* In dirutil.c */
extern FILE *dir (char *path,int full);
extern int filedir (const char *name,int times,char *ret_str);
extern int getdir (char const *path,int full,FILE *file);
extern void undosify (char *s);
extern char * make_dir_path (int count,char *arg,const char* curdir);
extern char * make_fname (const char * curdir, const char * fname);
extern const char * init_dirs (struct cur_dirs * dirs);
extern void free_dirs (struct cur_dirs * dirs);
extern int dir_ok (char * path,struct cur_dirs * dirs);


/* In pathname.c: */
char *pathname (const char *cd,const char *path);

/* In bmutil.c */
long fsize (char *name);

#endif /* _DIRUTIL_H */


