/* Tracing routines for KISS TNC
 * Copyright 1991 Phil Karn, KA9Q
 *
 * Modified by G1EMM  19/11/90 to support multiport KISS mode.
 */

#include "global.h"
#include "mbuf.h"
#include "kiss.h"
#include "devparam.h"
#include "trace.h"

#if !defined(_lint)
static char rcsid[] OPTIONAL = "$Id: kissdump.c,v 1.11 2000/05/09 16:48:26 brian Exp $";
#endif


void
ki_dump (fp, bpp, check)
FILE *fp;
struct mbuf **bpp;
int check;
{
int type, t;
int val;

	type = PULLCHAR(bpp);
	t = type & 0x0f;
	if (t == PARAM_DATA || t == PARAM_CRCREQ)	{
#ifdef CTRACE
		if (!use_ctrace)
#endif
		traceprintf (fp, "KISS: Port %d Data\n", type >> 4);  /*lint !e702 */
		ax25_dump (fp, bpp, check);
#ifdef CTRACE
		if (use_ctrace)
			traceprintf (fp, Awhite);
#endif
		return;
	}
	if (type == PARAM_RETURN)	{
		traceprintf (fp, "RETURN\n");
		return;
	} else
		traceprintf (fp, "KISS: Port %d ", type >> 4);	/*lint !e702 */

	val = PULLCHAR(bpp);
	switch (type & 0x0f)	{
		case PARAM_TXDELAY:
			traceprintf (fp, "TX Delay: %lu ms\n", val * 10L);
			break;
		case PARAM_PERSIST:
			traceprintf (fp, "Persistence: %u/256\n", val + 1);
			break;
		case PARAM_SLOTTIME:
			traceprintf (fp, "Slot time: %lu ms\n", val * 10L);
			break;
		case PARAM_TXTAIL:
			traceprintf (fp, "TX Tail time: %lu ms\n", val * 10L);
			break;
		case PARAM_FULLDUP:
			traceprintf (fp, "Duplex: %s\n", (val == 0) ? "Half" : "Full");
			break;
		case PARAM_HW:
			traceprintf (fp, "Hardware %u\n", val);
			break;
	        case PARAM_POLL:
			traceprintf (fp, "Poll\n");
			break;
		default:
			traceprintf (fp, "code %u arg %u\n", type, val);
			break;
	}
}


int
ki_forus (iface, bp)
struct iface *iface;
struct mbuf *bp;
{
struct mbuf *bpp;
int i;

	if ((bp->data[0] & 0x0f) != PARAM_DATA)
		return 0;
	(void) dup_p (&bpp, bp, 1, AXALEN);
	i = ax_forus (iface, bpp);
	free_p (bpp);
	return i;
}
