#ifndef	_MBUF_H
#define	_MBUF_H

#ifndef _STDIO_H_
#define _STDIO_H_	1
#include <stdio.h>
#endif

#ifndef _GLOBAL_H
#include "global.h"
#endif

/* Basic message buffer structure */
struct mbuf {
	struct mbuf *next;	/* Links mbufs belonging to single packets */
	struct mbuf *anext;	/* Links packets on queues */
	int16 size;		/* Size of associated data buffer */
	int refcnt;		/* Reference count */
	struct mbuf *dup;	/* Pointer to duplicated mbuf */
	unsigned char *data;	/* Active working pointers */
	int16 cnt;
};
#define	NULLBUF	(struct mbuf *)0
#define	NULLBUFP (struct mbuf **)0

#define	PULLCHAR(bpp)\
 ((bpp) != NULL && (*bpp) != NULLBUF && (*bpp)->cnt > 1 ? \
 ((*bpp)->cnt--,(unsigned char)*(*bpp)->data++) : pullchar(bpp))

/* In mbuf.c: */
struct mbuf *alloc_mbuf (int16 size);
struct mbuf *free_mbuf (struct mbuf *bp);

struct mbuf *ambufw (int16 size);
struct mbuf *copy_p (struct mbuf *bp,int16 cnt);
int16 dup_p (struct mbuf **hp,struct mbuf *bp,int16 offset,int16 cnt);
struct mbuf *free_p (struct mbuf *bp);
int16 len_p (struct mbuf *bp);
void trim_mbuf (struct mbuf **bpp,int16 length);
int write_p (FILE *fp,struct mbuf *bp);

struct mbuf *dequeue (struct mbuf **q);
void enqueue (struct mbuf **q,struct mbuf *bp);
void free_q (struct mbuf **q);
int16 len_q (struct mbuf *bp);

struct mbuf *qdata (const unsigned char *data,int16 cnt);
int16 dqdata (struct mbuf *bp,unsigned char *buf,unsigned cnt);

void append (struct mbuf **bph,struct mbuf *bp);
struct mbuf *pushdown (struct mbuf *bp,int16 size);
int16 pullup (struct mbuf **bph,unsigned char *buf,int16 cnt);

int pullchar (struct mbuf **bpp);       /* returns -1 if nothing */
int16 pull16 (struct mbuf **bpp);	/* returns -1 if nothing */
uint32 pull32 (struct mbuf **bpp);	/* returns  0 if nothing */

int16 get16 (char *cp);
uint32 get32 (char *cp);
unsigned char *put16 (unsigned char *cp,int16 x);
unsigned char *put32 (unsigned char *cp,uint32 x);

#ifndef UNIX
void mbuf_crunch (struct mbuf **bpp);
#endif

#define AUDIT(bp)       audit(bp,__FILE__,__LINE__)

#endif	/* _MBUF_H */
