#ifndef	_NETROM_H
#define	_NETROM_H

#ifndef	_MBUF_H
#include "mbuf.h"
#endif

#ifndef	_IFACE_H
#include "iface.h"
#endif

#ifndef	_AX25_H
#include "ax25.h"
#endif

#ifndef _NR4_H
#include "nr4.h"
#endif

/* net/rom support definitions
 * Copyright 1989 by Daniel M. Frank, W9NK.  Permission granted for
 * non-commercial distribution only.
 */

#define NR3HLEN		15	/* length of a net/rom level 3 hdr, */
#define NR3DLEN		241	/* max data size in net/rom l3 packet */
#define NR3NODESIG	0xff	/* signature for nodes broadcast */
#define NR3POLLSIG  0xfe    /* signature for route poll - WG7J */
#define NR3NODEHL   7   /* nodes bc header length */

#define NRNUMCHAINS	17	/* number of chains in the */
				/* neighbor and route hash tables */
#define NRRTDESTLEN	21	/* length of destination entry in */
				/* nodes broadcast */
#define NRDESTPERPACK	11	/* maximum number of destinations per */
				/* nodes packet */

/* NET/ROM protocol numbers */
#define NRPROTO_IP	0x0c

/* Internal representation of net/rom network layer header */
struct nr3hdr {
	char source[AXALEN] ;	/* callsign of origin node */
	char dest[AXALEN] ;		/* callsign of destination node */
	unsigned ttl ;				/* time-to-live */
} ;

/* Internal representation of net/rom routing broadcast destination */
/* entry */
struct nr3dest {
	char dest[AXALEN] ;		/* destination callsign */
	char alias[AXALEN] ;			/* ident, upper case ASCII, blank-filled */
	char neighbor[AXALEN] ;	/* best-quality neighbor */
	unsigned quality ;		/* quality of route for this neighbor */
} ;

/* net/rom neighbor table structure */
struct nrnbr_tab {
	struct nrnbr_tab *next ;	/* doubly linked list pointers */
	struct nrnbr_tab *prev ;
    char call[AXALEN] ;         /* call of neighbor + 2 digis max */
    struct iface *iface ;
    unsigned refcnt ;           /* how many routes for this neighbor?    */
    int32 lastsent;             /* time when last sent via this neigbour */
    unsigned tries;             /* Number of tries via this neighbour    */
    unsigned retries;           /* Number of retries via this neighbour  */
} ;

#define	NULLNTAB	(struct nrnbr_tab *)0


/* A list of these structures is provided for each route table */
/* entry.  They bind a destination to a neighbor node.  If the */
/* list of bindings becomes empty, the route table entry is    */
/* automatically deleted.									   */

struct nr_bind {
	struct nr_bind *next ;		/* doubly linked list */
	struct nr_bind *prev ;
	unsigned quality ;		/* quality estimate */
	unsigned obsocnt ;		/* obsolescence count */
	unsigned flags ;
#define	NRB_PERMANENT	0x01		/* entry never times out */
#define NRB_RECORDED	0x02		/* a "record route" entry */
	struct nrnbr_tab *via ;		/* route goes via this neighbor */
} ;

#define	NULLNRBIND	(struct nr_bind *)0


/* net/rom routing table entry */

struct nrroute_tab {
	struct nrroute_tab *next ;	/* doubly linked list pointers */
	struct nrroute_tab *prev ;
	char alias[AXALEN] ;			/* alias of node */
	char call[AXALEN] ;		/* callsign of node */
	unsigned num_routes ;		/* how many routes in bindings list? */
	struct nr_bind *routes ;	/* list of neighbors */

} ;

#define	NULLNRRTAB	(struct nrroute_tab *)0


/* The net/rom nodes broadcast filter structure */
struct nrnf_tab {
	struct nrnf_tab *next ;		/* doubly linked list */
	struct nrnf_tab *prev ;
    char neighbor[AXALEN] ;     /* call of neighbor to filter */
    struct iface *iface ;       /* filter on this interface */
    unsigned quality;           /* explicit quality of this node */
} ;

#define	NULLNRNFTAB	(struct nrnf_tab *)0

/* Structure for handling raw NET/ROM user sockets */
struct raw_nr {
	struct raw_nr *prev;
	struct raw_nr *next;

	struct mbuf *rcvq;	/* receive queue */
	char protocol;		/* Protocol */
};
#define	NULLRNR	((struct raw_nr *)0)

/* The neighbor hash table (hashed on neighbor callsign) */
extern struct nrnbr_tab *Nrnbr_tab[NRNUMCHAINS] ;

/* The routes hash table (hashed on destination callsign) */
extern struct nrroute_tab *Nrroute_tab[NRNUMCHAINS] ;

/* The nodes broadcast filter table */
extern struct nrnf_tab *Nrnf_tab[NRNUMCHAINS] ;

/* filter modes: */
#define	NRNF_NOFILTER	0	/* don't filter */
#define	NRNF_ACCEPT	1	/* accept broadcasts from stations in list */
#define	NRNF_REJECT	2	/* reject broadcasts from stations in list */

/* The filter mode */
extern unsigned Nr_nfmode ;

/* The time-to-live for net/rom network layer packets */
extern unsigned short Nr_ttl ;

/* The quality threshhold below which routes in a broadcast will */
/* be ignored */
extern unsigned Nr_autofloor ;

/* The netrom pseudo-interface */
extern struct iface *Nr_iface ;

/* Functions */

/* In nr3.c: */
void del_rnr (struct raw_nr *rpp);
#if 0
char *find_nralias (char *);
#endif
struct nrroute_tab *find_nrroute (char *);
struct nrnbr_tab *find_nrnbr (char *, struct iface *);
void nr_bcnodes (struct iface *ifp);
void nr_bcpoll (struct iface *ifp);
void nr_nodercv (struct iface *iface,char *source,struct mbuf *bp);
int nr_nfadd (char *, struct iface *, unsigned);
int nr_nfdrop (char *, struct iface *);
void nr_route (struct mbuf *bp,struct ax25_cb *iaxp);
int nr_routeadd (const char *, char *, struct iface *,
	unsigned, char *, unsigned, unsigned);
int nr_routedrop (char *, char *, struct iface *);
int nr_send (struct mbuf *bp,struct iface *iface,uint32 gateway,int prec,
	int del,int tput,int rel);
void nr_sendraw (char *dest,unsigned family,unsigned proto,
	struct mbuf *data);
void nr3output (char *dest,struct mbuf *data);
int16 nrhash (char *s);
struct raw_nr *raw_nr (char);
struct nrroute_tab *find_nrboth (char *alias,char *call);

/* In nrcmd.c: */
void donrdump (struct nr4cb *cb);
int doroutedump (void);
int dorouteinfo (int argc,char *argv[],void *p);
int putalias (char *to, char *from,int complain);

/* In nrhdr.c: */
struct mbuf *htonnr3 (struct nr3hdr *);
struct mbuf *htonnrdest (struct nr3dest *);
int ntohnr3 (struct nr3hdr *, struct mbuf **);
int ntohnrdest (struct nr3dest *ds,struct mbuf **bpp);

#endif	/* _NETROM_H */
