/* the structures used for traffic statistics */

struct tfc_stats	{
	long	days;			/* days that stats are valid for */

	/* there are two 2 element arrays used:
	   xxx[0] is bulletins, xxx[1] is personal
	   xxx2[0] is NTS, xxx2[1] is forwarded */
	long	messages[2];		/* total cumulative traffic */
	long	messages2[2];		/* total cumulative traffic */

	/* these are for daily and weekly stats - two 2 element arrays, as before */
	long	hourly[24][2];		/* hourly info */
	long	hourly2[24][2];		/* hourly info */
	long	daily[7][2];		/* daily info */
	long	daily2[7][2];		/* daily info */
	long	monthly[31][2];		/* day/month info */
	long	monthly2[31][2];	/* day/month info */
	long	yearly[12][2];		/* month/year info */
	long	yearly2[12][2];		/* month/year info */

	/* these are the current hour and day - not updated till period is complete */
	long	hour[2];		/* current hour's info */
	long	hour2[2];		/* current hour's info */
	long	day[2];			/* current day's info */
	long	day2[2];		/* current day's info */
	long	month[2];		/* current month's info */
	long	month2[2];		/* current month's info */

	/* last stats start time */
	time_t	start;

	/* last update time */
	time_t	last;
};

