#!/usr/local/bin/tclsh

puts "Enter the maximum size you accept for a username"
gets stdin namelen

set fdin [open /nos/spool/users.dat r]
set fdout [open /nos/spool/users.tmp w]

proc dump {l h r t m f c} {
	puts "First line:"
	puts "Login: $l"
	puts "Home: $h"
	puts "Name: $r"
	puts "Time: $t"
	puts "More: $m"
	puts "Flags: $f"
	puts "Connect: $c\n"
}

while {[gets $fdin buf] > 0}	{
	set login [lindex $buf 0]
	set home [lindex $buf 1]

	set realname [lindex $buf 2]
	set offset 3
	while {[string first ")" $realname] == -1}	{
		set realname "$realname [lindex $buf $offset]"
		incr offset
	}

	set time [lindex $buf $offset]
	set more [lindex $buf [expr $offset + 1]]
	set flags [lindex $buf [expr $offset + 2]]
	set connect [lindex $buf [expr $offset + 3]]
	if {$connect == ""}	{
		set connect $flags
		set flags " "
	}

	if {[string index $home 0] != "@"}	{
		puts "Home PBBS incorrect!"
#		dump $login $home $realname $time $more $flags $connect
		continue
	}
	if {[string index $realname 0] != "("}	{
		puts "Real Name incorrect!"
#		dump $login $home $realname $time $more $flags $connect
		continue
	}
	if {[string length $login] > $namelen}	{
		puts "Too long of a login name!"
#		dump $login $home $realname $time $more $flags $connect
		continue
	}
	if {[string length $home] < 4}	{
		if {$home != "@" && $home != "@-"}	{
			puts "Too short of a home bbs name! Changing to @"
#			dump $login $home $realname $time $more $flags $connect
			set home @
		}
	}

	puts $fdout "$login $home $realname $time $more $flags $connect"
#	dump $login $home $realname $time $more $flags $connect
}

close $fdin
close $fdout
exec mv -f /nos/spool/users.tmp /nos/spool/users.dat 

