#ifndef	_IFACE_H
#define	_IFACE_H

#ifndef	_GLOBAL_H
#include "global.h"
#endif

#ifndef	_MBUF_H
#include "mbuf.h"
#endif

#ifndef _PROC_H
#include "proc.h"
#endif

struct flags {
	int16 maxframe;
	int16 t1init;
	int16 t2init;
	int16 t3init;
	int16 t4init;
	int16 t5init;
	int16 t6init;
	int16 retries;
	int16 axwindow;
	int16 paclen;
	int16 pthresh;
	int16 digipeat;
	int t3disc;
	int16 dama_slave;	/* flag for dama slave */
	int dama_busy;		/* wait */
};

/* Interface control structure */
struct iface {
	struct iface *next;		/* Linked list pointer */
	char *name;			/* Ascii string with interface name */
	int type;			/* Link header type for phdr */
	struct iftype *iftype;		/* Pointer to appropriate iftype entry */
	int32 addr;			/* IP address */
	int32 broadcast;		/* Broadcast address */
	int32 netmask;			/* Network mask */

	int (*ioctl) __ARGS((struct iface *, int, char **));
				/* From device -- when status changes */
	int (*iostatus) __ARGS((struct iface *,int cmd,int32 val));
				/* Encapsulate an IP datagram */
	int (*send) __ARGS((struct mbuf *,struct iface *,int32,int,int,int,int));
				/* Encapsulate any link packet */
	int (*output) __ARGS((struct iface *,char *,char *,int16,struct mbuf *));
				/* Send raw packet */
	int (*raw) __ARGS((struct iface *,struct mbuf *));
				/* Call before detaching */
	int (*stop) __ARGS((struct iface *,int));
				/* Display status */
	int (*status) __ARGS((struct iface *));

	int16 mtu;			/* Maximum transmission unit size */
	int dev;			/* Subdevice number to pass to send */
	int xdev;			/* Associated Slip or Nrs channel, if any */
	int port;			/* KISS-subaddr for multiport */
	int16 trace;			/* Trace flags */
#define	IF_TRACE_OUT	0x01	/* Output packets */
#define	IF_TRACE_IN	0x10	/* Packets to me except broadcast */
#define	IF_TRACE_ASCII	0x100	/* Dump packets in ascii */
#define	IF_TRACE_HEX	0x200	/* Dump packets in hex/ascii */
#define	IF_TRACE_NOBC	0x1000	/* Suppress broadcasts */
#define IF_TRACE_RAW	0x2000	/* Raw packet dump */
	char *trfile;			/* Trace file name, if any */
	FILE *trfp;			/* Stream to trace to */
	char *hwaddr;			/* Device hardware address, if any */
	struct iface *forw;		/* Forwarding interface for output, if rx only */
	struct iftcp *tcp;		/* Tcp protocol variables */
	int32 ipsndcnt;			/* IP datagrams sent */
	int32 rawsndcnt;		/* Raw packets sent */
	int32 iprecvcnt;		/* IP datagrams received */
	int32 rawrecvcnt;		/* Raw packets received */
	int32 lastsent;			/* Clock time of last send */
	int32 lastrecv;
	struct proc *proc;		/* Pointer to line process, if any */
	struct proc *proc1;		/* Second line process, if any */
	struct proc *supv;
#ifdef CRCSET
        int sendcrc;
        int32 crcerrors;
#endif
	void *extension;
	int niface;			/* Iface number for routing tables */
	struct lq *lq;			/* used by heard */
	int Hmax;
#define MAXDEFAULT	20		/* Initial heardtable value */
	int Hcurrent;
	struct flags *flags;		/* flags for AX25 use */
};
#define	NULLIF	(struct iface *)0
extern struct iface *Ifaces;		/* Head of interface list */
extern struct iface Loopback;		/* Optional loopback interface */
extern struct iface Encap;

/* Header put on front of each packet in input queue */
struct phdr {
	struct iface *iface;
	unsigned short type;		/* Use pktdrvr "class" values */
};

extern char Noipaddr[];
extern char Ifexist[];
extern struct mbuf *Hopper;
extern int Niface;

/* Interface encapsulation mode table entry. An array of these strctures
 * are initialized in config.c with all of the information necessary
 * to attach a device.
 */
struct iftype {
	char *name;			/* Name of encapsulation technique */
	int (*send) __ARGS((struct mbuf *,struct iface *,int32,int,int,int,int));
					/* Routine to send an IP datagram */
	int (*output) __ARGS((struct iface *,char *,char *,int16,struct mbuf *));
					/* Routine to send link packet */
	char *(*format) __ARGS((char *,char *));
					/* Function that formats addresses */
	int (*scan) __ARGS((char *,char *));
					/* Reverse of format */
	int type;			/* Type field for network process */
	int hwalen;			/* Length of hardware address, if any */
};
#define	NULLIFT	(struct iftype *)0
extern struct iftype Iftypes[];

/* In iface.c: */
void init_flags __ARGS((struct iface *ifp));
struct iface *if_lookup __ARGS((char *name));
struct iface *ismyaddr __ARGS((int32 addr));
int if_detach __ARGS((struct iface *ifp));
int setencap __ARGS((struct iface *ifp,char *mode));
char *if_name __ARGS((struct iface *ifp,char *comment));
int bitbucket __ARGS((struct iface *ifp,struct mbuf *bp));

#endif	/* _IFACE_H */
