/* Finger server */
#include <stdio.h>
#include <string.h>
#include "global.h"
#include "files.h"
#include "mbuf.h"
#include "socket.h"
#include "session.h"
#include "proc.h"
#include "dirutil.h"
#include "commands.h"
#include "mailbox.h"

static int Sfinger = -1;	/* Prototype socket for service */

static void
fingerd(s,unused,p)
int s;
void *unused;
void *p;
{
	FILE *fp;
	char *file, *cp, user[80];

	sockmode(s,SOCK_ASCII);
	sockowner(s,Curproc);
	log(s,"FING open");

	if(recvline(s,user,sizeof(user)) >= 0) {
		rip(user);
		if(strlen(user) == 0)
			usputs(s,((fp = dir(Fdir,0)) == NULLFILE) ?
				"No finger information available\n" :
				"Known users on this system:\n");
		else {
			file = pathname(Fdir,user);
			cp = pathname(Fdir,"");
			/* Check for attempted security violation (e.g., somebody
			 * might be trying to finger "../ftpusers"!)
			 */
			if(strncmp(file,cp,strlen(cp)) != 0){
				fp = NULLFILE;
				usputs(s,"Invalid user name\n");
			} else if((fp = fopen(file,READ_TEXT)) == NULLFILE)
				usprintf(s,"Unknown user '%s'\n",user);
			xfree(cp);
			xfree(file);
		}
		if(fp != NULLFILE){
			sendfile(fp,s,ASCII_TYPE,0);
			fclose(fp);
		}
	}
	log(s,"FING close");
	close_s(s);
}

/* Start up finger service */
int
finstart(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct sockaddr_in lsocket;
	int s;

	if(Sfinger != -1){
		return 0;
	}
	psignal(Curproc,0);	/* Don't keep the parser waiting */
	chname(Curproc,"Finger listener");

	lsocket.sin_family = AF_INET;
	lsocket.sin_addr.s_addr = INADDR_ANY;
	lsocket.sin_port = (argc < 2) ? IPPORT_FINGER : atoi(argv[1]);

	Sfinger = socket(AF_INET,SOCK_STREAM,0);
	bind(Sfinger,(char *)&lsocket,sizeof(lsocket));
	listen(Sfinger,1);
	for(;;){
		if((s = accept(Sfinger,NULLCHAR,NULLINT)) == -1)
			break;	/* Service is shutting down */

		/* Spawn a server */
		newproc("fingerd",1024,fingerd,s,0,NULL,0);
	}
	return 0;
}

int
fin0(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	close_s(Sfinger);
	Sfinger = -1;
	return 0;
}
