#ifndef _NNTP_H
#define _NNTP_H

#ifndef _GLOBAL_H
#include "global.h"
#endif

#ifndef _TIMER_H
#include "timer.h"
#endif

#ifndef _SMTP_H
#include "smtp.h"
#endif


/****************************************************************/
/*                                                              */
/*	   Compiler option for nntp restriction (DG1ZX)		*/
/*                                                              */
/*  Reject user request when no top level group is selected     */
/*  e.g. * | *.* | *.*.*                                        */
/*                                                              */
/****************************************************************/
#define NNTPRESTRICT

/****************************************************************/
/*                                                              */
/*	   Compiler option for nntp history lifetime (DG1ZX)	*/
/*                                                              */
/*  Reject user request when poll date is older than history    */
/*  lifetime. Analyse incoming articles if lifetime exceeded    */
/*                                                              */
/****************************************************************/
#define NNTPLIFETIME

/****************************************************************/
/*                                                              */
/*	   Compiler option for POST command (DG1ZX)		*/
/*                                                              */
/****************************************************************/
#define POST_ENBL

/************************************************************************/
/* 									*/
/*   Compiler option for XHDR command (DG1ZX)				*/
/*  									*/
/*   syntax: XHDR header [articlerange] 				*/
/*  									*/
/*   header is a case-insensitive header field, minus any colons. 	*/
/*   articlerange is one of: 						*/
/*   - an article number 						*/
/*   - an article number followed by a dash to indicate all following 	*/
/*   - an article number followed by a dash followed by another article */
/*     number  								*/
/*  									*/
/*   e.g., 								*/
/*  									*/
/*   XHDR subject                 retrieve subject of current article 	*/
/*   XHDR subject 5589-6325       retrieve subject of arts 5589 to 6325 */
/*   XHDR subject 5589-           retrieve subject of arts 5589 and up 	*/
/*   XHDR subject 5589            retrieve subject of art 5589 only 	*/
/*  									*/
/*   This command is an extension and not included in RFC 977.		*/
/*  									*/
/************************************************************************/
#define XHEADER

#define SECONDS     (1L)
#define MINUTES     (60L * SECONDS)
#define HOURS       (60L * MINUTES)
#define DAYS        (24L * HOURS)

#define LineLen 512

struct nntpsv {
	int s;
	int ret;
	int debug;
	int slave;
	unsigned  first;
	unsigned  last;
	unsigned  pointer;
	unsigned  hold_i;

	char buf[LineLen];
	char *newnews;
	char *path;
	char *id;

	int32 dest;
	int32 unixtime;
	long ftime;
	struct date *datest;
	struct time *timest;

	struct article *ap;
};
#define NULLNNTPSV (struct nntpsv *)0

struct article {
	char *group;
	char *id;
	char *path;
	unsigned number;
	unsigned tmpu;
	struct article *next;
};
#define NULLARTICLE (struct article *)0

struct post {
	char *user;
	char *reply;
	char *sig;
	char *organ;
	char *fullname;
};
#define NULLPOST (struct post *)0

struct groups {
	struct article *a;
	struct article *next;
};
#define NULLGROUP (struct groups *)0

struct head {
	char *from;
	char *reply_to;
	char *subject;
	char *id;
};
#define NULLHEAD (struct head *)0

struct g_list {
	char *str;
	struct g_list *next;
};
#define NULLG (struct g_list *)0

struct search {
	struct g_list *not;
	struct g_list *all;
	struct g_list *group;
};
#define NULLSEARCH (struct search *)0

struct DFREE {
	unsigned char drive;
	unsigned long bytes;
	struct DFREE *next;
};
#define NULLDRV (struct DFREE *)0

struct Servers {
	struct timer nntpt;
	char *name;
	int32 dest;
	char *newsgroups;   	/* list of newsgroups */
	int lowtime;            /* for connect window */
	int hightime;
	struct Servers *next;
};
#define NULLSERVER (struct Servers *)0

extern char NEol[];

int nntp1 	__ARGS((int argc, char *argv[], void *p));
int nntp0 	__ARGS((int argc, char *argv[], void *p));
int donntp 	__ARGS((int argc, char *argv[], void *p));
int nnGpost __ARGS((FILE *data,char *from,struct list *le));

/* in nntpcli.c */
extern char *Host;
extern char msgid[];
extern char subj[];
extern char ngrps[];
extern char ndate[];
extern char frm[];
extern char reply_to[];
extern char pth[];
extern int LzwActive;
extern int16 Nntpquiet;
extern struct post Post;
extern struct Servers *Nntpserver;
extern int fullauto;
#ifdef POST_ENBL
extern int postingok;
#endif
#ifdef NNTPRESTRICT
extern int restrict;
#endif
#ifdef NNTPLIFETIME
extern int16 lifetime;
#endif

/* in nntpserv.c */
extern char fatal[];
/*int doarticle __ARGS((char *buf,struct nntpsv *mp,char flag)); */
int doarticle __ARGS((char *buf,struct nntpsv *mp,char flag, char *hname));

/* in nntpsubr.c */
extern int Filecheck;
time_t articletime __ARGS((char *line));
int check_system __ARGS((void));
void rip2 __ARGS((char *s));
int recv_file __ARGS((FILE *fp,int s));
int check_article __ARGS((char *id));
int xfer_article2 __ARGS((FILE *fp,struct nntpsv *mp));
int garbled __ARGS((FILE *fp));
int check_blank __ARGS((char *bp));
int get_path2 __ARGS((struct article *ap));
int32 make_nntime __ARGS((struct date *d,struct time *t,char *str));
#if (defined(NNTPRESTRICT) || defined(NNTPLIFETIME))
int newnews __ARGS((char *string,struct nntpsv *mp,FILE *f,char serv_cli));
#else
int newnews __ARGS((char *string,struct nntpsv *mp,FILE *f));
#endif
int check_ihave __ARGS((FILE *fp, char *id,struct nntpsv *mp, char *hostn));
int make_path __ARGS((char *group,char w));

#endif /* _NNTP_H */
