#
#               THUNDER, Direcotry access control file
#
# Wildcards are supported in many places.  With wildcards we attempt to
# match something with just more than a straight comparison.
#
#    Special characters in the pattern are:
#
#    * -- Matches 0 or more characters of any type
#    @ -- a..z, A..Z
#    # -- 0..9
#    + -- A..z, A..Z, 0..9
#    ? -- A-F, a-f, 0-9 (a hex number)
#    < -- a..z
#    > -- A..Z
#    $ -- =@#+?<>$
#    = -- Any one character
#    " -- Escape.  The next character in the pattern much match exactly.
#         wild cards will not be interpreted.
#    ( -- Group.  A "(" starts a group and a ")" ends it.  For each
#         group, there must be a matching character in the string.
#         Example: (abc) matches b.  Wild cards are not interpreted.
#
#  Examples:
#
#  PAS*     --  Will match anything starting with PAS such as PASCAL,
#               PASSWORD, PASasb, and PAS.
#  PAS===   --  Will match anything that starts with PAS and is 5 characters
#               long.  PASCAL will match but PASA will not.
#  PAS###   --  Will match anything that starts with PAS and has 5 digits.
#               PAS123 will match but PASabc will not.
#  T?(CP)*  --  Will match anything starting with T any C or P.
#
#  *C:*     --  Denied total access to drive C
#
*BORDLANC* *PASCAL* *ASM* *T(CP)* *MBSOURCE* *THSOURCE* *INTERNAL* *D:*
#
