/*

INFO.C

Ce programme est utilisable comme commande a distance de TPK.
Ce n'est pas un serveur accessible par message, son fonctionnement est
identique au serveur SERVINFO.

Il repond aux commandes /INFO ou /INFO nnn.

Il retourne en reponse le fichier INFO.000 dans le premier cas et le
fichier INFO.nnn dans le second cas.

Le fichier de configuration INFO.CFG devra etre dans le repertoire de
TPK (comme INFO.EXE) et peut contenir deux commandes:

PATH

Pour indiquer le chemin des fichiers INFO
(Cette commande est indispensable)
Ex: PATH C:\TPK\INFO

FILE

Pour eventuellement modifier le nom des fichiers INFO
(Cete commande est facultative, implicitement le nom est INFO)
Ex: FILE TEXT_INF
Dans ce cas INFO ira chercher des fichiers TEXT_INF.000 a 999

*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

void ReadCfg(void);

char str[255];
char line[256];
char Path_Tpk[129];
char Path_Info[129];
char FiInfo[9]="INFO";

void main(int argc, char *argv[])
{
char str1[129];
char str2[4];
FILE *fichin;

if (argc) strncpy(str1, argv[1], 3);

ReadCfg();

sprintf(str2, "%03d", atoi(str1));
sprintf(str1, "%s%s.%s", Path_Info, FiInfo, str2);
if ((fichin=fopen(str1, "r")) != NULL)
	{
	while (fgets(str, 80, fichin) !=NULL)
		{
		printf("%s", str);
		}
	fclose (fichin);
	}
else
	{
	printf("Pas d'info %s\n", str2);
	}
}

/* Lecture configuration */

void ReadCfg(void)
{
int i;
char cmd[81];
char par1[81];
char par2[81];
char *s;
FILE *fichin;

if (s=strcpy(str, Path_Tpk),s=strcat(str, "INFO.CFG"),
	(fichin=fopen(str, "r")) != NULL)
	{
	while (fgets(str, 80, fichin) !=NULL)
		{
		i=sscanf(str, "%s", cmd);
		if (i){
			i=sscanf(str, "%s %s %s", cmd,par1,par2);
			strcpy(cmd,strupr(cmd));
            /* Chemin des fichiers INFO.xxx */
            if (strcmp("PATH",cmd)==0)
				{
				strncpy(Path_Info, strupr(par1), 128);
				if ((*(Path_Info+strlen(Path_Info))) != '\\')
					strcat(Path_Info, "\\");
				}
            /* Nom des fichiers INFO */
            if (strcmp("FILE",cmd)==0) strncpy(FiInfo, strupr(par1), 8);
			}
		}
	fclose(fichin);
	}
}
