/*****************************************************************************/
/*	         							     */
/*									     */
/*    *****			  ***** 				     */
/*	 *****			*****					     */
/*	   *****	      *****					     */
/*	     *****	    *****					     */
/*  ***************	  ***************				     */
/*  *****************	*****************				     */
/*  ***************	  ***************				     */
/*	     *****	    *****	   TheNet       		     */
/*	   *****	      *****	   Portable. Compatible.	     */
/*	 *****			*****	   Public Domain		     */
/*    *****			  *****    G8KBB	 		     */
/*									     */
/* This software is public domain ONLY for non commercial use                */
/*                                                                           */
/*									     */
/*****************************************************************************/

/* Level 3, Internet Gateway Header file				     */
/* Version 1.00                                                              */
/* Dave Roberts G8KBB, 7, Rowanhayes Close, Ipswich, England		     */
/* 10-April-91								     */
/* This software is released into the public domain on the understanding
 * that it is to be used only for non life threatening, amateur, non 
 * commercial purposes only. 
 * It has been written expressly for use in self tuition of
 * people in amateur radio communications only. It is NOT claimed that this
 * software works correctly. 
 *
 * USELONG, if defined, causes long integers to be used where appropriate
 * so failing to define it will avoid longs completely !
 *
 * BYTE and WORD ordering are fixed, and need generalisation !
 *
 *
 * Released as TheNet X-1J, September 1993
 *
 * Released as TheNet X-1J release 4, January 1995
 */

/* IP protocol field values */
#define	ICMP_PTCL	1	/* Internet Control Message Protocol */
#define	TCP_PTCL	6	/* Transmission Control Protocol */
#define	UDP_PTCL	17	/* User Datagram Protocol */
#define	RSPF_PTCL	73	/* Radio Shortest Path First Protocol */

#define	MAXTTL		255	/* Maximum possible IP time-to-live value */

/* DoD-style precedences */
#define	ROUTINE		0x00
#define	PRIORITY	0x20
#define	IMMEDIATE	0x40
#define	FLASH		0x60
#define	FLASH_OVER	0x80
#define	CRITIC		0xa0
#define	INET_CTL	0xc0
#define	NET_CTL		0xe0

/* Amateur-style precedences */
#define	AM_ROUTINE	0x00
#define	AM_WELFARE	0x20
#define	AM_PRIORITY	0x40
#define	AM_EMERGENCY	0x60

/* Class-of-service bits */
#define	LOW_DELAY	0x10
#define	THROUGHPUT	0x08
#define	RELIABILITY	0x04

/* IP TOS fields */
#define	PREC(x)		((x)>>5 & 7)
#define	DELAY		0x10
#define	THRUPUT		0x8
#define	RELIABLITY	0x4

/* structure for an ip address ( avoid longs !!!! ) */

typedef union ip_addr_
{
	unsigned long Long;
	unsigned int  Short[2];
	unsigned char Bytes[4];
} ipaddr;

/* Format of a MIB entry for statistics gathering */
struct mib_entry {
/*	char *name;
*/	struct {
		unsigned integer;
	} value;
};

#define	TLB	30	/* Default reassembly timeout, sec */
#define	IPVERSION	4
#define	IP_MAXOPT	40	/* Largest option field, bytes */

#define	ipL2Modes		Ip_mib[0].value.integer
/* SNMP MIB variables, used for statistics and control. See RFC 1066 */
#define	ipForwarding		Ip_mib[1].value.integer
#define	ipDefaultTTL		Ip_mib[2].value.integer
#define	ipInReceives		Ip_mib[3].value.integer
#define	ipInHdrErrors		Ip_mib[4].value.integer
#define	ipInAddrErrors		Ip_mib[5].value.integer
#define	ipForwDatagrams		Ip_mib[6].value.integer
#define	ipInUnknownProtos	Ip_mib[7].value.integer
#define	ipInDiscards		Ip_mib[8].value.integer
#define	ipInDelivers		Ip_mib[9].value.integer
#define	ipOutRequests		Ip_mib[10].value.integer
#define	ipOutDiscards		Ip_mib[11].value.integer
#define	ipOutNoRoutes		Ip_mib[12].value.integer
#define	ipReasmTimeout		Ip_mib[13].value.integer
#define	ipReasmReqds		Ip_mib[14].value.integer
#define	ipReasmOKs		Ip_mib[15].value.integer
#define	ipReasmFails		Ip_mib[16].value.integer
#define	ipFragOKs		Ip_mib[17].value.integer
#define	ipFragFails		Ip_mib[18].value.integer
#define	ipFragCreates		Ip_mib[19].value.integer

#define	NUMIPMIB	19

/* IP header, INTERNAL representation */
typedef struct ip_ {
	unsigned char version;		/* IP version number */
	unsigned char tos;		/* Type of service */
	unsigned length;		/* Total length */
	unsigned id;			/* Identification */
	unsigned offset;		/* Fragment offset in bytes */
	struct {
		unsigned char df;	/* Don't fragment flag */
		unsigned char mf;	/* More Fragments flag */
	} flags;

	unsigned char ttl;		/* Time to live */
	unsigned char protocol;		/* Protocol */
	unsigned checksum;		/* Header checksum */
	ipaddr source;			/* Source address */
	ipaddr dest;			/* Destination address */
	unsigned char options[IP_MAXOPT];/* Options field */
	unsigned optlen;		/* Length of options field, bytes */
} IP;

#define	NULLIP	(IP *)0
#define	IPLEN	20	/* Length of standard IP header */

/* Fields in option type byte */
#define	OPT_COPIED	0x80	/* Copied-on-fragmentation flag */
#define	OPT_CLASS	0x60	/* Option class */
#define	OPT_NUMBER	0x1f	/* Option number */

/* IP option numbers */
#define	IP_EOL		0	/* End of options list */
#define	IP_NOOP		1	/* No Operation */
#define	IP_SECURITY	2	/* Security parameters */
#define	IP_LSROUTE	3	/* Loose Source Routing */
#define	IP_TIMESTAMP	4	/* Internet Timestamp */
#define	IP_RROUTE	7	/* Record Route */
#define	IP_STREAMID	8	/* Stream ID */
#define	IP_SSROUTE	9	/* Strict Source Routing */

/* Timestamp option flags */
#define	TS_ONLY		0	/* Time stamps only */
#define	TS_ADDRESS	1	/* Addresses + Time stamps */
#define	TS_PRESPEC	3	/* Prespecified addresses only */

/* structure for routing tables */

typedef struct iproute_
{
	ipaddr dest;
	ipaddr gateway;
	unsigned metric;
	unsigned timer;
	unsigned char bits;
	unsigned char interface;
	unsigned char flags;
#define	RTPRIVATE	0x1	/* Should the world be told of this route ? */
#define	RTTRIG	0x2		/* Trigger is pending for this route */
	unsigned char spare_byte;
} IP_ROUTE;

typedef struct iproutemb
{
	lhtyp link;
	IP_ROUTE route;
} IP_ROUTE_MB;

#define	NULLROUTE	(IP_ROUTE *)0


/* Cache for the last-used routing entry, speeds up the common case where
 * we handle a burst of packets to the same destination
 */
struct rt_cache {
	ipaddr target;
	IP_ROUTE *route;
};

typedef struct i_face_
{
	unsigned (*func)();	/* output handler for sending */
#ifdef MOD_MTU
	unsigned *mtu;		/* pointer to max MTU before fragmentation */
#else
	unsigned mtu;		/* max MTU before fragmentation */
#endif
/*	ipaddr *bcast;		   broadcast address for this interface */
	unsigned hwtype;
	unsigned port;		/* hardware port number */
} I_FACE;

#define MAXINTERFACES 3

typedef struct arp_tab_
{
	ipaddr dest;
	char callsign[7];
	unsigned timer;
	char dgmode;
	char hwtype;
	char publish_flag;
	char state;
} ARP_TAB;

typedef struct arp_tab_mb
{
	lhtyp link;
	ARP_TAB arp;
} ARP_TAB_MB;

#define NULLARP (ARP_TAB *)0

#define ARP_NETROM 0
#define ARP_AX25 3

#define MAXHWALEN 10
#define IPTYPE 42

#define ARP_REQUEST    1
#define ARP_REPLY      2
#define REVARP_REQUEST 3
#define REVARP_REPLY   4

#define ARP struct arp_
ARP
{
	unsigned hardware;
	unsigned protocol;
	unsigned char hwalen;
	unsigned char pralen;
	unsigned opcode;
	unsigned char shwaddr[MAXHWALEN];
	ipaddr sprotaddr;
	unsigned char thwaddr[MAXHWALEN];
	ipaddr tprotaddr;
};

#define NULLBUF ( void * )0

/* Pseudo-header for TCP and UDP checksumming */
struct pseudo_header {
	ipaddr source;		/* IP source */
	ipaddr dest;		/* IP destination */
	unsigned char protocol;		/* Protocol */
	unsigned length;		/* Data field length */
};
#define	NULLHEADER	(struct pseudo_header *)0

#ifndef USELONG
typedef union cksum_
{
	unsigned long Long;
	unsigned int  Short[2];
} CK_SUM;
#endif

/* From tnl7ip.c
 */
int ccpipr(void);
int showroute(struct iproute_ *,struct mhead *);
int show_ip_addr(union ip_addr_ *,struct mhead *);
int get_ip_addr(union ip_addr_ *,int *,char * *);
int ccparp(void);
int showarp(struct arp_tab_ *,struct mhead *);
int ccpipa(void);
int ccpipb(void);
int ccpips(void);
int rt_add(union ip_addr_ *,unsigned int ,union ip_addr_ *,int ,unsigned int ,unsigned int ,unsigned int );
int route_find(struct iproutemb * *,union ip_addr_ *,union ip_addr_ *,unsigned int );
int rt_drop(union ip_addr_ *,unsigned int );
int arp_add(union ip_addr_ *,unsigned int ,char *,unsigned int ,unsigned int ,unsigned int );
int find_arp(struct arp_tab_mb * *,union ip_addr_ *, unsigned int );
int arp_drop(union ip_addr_ *, unsigned int);

/* From iproute.c
 */
int ipinit(void );
int ipserv(void );
int ip_route( struct mhead * );
int is_my_ip_addr(union ip_addr_ *);
int is_broadcast_address(union ip_addr_ *);
struct iproute_ *rt_find(union ip_addr_ *);
unsigned nr_iface(struct mhead *,unsigned int ,union ip_addr_ *,unsigned int );
unsigned l2_iface(struct mhead *,unsigned int ,union ip_addr_ *,unsigned int );
struct arp_tab_ *res_arp(union ip_addr_ *,unsigned int );
unsigned int get16(struct mhead *);
int put16(unsigned int ,struct mhead *);
struct mhead *htonip(struct ip_ *,struct mhead *, BOOLEAN );
int ip_send(union ip_addr_ *,union ip_addr_ *,unsigned ,unsigned ,unsigned ,struct mhead *,unsigned short ,unsigned short ,unsigned );
#ifdef USELONG
unsigned short eac(long );
#else
unsigned short eac(void );
#endif
unsigned short cksum(struct pseudo_header *,struct mhead *,unsigned short );

#ifdef MSDOS
#define addsum( x ) ( ip_cksum.Long += (x) )
#endif

void *allocb();
mhtyp *gennhd();
