/*****************************************************************************/
/*	         							     */
/*									     */
/*    *****			  ***** 				     */
/*	 *****			*****					     */
/*	   *****	      *****					     */
/*	     *****	    *****					     */
/*  ***************	  ***************				     */
/*  *****************	*****************				     */
/*  ***************	  ***************				     */
/*	     *****	    *****	   TheNet       		     */
/*	   *****	      *****	   Portable. Compatible.	     */
/*	 *****			*****	   Public Domain		     */
/*    *****			  *****    NORD><LINK	 		     */
/*									     */
/* This software is public domain ONLY for non commercial use                */
/*                                                                           */
/*									     */
/*****************************************************************************/

/* Level 7A, Dataswitch							     */
/* Version 1.01  							     */
/* Hans Georg Giese, DF2AU, Hinter dem Berge 5, 3300 Braunschweig	     */
/* 05-MAY-88								     */

/* Modified Dec 90 / Jan 91 by D Roberts				     */
/*	Added DOS debug support ( #ifdef MSDOS ... )			     */
/*	Corrected bug in seteom() where indirection error		     */
/*	Changed signon optionally on MODBYSTRING & SIGNONTEXT  definition    */
/*	CQ command may be removed by defining NOCQ			     */
/*	modify position of variables for bank switched version		     */
/*  	Added register keyword to reduce code size                           */
/*	Use all.h header file                                                */
/*	Add additional command optionally on definition of STATSCMD          */
/*      Add optionally on HOSTCMD another command - 'host'                   */
/*      Make error message reflect permitted commands                        */
/*      Add 'BYE' message optionally on MODIFIED                             */
/*      Add 'bbs' command optionally on HOSTCMD                              */
/*      Add 'mheard' command optionally on MONITORCMD                        */
/*      Move beacon digilist to configuration area if MODIFIED defined       */
/*      Add MODE command parameter table support                             */
/*      Add TALK command optionally on TALKCMD definition                    */
/*      Upgrade password checking conditionally on MODIFIED                  */
/*      Add MANAGER and AUDIT commands optionally on MANAGED                 */
/*      Add Links command optionally on LINKSCMD                             */
/*      Make beacon timer configurable                                       */
/*      Add configuration option to make 'connect' to to BBS or host         */
/*      Add calibrate command optionally on CWID                             */
/*      Conditionally exclude HI and LOW on definition of NOHILOW            */
/*      Move order of commands so that LINKS precedes LOW                    */
/*      Add DXcluster command optionally on DXCLUSTER if HOSTCMD enabled     */
/*      Added Beacon text command optionally on MODIFIED                     */
/*      Added closedown command optionally on CLOSEDOWN                      */
/*      Add help messages control word for connect trying info message       */
/*      Add ACL command and related stuff                                    */
/*      Make all commands visible for sysop if help bit set                  */
/*      Add connect text message on alias l2 connect                         */
/*      Add help message                                                     */
/*      Add ALIAS, BBSAlias, HostAlias & DXCluster commands on MODIFIED      */
/*      Add QUIT as an alternative to Bye                                    */
/*      Added iproute command optionally on IPROUTE                          */
/*      remove unnecessary '== 1' and similar constructs                     */
/*      reduce min L4 retries to 1                                           */
/*      add MTU command                                                      */
/*      add METER command to control ADC                                     */
/*      change command interpreter to support 8 bit data option              */
/*      add option for reconnection to node after remote disconnection       */
/*                                                                           */
/* September 1993 - released as TheNet X-1J                                  */
/*                                                                           */
/*      add optional support for TexNet on variable TEXNET                   */
/*      add adc support ( mheard & adc command                               */
/*      upgrade ccpmet & table to support meters                             */

#include "all.h"
#include "tntyp.h"		/* Definition der Typen			     */
#ifdef BANKED
#define EXTERN extern
#else
#define EXTERN
#endif

#include "tnl7av.h"
#include "tnl7ae.h"		/* externe Definitionen			     */

/*---------------------------------------------------------------------------*/
#ifdef BANKED
extern char beades[];
extern char cqdest[];
extern char cqdil[];
#else
char	beades[] = { 'I','D',' ',' ',' ',' ','\140' }; /* Call fuer Bake     */
char	cqdest[] = { 'C','Q',' ',' ',' ',' ','\140' }; /* Call fuer CQ-Ruf   */
char	cqdil[]  = "";				    /* Digiliste fuer CQ-Ruf */
#endif
#ifndef MODIFIED
char	beadil[] = "";				    /* Digiliste fuer Bake   */
#else
extern char beadil[];
#endif
char	dmmsg[]  = "Busy from ";		    /* DM Meldung	     */
char	conmsg[] = "Connected to ";		    /* Connect Meldung	     */
char	version[] = SIGNONTEXT;			    /* Kopfmeldung	     */
/*---------------------------------------------------------------------------*/
partyp	partab[] = {		/* Parameter Tabelle			     */
	&maxdes,   1,    400,	/* maximale Laenge der Destination Liste     */
	&worqua,   0,    255,	/* minimale Qualiatet fuer Autoupdate	     */
	&ch0qua,   0,    255,	/* HDLC Kanal Qualitaet			     */
	&ch1qua,   0,    255,	/* RS232 Kanal Qualitaet		     */
	&obcini,   0,    255,	/* Anfangswert Knotenlebensdauer	     */
	&obcbro,   1,    255,	/* min Wert Restlebensdauer fuer Rundspruch  */
	&broint,   0, 0xffff,	/* Rundspruchintervall			     */
	&timliv,   0,    255,	/* Anfangswert Paketlebensdauer		     */
	&tratou,   5,    600,	/* Timeout in Level3			     */
	&tratri,   1,    127,	/* Versuche in Level3			     */
	&traack,   0,     60,	/* Level3 Wartezeit bis ACK		     */
	&trabsy,   1,   1000,	/* Level3 Busy Wartezeit		     */
	&trawir,   1,    127,	/* vorgeschlagene Fenstergroesse in Level3   */
	&conctl,   1,    127,	/* gebufferte Frames je Verbindung	     */
	&ininat,   0, 0xffff,	/* no-activity-timeout			     */
	&Ppar,     0,    255,	/* Entschlossenheit fuer Sendung frei        */
	&Wpar,     0,    127,	/* Zeitschlitzbreite			     */
	&Fpar,     1,     15,	/* Level2, Timer1			     */
	&Opar,     1,      7,	/* Level2, Fenstergroesse		     */
	&Npar,     0,    127,	/* Level2, Versuche			     */
	&T2par,    0,   6000,	/* Level2, Timer2			     */
	&T3par,    0, 0xffff,	/* Level2, Timer3			     */
	&Rpar,     0,      1,	/* Level2 Digipeating Freigabe		     */
	&VCpar,    0,      1,	/* Calls pruefen			     */
	&beacen,   0,      2,	/* Bake ein-aus				     */
	&cqen,     0,      1	/* CQ-Ruf ein-aus			     */
};

#ifdef MODIFIED
partyp modtab[] =
{
	&hstmod,  0,	1,	/* host mode, 0 = normal, 1 = rs232 ctrl */
	&cwiden,  0,	3600,	/* cwid repeat period in seconds */
	&cwspeed, 4,	10,	/* cwid tick period, in 10's of milliseconds*/
	&brochn,  0,	MAXPORTMASK,	/* nodes bcast channel control */
	&crlmod,  0,	3,	/* crosslink protocol mode setting */
	&Tpar,    0,	255,	/* TXdelay */
	&Dpar,    0,    1,	/* full duples control */
	&br1int,  0,    0xffff,	/* port 1 nodes broadcast period / control */
	&broalg,  0,    MAXPORTMASK,	/* node broadcast algorithm control */
	&beaint,  600,  3600,	/* beacon interval timer */
	&ctobbs,  0,    2,	/* connect to BBS if 1, DXC if 2, host otherwise*/
	&hlpflg,  0,	255,	/* help messages control word */
	&nohashnode, 0, MAXPORTMASK, /* no hash node b'cast port control */
	&enaliases,0,   1,	/* enable extra aliases monitoring */
	&reconnect,0,	1,	/* reconnect to node on remote disconnect */
	&no_slime, 0,	3,	/* slime trail control word */
	&no_digi,  0,   3	/* digi to / from node control word */
};
#endif

#ifdef MOD_MTU
partyp mtutab[] =
{
	&mtu_ip0,	64,	1024,	/* ip mtu for radio port */
	&mtu_ip1,	64,	1024,	/* ip mtu for rs232 port */
	&mtu_ipn,	64-20,	256-20,	/* ip mtu for netrom port */
	&mtu_i_max,	257,	1025,	/* max data in L2 I frame +1 */
	&mtu_l2_max,	328,	1096	/* total max frame size @ L2 */
};
#endif

#ifdef METERS
partyp mettab[] =
{
#ifdef ALL_METERS
	&meterflags,	0,	0x7fff,		/* mode flags */
#else
	&meterflags,	0,	511,		/* mode flags */
#endif
	&rxdev,		0,	255,		/* receiver deviation */
	&rxsigmin,	0,	255,		/* adc noise floor count */
	&rxsmeter,	0,	255,		/* s meter multiplier */
	&rxdb,		0,	255,		/* dB scale multipler */
	&dbfloor,	0,	255,		/* dB noise floor */
	&adcmult1,	0,	255,		/* voltage ( ch3 ) mult. */
	&adcmult2,	0,	255,		/* voltage ( ch4 ) mult. */
	&adcofs1,	0,	255,		/* voltage ( ch3 ) offset. */
	&adcofs2,	0,	255		/* voltage ( ch4 ) offset. */
#ifdef ALL_METERS
	,
	&adcmult3,	0,	255,		/* voltage ( ch1 ) mult. */
	&adcmult4,	0,	255,		/* voltage ( ch2 ) mult. */
	&adcofs3,	0,	255,		/* voltage ( ch1 ) offset. */
	&adcofs4,	0,	255		/* voltage ( ch2 ) offset. */
#endif
};
#endif

#ifdef PK96
partyp bratab[] =
{
	&brate0,	0,	6,
	&brate1,	0,	6
};
#endif

/*---------------------------------------------------------------------------*/
/* The audit command sets the value of the audit mask. Each bit corresponds
 * to a type of auditing as shown below :
 *           bit    use
 *            0     level 1 auditing enable
 *            1     level 2 auditing
 *            2     reserved
 *            3     level 4 auditing
 *            4     level 7 data switch - use of sysop command
 *            5     level 7 - all use commands ( overrides bit 4 )
 *            6     CPU statistics auditing enable
 *            7-15  reserved
 */

#ifdef MANAGED
partyp audtab[] =
{
	&auditmask,	0,	255
};
#endif

/*---------------------------------------------------------------------------*/
cmdtyp	cmdtab[] = {		/* Befehlstabelle			     */
        ccpcm1, ccpcon,
#ifndef NOCQ
	ccpcm8, ccpcq,
#endif
#ifdef	MODIFIED
	ccpc14, ccpbye,
    ccpc28, ccphlp,
#endif
	ccpcm2, ccpide,
	ccpcm3, ccpnod,
	ccpcm4, ccppar,
	ccpcm9, ccprou,
#ifdef  TALKCMD
        ccpc18, ccpcht,
#endif
#ifdef	STATSCMD
	ccpc12, ccpsts,
#endif
#ifdef	HOSTCMD
	ccpc13, ccphst,
	ccpc15, ccpbbs,
#ifdef DXCLUSTER
    ccpc23, ccpdxc,
#endif
#endif
#ifdef MONITORCMD
	ccpc16, ccpmh,
#endif
#ifdef MODIFIED
	ccpc17, ccpmod,
#endif
	ccpcm5, ccpres,
	ccpcm6, ccpsys,
	ccpcm7, ccpuse,
#ifdef LINKSCMD
	ccpc21, ccplin,
#endif
#ifndef NOHILOW
	ccpc10, ccphig,
	ccpc11, ccplow,
#endif
#ifdef ACL
	ccpc26, ccpacl,
#endif
#ifdef MANAGED
	ccpc19, ccpman,
	ccpc20, ccpaud,
#endif
#ifdef CWID
	ccpc22, ccpcal,
#endif
#ifdef CLOSEDOWN
	ccpc24, ccpclo,
#endif
#ifdef MODIFIED
	ccpc25, ccpbtx,
	ccpc27, ccpctx,
	ccpc33, ccpali,
#ifdef HOSTCMD
	ccpc29, ccpbba,
	ccpc31, ccphoa,
#endif
#ifdef DXCLUSTER
	ccpc30, ccpdxa,
#endif
	ccpc32, ccpbye,
	ccpc35, ccpui,
#endif
#ifdef IPROUTE
	ccpc36, ccpipr,
	ccpc37, ccparp,
	ccpc38, ccpips,
	ccpc39, ccpipa,
	ccpc40, ccpipb,
#endif
#ifdef MOD_MTU
	ccpc41, ccpmtu,
#endif
#ifdef METERS
	ccpc42, ccpmet,
	ccpc43, ccpadc,
	ccpc44, ccpad1,
	ccpc45, ccpad2,
#ifdef ALL_METERS
	ccpc49, ccpad3,
	ccpc50, ccpad4,
#endif
#endif
#ifdef PK96
    ccpc46, ccpbra,
#endif
#ifdef L3MONITOR
    ccpc47, ccpmh3,
#endif
#ifdef IPROUTE
    ccpc48, ccpart,
#endif
	0, 0
};

char	ccpcm1[] = "Connect";
char	ccpcm8[] = "CQ";
char	ccpcm2[] = "Info";
char	ccpcm3[] = "Nodes";
char	ccpcm4[] = "Parms";
char	ccpcm9[] = "Routes";
char	ccpcm5[] = "Reset";
char	ccpcm6[] = "Sysop";
char	ccpcm7[] = "Users";
#ifndef NOHILOW
char	ccpc10[] = "High";
char	ccpc11[] = "Low";
#endif
#ifdef STATSCMD
char	ccpc12[] = "Stats";
#endif
#ifdef HOSTCMD
char	ccpc13[] = "Host";
char    ccpc15[] = "BBS";
#ifdef DXCLUSTER
char    ccpc23[] = "DXcluster";
#endif
#endif
#ifdef MODIFIED
char	ccpc14[] = "Bye";
char	ccpc32[] = "Quit";
char	ccpc17[] = "Mode";
char    ccpc28[] = "Help";
#endif
#ifdef MONITORCMD
char    ccpc16[] = "MHeard";
#endif
#ifdef TALKCMD
char    ccpc18[] = "Talk";
#endif
#ifdef MANAGED
char	ccpc19[] = "Manager";
char	ccpc20[] = "Audit";
#endif
#ifdef LINKSCMD
char	ccpc21[] = "Links";
#endif
#ifdef CWID
char	ccpc22[] = "Calibrate";
#endif
#ifdef CLOSEDOWN
char	ccpc24[] = "Closedown";
#endif
#ifdef MODIFIED
char	ccpc25[] = "Btext";
char    ccpc27[] = "Ctext";
char    ccpc33[] = "Alias";
#ifdef HOSTCMD
char    ccpc29[] = "BBSAlias";
char    ccpc31[] = "HostAlias";
#endif
#ifdef DXCLUSTER
char    ccpc30[] = "DXCAlias";
#endif
char    ccpc35[] = "UI";
#endif
#ifdef ACL
char    ccpc26[] = "ACL";
#endif
#ifdef IPROUTE
char    ccpc36[] = "IProute";
char    ccpc37[] = "ARP";
char    ccpc38[] = "IPstats";
char    ccpc39[] = "IPaddress";
char    ccpc40[] = "IPbroadcast";
#endif
#ifdef MOD_MTU
char	ccpc41[] = "MTU";
#endif
#ifdef METERS
char	ccpc42[] = "Meters";
char	ccpc43[] = "Adc";
char	ccpc44[] = "Adc1";
char	ccpc45[] = "Adc2";
#ifdef ALL_METERS
char	ccpc49[] = "Adc3";
char	ccpc50[] = "Adc4";
#endif
#endif
#ifdef PK96
char    ccpc46[] = "Brate";
#endif
#ifdef L3MONITOR
char    ccpc47[] = "L3MHeard";
#endif
#ifdef IPROUTE
char    ccpc48[] = "ARPtimer";
#endif

/* the following table controls the display of commands and their use.
 * value 0 = command enabled, will be displayed in 'help' screen
 *       1 = command disabled, will display if enabled
 *       2 = enabled but will never display in help screen ( sysop cmds )
 * The order of these entries must match the order of the commands in the
 * cmdtab[] structure.
 */

#ifdef MODIFIED
unsigned char defcst[] = 
{ 0,	/* connect */
#ifndef NOCQ
  0,	/* cq */
#endif
  0,	/* bye */
  0,	/* help */
  0,	/* ident */
  0,	/* node */
  2,	/* parms */
  0,	/* route */
#ifdef TALKCMD
  0,	/* talk */
#endif
#ifdef STATSCMD
  0,	/* stats */
#endif
#ifdef HOSTCMD
  0,	/* host */
  0,	/* bbs */
#ifdef DXCLUSTER
  0,	/* dxcluster */
#endif
#endif
#ifdef MONITORCMD
  0,	/* mheard */
#endif
  2,	/* mode */
  2,	/* reset */
  2,	/* sysop */
  0	/* users */
#ifdef LINKSCMD
  ,2	/* links */
#endif
#ifndef NOHILOW
  ,2	/* high */
  ,2	/* low */
#endif
#ifdef ACL
  ,2	/* acl */
#endif
#ifdef MANAGED
  ,2	/* manager */
  ,2	/* audit */
#endif
#ifdef CWID
  ,2	/* calibrate */
#endif
#ifdef CLOSEDOWN
  ,2	/* closedown */
#endif
#ifdef MODIFIED
  ,2	/* btext */
  ,2	/* ctext */
  ,2	/* alias */
#ifdef HOSTCMD
  ,2	/* bbsalias */
  ,2	/* hostalias */
#endif
#ifdef DXCLUSTER
  ,2	/* dxcalias */
#endif
  ,0	/* Quit */
  ,2    /* UI   */
#endif
#ifdef IPROUTE
  ,0	/* iproute */
  ,0	/* arp */
  ,2	/* ipstats */
  ,2	/* ipaddress */
  ,2	/* ipbroadcast */
#endif
#ifdef MOD_MTU
  ,2	/* mtu */
#endif
#ifdef METERS
  ,2	/* meters */
  ,0    /* adc */
  ,2    /* adc1 */
  ,2    /* adc2 */
#ifdef ALL_METERS
  ,2	/* adc3 */
  ,2	/* adc4 */
#endif
#endif
#ifdef PK96
  ,2    /* brate */
#endif
#ifdef L3MONITOR
  ,2	/* L3MHeard */
#endif
#ifdef IPROUTE
  ,2	/* ARPtimer */
#endif
};
#endif

/*---------------------------------------------------------------------------*/
mainf() {			/* Einsprung vom Assembler Teil nach Init    */
  DIinc();			/* Interrupts aus			     */
  inivar();			/* Variable initialisieren		     */
  initmisc();
  initl4();			/* Level 4      "			     */
  l3init();			/* Level 3      "			     */
  l2init();			/* Level 2      "        		     */
#ifdef IPROUTE
  ipinit();			/* Initialise Internet gateway handler */
#endif
  hosini();			/* Hostinterface initialisieren		     */
  srand();			/* Zufallsgenerator initialisieren	     */
  decEI();			/* Interrupts wieder an			     */
  bstrng("\015\012");
  bstrng(version);		/* melden				     */
  bcalou(myid);			/* eigenes Call				     */
#ifdef MODIFIED
  bstrng(MODBYSTRING);
#else
  bstrng(")\015\012by NORD><LINK (DF2AU/DC4OX)\015\012\012");
#endif

  loop:				/* ewige Schleife			     */
    hostsv();			/* Hostinterface			     */
    l2();			/* Level 2				     */
    l3serv();			/* Level 3				     */
#ifdef IPROUTE
    ipserv();			/* route all outstanding IP frames           */
#endif
    l4serv();			/* Level 4				     */
    timsrv();			/* Timerservice				     */
#ifdef MSDOS
    inputdata();		/* poll for input data via DOS */
#endif
    goto loop;
}

/*---------------------------------------------------------------------------*/
VOID	inivar()		/* Variable initialisieren		     */
  {
  register unsigned cnt;	/* Scratch Zaehler			     */
  register char *chaptr;	/* fuer Passwort kopieren		     */

  inithd(&usccpl);		/* CCP User Liste initialisieren	     */
  inithd(&userhd);		/* User Liste initialisieren		     */

  for (cnt = 0, ptcrdp = ptcrdl;/* Patchcordliste aufbauen		     */
       cnt < NUMPAT; ++cnt, ++ptcrdp) {
    ptcrdp->luserl = 0;		/* kein Kontrollblock			     */
    }
  tic10 =			/* loeschen: 10ms Timer			     */
  lastic =			/* letzte Ablesung bei 0		     */
  tic1s =			/* Sekundenzaehler			     */
  beatim = 0;			/* Bakenuhr				     */

  if (!iswarm()) {		/* nur im Kaltstart			     */
    Ypar   = MAXL2L;		/* maximal Links in Level2		     */
    Tpar   = DEFTP;		/* Senderverzoegerung			     */
    Ppar   = DEFPER;		/* Persistance				     */
    Wpar   = DEFSLO;		/* Zeitscheibengroesse			     */
    Fpar   = DEFRAK;		/* Level2 FRACK				     */
    Opar   = DEFMAF;		/* Fenstergroesse in Level2		     */
    Npar   = DEFL2T;		/* Versuche in Level2			     */
    T2par  = DEFLT2;		/* Level2 Timer 2			     */
    T3par  = DEFLT3;		/* Level2 Timer 3			     */
    Rpar   = DEFRPA;		/* Level2 Digipeating			     */
    Vpar   = DEFL2L;		/* Level2 Protokollversion		     */
    Dpar   = DEFDPA;		/* Full-Duplex				     */
    xFpar  = DEFXFP;		/* Full-Duplex mit Flags		     */
    ininat = DEFNOA;		/* no-activity-timeout			     */
    conctl = DEFCON;		/* Frames im Buffer je Link		     */
    beacen = DEFBEA;		/* Bakenform				     */
#ifdef HOSTMODE
    hstmod = DEFHOS;		/* default host mode control */
#endif
#ifdef KISSMODE
    crlmod = DEFKIS;		/* default crosslink ( KISS ) mode setting */
#endif
#ifdef HOSTCMD
    bbsid[0] = hostid[0] = 
    hidlen = bbslen = 0;	/* clear the BBS and HOST destinations */
#ifdef MODIFIED
    cpy6ch(bbsalias, nulide);	/* Ident setzen				     */
    cpy6ch(hostalias, nulide);	/* Ident setzen				     */
#endif
#endif
#ifdef DXCLUSTER
    dxcid[0] =
    dxclen = 0;				/* clear the dxcluster destination */
#ifdef MODIFIED
    cpy6ch(dxcalias, nulide);	/* Ident setzen				     */
#endif
#endif
#ifdef MODIFIED
    memcpy( defcsr, defcst, sizeof( defcst ) );
    beaint = DEFBIN;		/* default beacon broadcast period */
    ctobbs = DEFCSB;		/* default 'connect' to BBS or host */
    *beatxt = '\0';			/* clear sysop beacon message */
    hlpflg = DEFHLP;		/* help messages default word */
    *contxt = '\0';		/* clear connect text message */
    enaliases = 0;
    nohashnode = DEFNOHASH;
#ifdef ACL
  inithd(&acl);			/* initialise access control list */
  acl_mask = acl_default = 0;
#endif
#endif

    paswle = 0;			/* Passwort aus Eprom kopieren		     */
    chaptr = &DEFPWD[0];
    while (*chaptr != 0)
     {
      paswrd[paswle++] = *chaptr++;
     }

    infmsg[0] = 0;		/* keine Info-Message			     */
    cpyid(myid, DEFCAL);	/* Call setzen				     */
    cpy6ch(alias, DEFIDE);	/* Ident setzen				     */
    VCpar  = DEFVAL;		/* Call pruefen				     */
    cqen   = DEFCQ;             /* CQ flag initialisation                    */
    reconnect = DEFRECONNECT;	/* initialise reconnect on disconnect flag   */
    no_slime = DEFNO_SLIME;	/* initalise slime trail control word        */
    no_digi = DEFNO_DIGI;	/* initialise digipeat control word          */
#ifdef METERS
    rxdev = DEFDEVMETER;	/* initialise rx dev meter control word      */
    meterflags = DEFMETERFLAGS;
    rxsigmin = DEFRXSIGMIN;
    rxsmeter = DEFRXSMETER;
    rxdb = DEFRXDB;
    dbfloor = DEFDBFLOOR;
    adcmult1 = DEFMULT1;
    adcmult2 = DEFMULT2;
    adcofs1 = DEFOFS1;
    adcofs2 = DEFOFS2;
    units1[0] = '\0';
    units2[0] = '\0';
#ifdef ALL_METERS
    units3[0] = units4[0] = '\0';
    adcmult3 = DEFMULT3;
    adcmult4 = DEFMULT4;
    adcofs3 = DEFOFS3;
    adcofs4 = DEFOFS4;
#endif    
#endif
#ifdef PK96
    brate0 = DEFBRATE0;
    brate1 = DEFBRATE1;
#endif
#ifdef PORTFLUSH
    for( cnt = 0; cnt < NUMPORTS; cnt++ )
        none_last_time[cnt] = flushed[cnt] = sentdata[cnt] = pending[cnt] = 0;
#endif
    }
#ifdef MANAGED
  auditmask = 0;
#endif
#ifdef PK96
  set_brates();
#endif
  }

/*---------------------------------------------------------------------------*/
VOID	timsrv()		/* zeitabhaengige Funktionen		     */
  {
  char	   *usnxtc;		/* naechstes Zeichen im Frame		     */
  char	   *cmdnam;		/* Befehlsname				     */
  unsigned zeit;		/* Zeit in 10ms seit letztem Service	     */
  unsigned usget;		/* Getcount				     */
  register unsigned cnt;	/* Scratch Zaehler			     */
  unsigned zeichen;		/* Scratch fuer gelesene Zeichen	     */
  register mhtyp *mhdp;		/* Pointer auf aktuelles Frame		     */
  mhtyp	   *usrmhd;		/* User MBHD Kopie			     */
  cmdtyp   *cmdpoi;		/* Pointer in Befehlstabelle		     */
  register mhtyp *bufpoi;       /* pointer for error message construction */
  unsigned len;			/* length of help string current line */

  DIinc();			/* Interrupts aus			     */
  zeit = tic10 - lastic;	/* vergangene Zeit seit letztem Service	     */
  lastic = tic10;		/* neuen Nullpunkt merken		     */
  decEI();			/* Interrupts wieder frei		     */

  if (zeit != 0)		/* nicht zu oft...			     */
    {
      l2timr(zeit);		/* an Level2 melden			     */
      if ((tic1s +=zeit) >= 100)	/* alle Sekunde:		     */
        {
          tic1s -=100;		/* Uebertrag merken			     */
          hostim();		/* Hostinterface			     */
          chknoa();		/* Nichtstuer ueberwachen		     */
          brosrv();		/* Rundsprueche				     */
          trasrv();		/* Level3 und Level4 Service		     */
          miscsrv();
          beacon();		/* Bake					     */
          arpsrv();
#ifdef PK96
          toggle_mail_led();
          ASCI1ESC();
#endif
        }
    }

#ifdef STATSCMD
  if( ++cpu2load >= 100 )	/* bump counter 2 every loop,                */
  {				/* and every 100 loops,                      */
    cpu2load -= 100;		/* reset the counter                         */
    cpuload++;			/* and bump the real counter, which thus     */
  }				/* indicates loops divided by 100            */
#endif

/*=== eingelaufene Info Frames fuer den CCP verarbeiten			  ===*/
  while ((mhdp = (mhtyp *) userhd.lnext) != (mhtyp *) &userhd.lnext)
   {                                             /* Info Frames fuer CCP     */
    unlink(mhdp);		/* Info aushaengen			     */

    for (userpo = (usrtyp *) usccpl.lnext;	/* User zur Info suchen	     */
        (usrtyp *) &usccpl != userpo;	        /* gesamte Liste absuchen    */
         userpo = userpo->unext) {
      if ((mhdp->usrtyp == userpo->typ_u) /* Usertyp und Kontrollblock	     */
        && (mhdp->l2lnk == userpo->cblk_u)) /* muessen passen		     */
          break;		/* dann gefunden			     */
      }

    if ((usrtyp *) &usccpl == userpo) {	/* kein User gefunden		     */
#ifdef MODIFIED
      new_user();
#else
      userpo = (usrtyp *) allocb();	/* dann ist es ein neuer Teilnehmer  */
      userpo->mbhd = 0;		/* keine Info wartend			     */
      userpo->errcnt = 0;	/* bisher keine Fehler			     */
      userpo->status = 1;	/* am CCP, Befehl kommt			     */
#endif
      userpo->sysflg = ! (userpo->typ_u = mhdp->usrtyp); /* Typ setzen	     */
      userpo->cblk_u = mhdp->l2lnk; /* Kontrollblock setzen		     */
      relink(userpo, usccpl.lprev); /* User in Kette haengen		     */
#ifdef TEXNET
      if( userpo->typ_u == 2 ) 
        userpo->cblk_u->realid[0] = -1 ;
#endif
#ifdef MODIFIED
      if( cmpcal( alias, mhdp->l2lnk->srcid ) && *contxt != '\0' )
      	putmsg( contxt );
      if( enaliases )
      {
#ifdef HOSTCMD
        clicnt = 0;
        if( cmpcal( bbsalias, mhdp->l2lnk->srcid ) )
          ccpbbs();
        else if( cmpcal( hostalias, mhdp->l2lnk->srcid ) )
          ccphst();
#ifdef DXCLUSTER
        else if( cmpcal( dxcalias, mhdp->l2lnk->srcid ) )
          ccpdxc();
#endif
#endif
      }
#endif
      }
/*=== eingelaufene Info Frames fuer User verarbeiten			  ===*/
    if (!(usrmhd = userpo->mbhd))
      userpo->mbhd = mhdp;
    else {
      usnxtc = usrmhd->nxtchr;
      usget = usrmhd->getcnt;
      while (usrmhd->getcnt < usrmhd->putcnt)
        getchr(usrmhd);
      while (mhdp->getcnt < mhdp->putcnt)
        putchr(getchr(mhdp), usrmhd);
      usrmhd->nxtchr = usnxtc;
      usrmhd->getcnt = usget;
      dealmb(mhdp);
      }
    while ((userpo != 0)	/* existiert der User noch?		     */
      && ((mhdp = userpo->mbhd) != 0) /* ist Info da?			     */
      && (getlin(mhdp) /* == 1*/ )) { /* ist es mindestens eine ganze Zeile? */
       clipoi = clilin;		/* Zeile als leer definieren		     */
       clicnt = 0;
      while ((mhdp->getcnt < mhdp->putcnt) /* so lange Zeichen vorhanden sind*/
        && (((zeichen = getchr(mhdp)) & 0x7f) != 0x0d)) { /* und kein <CR>     */
#ifdef MODIFIED
        if( !( hlpflg & 0x20 ) || userpo->status != 4 )
#endif
          zeichen &= 0x7f;
        if ((zeichen == 0x08) || (zeichen == 0x7f)) { /* Backspace	     */
          if (clicnt != 0) {	/* und Delete aussortieren		     */
            --clipoi;
            --clicnt;
            }
          }
        else {
          if ((zeichen != 0x0a) /* Linefeed zaehlt nicht mit		     */
            && (clicnt < 80)) {	/* Zeilenueberlauf beachten		     */
            *clipoi++ = zeichen;/* Zeichen merken			     */
            ++clicnt;		/* mitzaehlen				     */
            }
          }
        }
      if (mhdp->getcnt == mhdp->putcnt) { /* wenn nun alle Zeichen verbraucht*/
        dealmb(mhdp);		/* Buffer wieder freigeben		     */
        userpo->mbhd = 0;	/* und "keine Info mehr da" markieren	     */
        }

/*=== Zeile vom User auswerten						  ===*/
      clipoi = clilin;		/* zum Auswerten Pointer nach vorn	     */
#ifdef TEXNET
      if( userpo->typ_u == 2 && userpo->cblk_u->realid[0] == -1 )
      {
        userpo->cblk_u->realid[0] = 0;
        usnxtc = clipoi;
        usget = clicnt;
        if( (hlpflg & 0x80) && usrcmp( "*** LINKED to ", &clicnt, &clipoi ) )
        {
          if( getcal( &clicnt, &clipoi, 1, userpo->cblk_u->realid ) == 1 )
          {
            if( *contxt && ( hlpflg & 8 ) )
              putmsg( contxt );
          }
          else
            putmsg("Error - TexNet User ID invalid");
          clicnt = 0;
        }
        else
        {
          clipoi = usnxtc;
          clicnt = usget;
        }
      }
#endif
      if (userpo->status == 3  /* warten auf Passwort?		     */
#ifdef MANAGED
         || userpo->status == 5 /* wait for passwd ? */
#endif
#ifdef CLOSEDOWN
         || userpo->status == 7 /* waiting for closedown ?....... */
#endif
         )
      {
#ifdef MODIFIED
      cnt = 0;			/* initialise counter to start value         */
      while( clicnt > 0 )	/* step thru until eol or passwd found       */
      {
        if( *clipoi == ' ' ) { }	/* ignore spaces in the reply        */
        else if( *clipoi == paswrd[userpo->paswrd[cnt] & 0xff] )
        {			/* if the current char matches the passwd    */
          if( cnt == 0 )	/* if this is the first char in the passwd   */
          {
            usnxtc = clipoi;	/* then save the current position to try     */
            usget  = clicnt;	/* searching from if this one fails          */
          }
          if( ++cnt == 5 )	/* if a match is found for all 5 characters  */
          {
            clicnt = 0;		/* then scrap the rest of the line           */
            break;		/* and exit from the loop                    */
          }
        }
        else if( cnt > 0 )	/* if char does not match & we had a partial */
        {
          clipoi = usnxtc;	/* match then restart from the saved position*/
          clicnt = usget;
          cnt = 0;		/* and go back to scratch on the count       */
        }
        nxtcli();		/* step on one character and loop            */
      }
#else
        for (cnt = 0; cnt < 5; ++cnt) { /* 5 Zeichen als Antwort	     */
          if (skipspace() == 0) /* noch was da?		     */
            break;		/* nein, dann Ende			     */
          zeichen = *clipoi;	/* sonst Zeichen holen			     */
          nxtcli();
          if (paswrd[userpo->paswrd[cnt] & 0xff] != zeichen) /* stimmt?      */
            break;
          }
#endif
        if (cnt == 5)		/* 5 Richtige?				     */
          userpo->sysflg = 1;
#ifdef MANAGED
        if( userpo->status == 5 && userpo->sysflg == 1 )
          userpo->status = 6;				/* we made MANAGER ! */
        else
#endif
#ifdef CLOSEDOWN
        if( userpo->status == 7 && userpo->sysflg == 1 )
          stop();					/* do CLOSEDOWN !    */
        else
#endif
        userpo->status = 1;	/* neuer Status: warten auf Befehl	     */
        }
#ifdef TALKCMD
      if( userpo->status == 4 )
      {
          if( clicnt >= 3 && *clipoi == '/' && upcase(*(clipoi+1)) == 'E'
              && upcase(*(clipoi+2)) == 'X' )
          {
              userpo->status = 1;
              notify( myid, 4, this_station(), NULL, "has left you.", 13 );
              putmsg("Leaving talk.");
          }
          else
              notify( this_station(), 4, NULL, NULL, clipoi, clicnt );
      }
#endif
      else {

        if (userpo->status == 2) { /* warten auf Connect?		     */
          disusr(userpo->cblk_p, userpo->typ_p); /* dann beenden	     */
          userpo->status = 1;	/* neuer Status: warten auf Befehl	     */
          }

        if ( skipspace() && *clipoi != '#' ) { /*noch was in der Zeile?*/
          usnxtc = clipoi;
          usget = clicnt;	/* Position in der Zeile merken		     */
#ifdef MANAGED
	if( ( auditmask & 0x20 ) && clicnt /* > 0 */ )
		notify( L7id, 6, this_station(), NULL, clipoi, clicnt );
#endif
#ifdef MODIFIED
          for (cnt=0, cmdpoi = cmdtab;	/* Eingabe mit Tabelle vergleichen   */
               cmdpoi->cmdstr != 0; 	/* Ende ist NULL		     */
               ++cmdpoi, cnt++)		/* also, bump cnt in the loop */
#else
          for (cmdpoi = cmdtab;	/* Eingabe mit Tabelle vergleichen	     */
               cmdpoi->cmdstr != 0; /* Ende ist NULL			     */
               ++cmdpoi)
#endif
          {
            clipoi = usnxtc;
            clicnt = usget;	/* fuer jeden Test auf Zeilenanfang	     */
            cmdnam = cmdpoi->cmdstr;
            while ((clicnt != 0) && (*clipoi != ' ')) {
              if (upcase(*clipoi) != upcase(*cmdnam)) break; /* Abbruch bei ungleich */
              nxtcli();
              ++cmdnam;
              }
            if ((clicnt == 0) || (*clipoi == ' ')) break; /* passt das Wort? */
            }
          if (cmdpoi->cmdfun != 0) { /* auf Tabellenende gelaufen?	     */
            userpo->errcnt = 0;	/* nein, Fehlerzaehler ruecksetzen	     */
            skipspace(); /* vorruecken auf Argument	     */
#ifdef MODIFIED
            /* implement the '+' and '-' command controls. If sysop, and if
             * the first character following the command is '+' or '-', then
             * set or clear the command control flag ( ie bit 0 ).
             * Also, if the command is disabled, use cnt to apologise
             * The bit affected is the display or enable bit ( 'D' )
            */
            if( issyso() && ( *clipoi == '-' || *clipoi == '+' ) )
            {
                zeichen = ( *clipoi == '-' );
                nxtcli();
                if( skipspace() && upcase( *clipoi ) == 'D' )
                    len = 2;
                else
                    len = 1;
                if( zeichen )
                    defcsr[cnt] |= len;
                else
                    defcsr[cnt] &= ~len;
            }
            else if( ( defcsr[cnt] & 1 )
#ifdef ACL
#ifdef ACL_DISCMD_OVERRIDE
                     && ((acl_entry( this_station() ) & ACL_DIS_OVERRIDE )==0)
#endif
#endif
                   ) 

            {
                bufpoi = putals("Sorry, '");
                putstr( cmdpoi->cmdstr, bufpoi );
                putstr( "' is not enabled.", bufpoi );
                seteom( bufpoi );
            }
            else
#endif
            (*cmdpoi->cmdfun)(); /* Befehl ausfuehren			     */
            }
          else {
#ifdef MODIFIED
            /* print a more helpful error message that shows the commands
             * that can be used. If the control byte is zero, show it.
             * This means that sysop commands are never shown
             */
            bufpoi = putals("Invalid Command - Choose from :\015");
            len = bufpoi->putcnt;
            for (cnt=0, cmdpoi = cmdtab;	/* Eingabe mit Tabelle vergleichen	     */
               cmdpoi->cmdstr != 0; /* Ende ist NULL			     */
               ++cmdpoi, cnt++)
            {
                if(((defcsr[cnt] & 3)==0) || (userpo->sysflg && (hlpflg & 2)))
                {
                    if( bufpoi->putcnt - len > 70 )	/* line len exceeded?*/
                    {					/* if so, do cr-lf   */
                        putchr('\015', bufpoi );
                        len = bufpoi->putcnt;
                    }
                    putstr( cmdpoi->cmdstr, bufpoi);
                    putchr( ' ', bufpoi );
                }
            }
            seteom( bufpoi );
#else
            putmsg("Invalid Command (CONNECT CQ INFO NODES ROUTES USERS)");
#endif

            if (++userpo->errcnt == 5)  /* Fehler zaehlen		     */
#ifdef MODIFIED
               /* call the bye command rather than just throwing him off
               */
               ccpbye();
#else
            {
              disusr(userpo->cblk_u, userpo->typ_u);
              kilusr();		/* zuviel Mist? Rauswerfen		     */
            }
#endif
  } } } } } 
#ifdef MANAGED
  userpo = NULL;
#endif
}

/*---------------------------------------------------------------------------*/
VOID	l2tol7(opcod, link, type)/* auf S-Frame reagieren		     */
unsigned opcod;			/* Frametyp: 1=UA, 2=DISC, 3=DM, 4=?	     */
ctyp	 *link;			/* Kontrollblock			     */
unsigned type;		/* User Typ				     */
  {
  register unsigned cnt;	/* Scratch Zaehler			     */
  register ptctyp *patchp;
  register unsigned typ = type;		/* User Typ				     */

  if (opcod < 5) {		/* zulaessiger Frametyp?		     */

    if (opcod == 1) {		/* UA Frame				     */
      for (userpo = (usrtyp *) usccpl.lnext;	/* User in CCP-Liste suchen  */
           (usrtyp *) &usccpl != userpo;
           userpo = userpo->unext) {
        if ((userpo->status == 2) /* Status des Users: "SABM gegeben"?	     */
          && (userpo->typ_p == typ) /* Partner muss erwarteter Typ sein	     */
          && (userpo->cblk_p == (l2ltyp *) link)){ /* Kontrollblock passt?   */
          msgfrm('D', link, typ, conmsg); /* Erfolg melden		     */
          for (patchp = ptcrdl;	/* Platz in Patchcordliste suchen	     */
               patchp->luserl != 0;
               patchp += 2);
          patchp->luserl = userpo->cblk_u; /* beide User eintragen	     */
          patchp->lusert = userpo->typ_u;  /* Kontrollblock und Typ	     */
          (++patchp)->luserl = (l2ltyp *) link;
          patchp->lusert = typ;
          kilusr();		/* User aus Level7 entfernen		     */
          break;
          }
        }
      return;			/* fertig				     */
      }
    for (cnt = 0, patchp = ptcrdl; /* DISC oder DM erhalten		     */
         cnt < NUMPAT;		/* Patchcordliste nach User absuchen	     */
         ++cnt, ++patchp)
     {
      if ((patchp->lusert == typ)
        && (patchp->luserl == (l2ltyp *) link))
       {
        patchp->luserl = 0;	/* Eintrag loeschen			     */
        cnt ^= 1;   		/* auf andere Seite der Verbindung	     */
        patchp = &ptcrdl[cnt];
#ifdef MODIFIED
	if( (cnt & 1) == 0 && reconnect )
	{
            new_user();
            userpo->status = 0;
            userpo->cblk_u = (l2ltyp *)patchp->luserl;
            userpo->typ_u = patchp->lusert;
            relink( userpo, usccpl.lnext );
            putmsg( "Welcome back.");
        }
        else
#endif
            disusr(patchp->luserl, patchp->lusert);	/* Partner	     */
        patchp->luserl = 0;			/* Eintrag loeschen	     */
        return;					/* fertig		     */
       }
     }
    for (userpo = (usrtyp *) usccpl.lnext;	/* muss CCP User sein	     */
         (usrtyp *) &usccpl != userpo;	/* Tabelle absuchen		     */
         userpo = userpo->unext) {
      if ((userpo->typ_u == typ)
        && (userpo->cblk_u == (l2ltyp *) link)) {
        if (userpo->status == 2) /* User hat Connect gefordert?		     */
          disusr(userpo->cblk_p, userpo->typ_p); /* Partner abwerfen	     */
        kilusr();		/* und User selbst abwerfen		     */
        return;			/* fertig				     */
        }
      if (userpo->status == 2) { /* User hat Connect gefordert		     */
        if ((userpo->typ_p == typ) /* und Antwort kam vom Partner	     */
        && (userpo->cblk_p == (l2ltyp *) link)) {
          msgfrm('D', link, typ, ((opcod == 3)? dmmsg : "Failure with "));
          userpo->status = 1;	/* neuer Status ist "warten auf Befehl"	     */
          return;
        } }
      }
    }
  }

/*---------------------------------------------------------------------------*/
VOID	disusr(link, typ)	/* User abwerfen			     */
ctyp	 *link;			/* Kontrollblock			     */
unsigned typ;			/* User Typ				     */
  {
  register l2ltyp *cblk2;	/* Kopien der Kontrollblockpointer	     */
  register cirtyp *cblk4;
  register hustyp *cblk0;

  switch(typ)
   {
    case 4:			/* Circuit?				     */
     cblk4 = cirpoi;
     cirpoi = (cirtyp *) link;
     discir();
     cirpoi = cblk4;
     break;

    case 2:			/* Level2?				     */
     cblk2 = lnkpoi;
     lnkpoi = (l2ltyp *) link;
     dsclnk();
     lnkpoi = cblk2;
     break;


    default:			/* Host					     */
     cblk0 = hstusr;
     hstusr = (hustyp *) link;
     hstout();
     hstusr = cblk0;
   }
  }

/*---------------------------------------------------------------------------*/
BOOLEAN	fmlink(conflg, bufpoi)	/* Frame an User weiterreichen		     */
register mhtyp	*bufpoi;	/* Info					     */
register BOOLEAN conflg;	/* Congestion Flag			     */
  {
  register unsigned cnt;	/* Scratch Zaehler			     */

  for (cnt = 0, ptcrdp = ptcrdl; /* Patchcordliste absuchen		     */
       cnt < NUMPAT;		/* ob User connected ist zu Partner	     */
       ++cnt, ++ptcrdp)
   {
    if ((bufpoi->usrtyp == ptcrdp->lusert) /* Usertyp			     */
     && (bufpoi->l2lnk == ptcrdp->luserl)) /* und Kontrollblock gleich?	     */
     {
      cnt ^= 1;   		/* auf andere Seite der Verbindung	     */
      ptcrdp = &ptcrdl[cnt];
      bufpoi->l2lnk = ptcrdp->luserl; /* Kontrollblock des Pratners eintragen*/
      switch (ptcrdp->lusert)
       {
        case 4:					/* User ist Circuit?	     */
        return(itocir(conflg, bufpoi));

        case 2:					/* User ist Level2?	     */
        return(itolnk(conflg, bufpoi));

        default:
        return(hstrec(conflg, bufpoi));		/* User ist Host	     */
       }
      }
    }
  relink(unlink(bufpoi), userhd.lprev);		/* User ist im CCP	     */
  return(TRUE);
  }

/*---------------------------------------------------------------------------*/
VOID	seteom(bufpoi)		/* Ende Kennung an Frame anhaengen	     */
register mhtyp	*bufpoi;
  {
  mhtyp	mbhd;

  putchr('\015', bufpoi);		/* Zeilenende			     */
  rwndmb(bufpoi);			/* alle Pointer auf Null	     */
  inithd(&mbhd);
  relink(bufpoi, &mbhd);
  switch (bufpoi->usrtyp)
   {
    case 4:				/* User ist Circuit		     */
     itocir(1, bufpoi);
     break;

    case 2:				/* User ist Level2		     */
     itolnk(1, bufpoi);
     break;

    default:				/* User ist Host		     */
     hstrec(1, bufpoi);

   }
  }

/*---------------------------------------------------------------------------*/
VOID	beacon()		/* Bakenservice				     */
  {
  register unsigned kanal;		/* Kanal fuer Sendung		     */
  register mhtyp *bufpoi;		/* Buffer fuer Frame		     */

  if ((beacen != 0) && (nmbfre > 128)) { /* Bake frei und Platz?	     */
#ifdef MODIFIED
    if (++beatim >= beaint) {	/* alle beaint min			     */
#else
    if (++beatim >= 600) {	/* alle 10 min				     */
#endif
      beatim = 0;
      (bufpoi = (mhtyp *) allocb())->pid = PID_NO_L3; /* Buffer beschaffen   */
      putstr(version, bufpoi); /* Meldung in Buffer		     */
      if (alias[0] != ' ') {	/* Ident definiert?			     */
        putstr(" (", bufpoi);
        putcal(alias, bufpoi);	/* dann Ident auch in Buffer		     */
        putstr(") ", bufpoi);
#ifdef MODIFIED
        if( *beatxt != '\0' )		/* if we have additional beacon text */
          putstr( beatxt, bufpoi );	/* then add it to the message        */
#endif
        }
      putchr('\015', bufpoi);	/* Frame schliessen			     */

      for (kanal = 0; kanal < NUMPORTS; ++kanal) /* auf beide Kanaele geben  */
       {
        if ((beacen == 2) || (istraf[kanal] == 1))
         {
          rwndmb(bufpoi);		/* alle Pointer auf Null	     */
          sdui(beadil, beades, myid, kanal, bufpoi); /* als UI senden	     */
          istraf[kanal] = 0;		/* Bake fuer diesen Kanal erledigt   */
         }
       }
      dealmb(bufpoi);		/* Buffer wieder freigeben		     */
      }
    }
  }

/*---------------------------------------------------------------------------*/
#ifdef MODIFIED

/* common code to command interpreter and l2tol7() that creates a
 * structure for the user session.
 */
VOID new_user()
{
	userpo = (usrtyp *)allocb();
	userpo->mbhd = 
	userpo->errcnt = 0;
	userpo->status = 1;
}
#endif

/*---------------------------------------------------------------------------*/
#ifdef TEXNET
usrcmp( match, length, string )
register char *match;
register char * *string;
register unsigned *length;
{
	while( *match == *(*string) && *match && *length )
	{
		++*string;
		--*length;
		++match;
	}
	return( *match == '\0' );
}

#endif


/*--- Ende Level 7a ---------------------------------------------------------*/
