/**************************************************************************\
*                                                                          *
*                                                                          *
*    *****                      *****                                      *
*      *****                  *****                                        *
*        *****              *****                                          *
*          *****          *****                                            *
*            *****      *****                                              *
*              *****  *****                                                *
*            *****      *****                                              *
*          *****          *****          The Firmware. The Net.            *
*        *****              *****        Portable. Compatible.             *
*      *****                  *****      Public Domain.                    *
*    *****                      *****    By NORD><LINK.                    *
*                                                                          *
*                                                                          *
*                                                                          *
*    TNTYP.H   -   Headerfile for definition of structures                 *
*                                                                          *
*    angelegt:      DC4OX                                                  *
*    modifiziert:   G8KBB                                                  *
*                                                                          *
\**************************************************************************/

/*
 * Released as TheNet X-1J, September 1993
 */

/*
 * Add optional support for TexNet on declaration of TEXNET
 *
 * Released as TheNet X-1J release 4, January 1995
 */
 
typedef	unsigned uint;

/* typedef uint	 BOOLEAN;  */      /* duplicates all.h */

typedef	struct	lhead {		/* Bufferkopf				     */
	struct lhead *lnext;
	struct lhead *lprev;
	} lhtyp;

typedef	struct	l2lblk {	/* Level 2 Link Eintrag			     */
	char	state;		/* Status				     */
	char	srcid[7];	/* eigenes Call, Ident			     */
	char	dstid[7];	/* Gegenstation				     */
	char	viaid[8*7 +1];	/* Digipeaterliste zur Gegenstation	     */
	char	liport;		/* Port fuer Link			     */
	char	VR;		/* receice sequence Variable		     */
	char	VS;		/* send sequence Variable		     */
	char	lrxNR;		/* last received NR			     */
	char	ltxNR;		/* last transmitted NR			     */
	char	tries;		/* aktuelle Versuche			     */
	char	N2;		/* maximale Versuche			     */
	char	k;		/* Fenstergroesse			     */
	char	snglT1;		/* FRACK - ohne Digis			     */
	char	V2link;		/* Protokoll Version			     */
	char	RStype;		/* naechstes Antwortframe nach T2-Ablauf     */
	char	frmr[3];	/* FRMR Info Bytes			     */
	char	flag;		/* 5: L3, 6: busy, 7: DiscReq		     */
	uint	initT1;		/* T1 Wert fuer Initialisierung		     */
	uint	T1;		/* Timer 1				     */
	uint	T2;		/* Timer 2				     */
	uint	T3;		/* Timer 3				     */
	uint	noatou;		/* no-activity-timeout			     */
	uint	rcvd;		/* empfangene I Frames			     */
	uint	tosend;		/* zu sendende I Frames			     */
	lhtyp	rcvdil;		/* empfangene Info Liste		     */
	lhtyp	sendil;		/* zu sendende Info Liste		     */
#ifdef TEXNET
	char    realid[7];	/* texnet real user id details               */
#endif
	} l2ltyp;

typedef	struct	mhead {		/* Message Buffer Header		     */
	lhtyp	link;		/* Link zu Nachbarn der Kette		     */
	lhtyp	msg;		/* Kopf der Message Liste		     */
	char	*nxtchr;	/* Pointer auf naechstes Zeichen	     */
	uint	putcnt;		/* eingeschriebene Zeichen		     */
	uint	getcnt;		/* ausgelesene Zeichen			     */
	l2ltyp	*l2lnk;		/* Eintrag in LNKTBL			     */
	char	usrtyp;		/* Usertyp, 0=Host, 2=Enduser, 4=Circuit     */
	char	pid;		/* PID des Frames, VR-VS in Level 4	     */
	char	l2port;		/* Port, 0 = HDLC, 1 = RS232		     */
	char	morflg;		/* Frame besteht aus mehreren Teilen Flag    */
	char	l4trie;		/* Versuche in Level4			     */
	uint	l4time;		/* Timeout in Level4			     */
	} mhtyp;

typedef	struct	usrblk {	/* User Kontroll Block			     */
	struct usrblk *unext;	/* doppelt verkettete Liste		     */
	struct usrblk *uprev;
	char	status;		
				/* 0=leer, 1=am CCP, 2=ConReq, 3=Passworteing*/
				/* 4=Talk,                                   */
				/* 5=Manage/login 6=Manage/passwd ok         */
				/* 7 = closedown pending                     */
				/* 8 reserved for operator/login             */
				/* 9 reserved for operator/password ok       */
	l2ltyp	*cblk_u;	/* eigener Kontrollblock		     */
	char	typ_u;		/* eigener Typ				     */
	l2ltyp	*cblk_p;	/* Partner Kontrollblock		     */
	char	typ_p;		/* Partner Typ				     */
	char	sysflg;		/* SYSOP Flag				     */
	char	errcnt;		/* CCP Fehlerzaehler			     */
	char	paswrd[5];	/* gegebene Passwort Stellen		     */
	mhtyp	*mbhd;		/* eingelaufene Frames fuer User	     */
				/* Rest noch undefiniert		     */
        } usrtyp;

typedef	struct hostus {      /* Kontrollblock fuer zum Host connecteten User */
	char	conflg;		/* User ist connected Flag		     */
	char	call[6];	/* Call des Users			     */
	char	ssid;		/* SSID des Users			     */
	char	disflg;		/* Flag: Verbindung trennen, wenn Info weg   */
	uint	noacti;		/* Timer fuer keine Aktivitaet		     */
	uint	noact2;		/* Timer2 fuer keine Aktivitaet		     */
	uint	inlin;		/* eingelaufene Zeilen			     */
	uint	outlin;		/* auszugebende Zeilen			     */
	uint	duh2;
	lhtyp	inbuf;		/* Listenkopf Eingabebuffer		     */
	lhtyp	outbuf;		/* Listenkopf Ausgabebuffer		     */
	} hustyp;

typedef	struct	nbrent {	/* Nachbarliste				     */
	lhtyp	nbrlnk;		/* Link innerhalb der Liste		     */
	char	nbrcal[7];	/* Call					     */
	char	nbrdil[15];	/* Digipeater				     */
	char	nbrpor;		/* Port					     */
	char	pathqu;		/* Qualitaet des Weges			     */
	char	locked;		/* Flag: Eintrag gesperrrt j-n		     */
	uint	nbrrou;		/* Wege ueber diesen Nachbarn		     */
	l2ltyp	*nbrl2l;	/* Querverweis zur Level2 Tabelle	     */
	} nbrtyp;

typedef	struct	ziel {
	char	qualit;		/* Qualitaet				     */
	char	obscnt;		/* Lebensdauer Zaehler			     */
	nbrtyp	*nachba;	/* Nachbar				     */
	} wegtyp;

typedef	struct	nodent {	/* Nodeliste				     */
	lhtyp	nodlnk;		/* Link innerhalb der Liste		     */
	char	actrou;		/* aktive Wege zu diesem Ziel		     */
	char	nodide[6];	/* Ident dieses Zieles			     */
	char	nodcal[7];	/* Call des Zieles			     */
	char	wegnr;		/* Nummer des aktivens Weges		     */
	char	wege;		/* moegliche Wege			     */
	wegtyp	weg[3];		/* Wegbeschreibungen			     */
	lhtyp	nodinf;		/* Frames fuer dieses Ziel		     */
        } nodtyp;

typedef	struct	ptcent {	/* Patchcord Liste			     */
	l2ltyp	*luserl;	/* Level2 Link des Users		     */
	char	lusert;		/* Typ des Users			     */
        } ptctyp;		/* es gehoeren immer 2 Eintraege zusammen    */

typedef	struct	cirblk {	/* Level 3 Kontrollblock		     */
	char	state3;		/* Status: 0=leer, 1=ConReq, 2=Con, 3=DisReq */
	char	idxpar;		/* Partner Index			     */
	char	ideige;		/* eigener ID				     */
	char	idpart;		/* Partner ID				     */
	char	downca[7];	/* Downlink Call			     */
	char	upcall[7];	/* Uplink Call				     */
	char	window;		/* Fenstergroesse			     */
	char	l4rxvs;		/* letzte bestaetigte Framenummer	     */
	char	l4vs;		/* letzte gesendete Framenummer		     */
	char	l4vr;		/* letzte erhaltene Framenummer		     */
	char	l4rs;		/* notwendige Antwort: 0=ACK, 1=NAK, 2=NAKweg*/
	char	l4try;		/* Transport Versuche			     */
	char	l4flag;		/* DISC-req, selbst choked, Partner choked   */
	uint	traout;		/* Transport Timeout			     */
	uint	acktim;		/* Acknowledge Timer			     */
	uint	tranoa;		/* no-activity-Timeout			     */
	uint	numrx;		/* empfangene Frames			     */
	uint	numtx;		/* zu sendende Frames			     */
	mhtyp   *fragme;	/* Fragment eines kommenden Frames	     */
	nodtyp	*l3node;	/* Node fuer diesen Circuit		     */
	lhtyp	mbhdrx;		/* Listenkopf empfangene Frames		     */
	lhtyp	mbhdtx;		/* Listenkopf zu sendende Frames	     */
	lhtyp	mbhdos;		/* Listenkopf: Frames ausserhalb der Folge   */
	} cirtyp;

typedef	union cblk {		/* allgemeiner Kontrollblock		     */
	l2ltyp	l2blk;
	cirtyp	l3blk;
	hustyp	hoblk;
        } ctyp;
        
typedef struct	param {		/* Parameter				     */
  uint	*paradr;		/* Adresse des Parameters		     */
  uint	minimal;		/* Minimalwert				     */
  uint	maximal;		/* Maximalwert				     */
  } partyp;

typedef struct	comand {
        char	*cmdstr;
        uint	(*cmdfun)();
        } cmdtyp;

#ifdef MONITORCMD
typedef struct mheard
{
	struct mheard *nexthb;		/* Linked list pointers */
	struct mheard *prevhb;
	char call[7];			/* callsign of station heard */
	unsigned lastheard;		/* timestamp for last heard time */
	unsigned packets;		/* number of packets heard */
	unsigned char isnode;		/* flag denotes if it is a node */
	unsigned char istcpip;		/* flag denoted if it is tcp/ip */
#ifdef METERS
	unsigned char dev;		/* receiver deviation meter */
	unsigned char sig_level;	/* rx signal level ( s-meter ) */
#endif
	char l3dest[7];			/* callsign of station heard */
#ifdef TEXNET
	unsigned char istexnet;		/* flag denoted if it is texnet */
#endif
	unsigned port;			/* port station heard on */
} MHEARD;
#endif

#ifdef ACL
typedef struct aclentry_
{
	char call[7];			/* callsign of station in ACL */
	unsigned char value;		/* ACL value for station */
} ACLENTRY;

typedef struct aclmb
{
	struct aclmb *nextaclb;		/* linked list for ACL */
	struct aclmb *prevaclb;
	ACLENTRY entry[4];		/* set of 4 ACL entries in buffer */
} ACLMB;
#endif

/*--- Ende der Definitionen -------------------------------------------------*/

/* THE FOLLOWING ARE FROM L2x.C */


typedef struct l_head         /* "list head", Listenkopf :                */
  {
    struct l_head   *head;    /*   Zeiger auf ersten Eintrag in Liste     */ 
    struct l_head   *tail;    /*   Zeiger auf letzten Eintrag in Liste    */
  } LHEAD;


typedef struct lehead         /* "list entry head", Kopf eines Eintrags   */
  {                           /* in Liste :                               */
    struct lehead   *nextle;  /*   Zeiger auf naechsten Listeneintrag     */ 
    struct lehead   *prevle;  /*   Zeiger auf vorherigen Listeneintrag    */
  } LEHEAD;


typedef struct lnkblk         /* "link block", fuer jeden Level-2-Link :  */
  {
    char     state;           /* Link-State, s.o. L2S...                  */
    char     srcid[L2IDLEN];  /* "source id", eigenes Call/SSID oder      */
                              /* Ident/SSID                               */
    char     dstid[L2IDLEN];  /* "destination id", Call/SSID Gegenstation */
    char     viaidl[L2VLEN+1];/* "via id list", Digipeaterstrecke,        */
                              /* 0-terminiert, Weg zur Gegenstation       */
    char     liport;          /* "link port" - 0 : HDLC, 1 : Crosslink    */
    char     VR;              /* "receive sequence variable", Sequenz-    */
                              /* nummer des naechsten zu empfangenden     */
                              /* I-Frames                                 */
    char     VS;              /* "send sequence variable", Sequenznummer  */
                              /* des naechsten zu sendenden I-Frames      */
    char     lrxdNR;          /* "last received N(R)", zuletzt            */
                              /* empfangenes N(R) = eigene gesendete      */
                              /* I-Frames bis lrxdNR-1 bestaetigt         */
    char     ltxdNR;          /* "last transmitted N(R)", zuletzt         */
                              /* gesendetes N(R) = empfangene I-Frames    */
                              /* bis ltxdNR-1 bestaetigt                  */
    char     tries;           /* aktuelle Anzahl Versuche (RETRY),        */
                              /* hochzaehlend                             */
    char     N2;              /* RETRY, maximale Anzahl Retries           */
    char     k;               /* MAXFRAME, maximale Anzahl unbestaetigter */
                              /* I-Frames                                 */
    char     snglT1;          /* "single T1", T1 ohne Digikette = FRACK   */
    char     V2link;          /* "version 2 link" - 0 : Version 1 Link    */
                              /*                    1 : Version 2 Link    */
    char     RStype;          /* "response supervisory frametype", nach   */
                              /* T2-Ablauf zu sendendes Antwortframe      */
                              /* (RR=0x01, RNR=0x05, REJ=0x09)            */
    char     frmr[3];         /* die 3 FRMR-Infobytes, Sendung u. Empfang */
                              /*   frmr[0] : zurueckgewies. Kontrollfeld  */
                              /*   frmr[1] : V(R) CR V(S) 0               */
                              /*   frmr[2] : 0000ZYXW                     */
    char     flag;            /* Flag (s.o. L2F... )                      */
                              /*   Bit 0 : nicht benutzt                  */
                              /*   Bit 1 : nicht benutzt                  */
                              /*   Bit 2 : nicht benutzt                  */
                              /*   Bit 3 : nicht benutzt                  */
                              /*   Bit 4 : nicht benutzt                  */
                              /*   Bit 5 : 1 = Link ist Level 3 Link      */
                              /*           (festgestellt anhand PID !)    */
                              /*   Bit 6 : 1 = (eigenes) Device busy      */
                              /*   Bit 7 : 1 = Link disconnecten, sobald  */
                              /*           Sendeliste (sendil) leer ist   */
    unsigned initT1;          /* "initial T1", (2 * Anzahl Digis + 1) *   */ 
                              /* snglT1(= FRACK) * 100 in 1/100 sek       */
    unsigned T1;              /* Timer 1, "frame acknowledge interval",   */
                              /* Start :  initT1 + random(),              */
                              /* 0 = inaktiv, 10 msec Downcounter         */
    unsigned T2;              /* Timer T2, "response delay timer",        */
                              /* 0 = inaktiv, 10 msec Downcounter         */
    unsigned T3;              /* Timer T3, "inactive link timer",         */
                              /* 0 = inaktiv, 10 msec Downcounter         */
    unsigned noatou;          /* "no activity timeout",                   */
                              /* nach Ablauf Link disconnecten,           */
                              /* 0 = inaktiv, 1 sec Downcounter           */
    unsigned rcvd;            /* "received", Anzahl empfangener I-Frames  */
                              /* in rcvdil                                */
    unsigned tosend;          /* Anzahl noch nicht gesendete oder         */
                              /* unbestaetigte Frames in sendil           */
    LHEAD    rcvdil;          /* "received info list", richtig            */
                              /* empfangene I-Frames, mit Header/PID      */
    LHEAD    sendil;          /* "send info list", zu sendende I-Frames,  */
                              /* ohne Header/PID, nur Info                */
#ifdef TEXNET
    char     realid[L2IDLEN]; /* texnet real user id details              */
#endif
  } LNKBLK;



#ifdef FIRMWARE

typedef struct timebl              /* "time block", Zeit/Datums-Stamp :   */
  {
    char             second;       /*   Zeit :    Sekunde   (0..59)       */
    char             minute;       /*             Minute    (0..59)       */
    char             hour;         /*             Stunde    (0..23)       */
    char             day;          /*   Datum :   Tag       (1..31)       */
    char             month;        /*             Monat     (1..12)       */
    char             year;         /*             Jahr      (0..99)       */
  } TIMEBL;
 
#endif

/* ACHTUNG: mbhead muss genauso lang sein wie mb !                        */

typedef struct mbhead         /* "message buffer head",                   */
  {                           /* Datenbuffer-Liste, Kopf :                */
    struct mbhead   *nextmh;  /*   naechster Eintrag in Liste             */
    struct mbhead   *prevmh;  /*   vorheriger Eintrag in Liste            */
    LHEAD            mbl;     /*   "message buffer list", Zeiger auf      */
                              /*   ersten Infobuffer dieser Message       */
    char            *mbbp;    /*   "message buffer buffer pointer",       */
                              /*   Zeiger auf aktuelles Zeichen in Buffer */
    unsigned         mbpc;    /*   "message buffer put count",            */
                              /*   Einschreibzaehler, aufwaertszaehlend   */
    unsigned         mbgc;    /*   "message buffer get count",            */
                              /*   Lesezaehler, aufwaertszaehlend         */
    struct lnkblk   *l2link;  /*   Zeiger auf assozierten Linkblock       */
    char             type;    /*   Typ des Buffers (User, Status)         */
                              /*          L2M...                          */
                              /*     oder MB...                           */
                              /*     oder 0 User, 2 Level-2, 4 Level-4    */
    char             l2fflg;  /*   Level 2 Frameflag / PID :              */
                              /*     RX: PID                              */
                              /*     TX: PID / s.o. T2FT1ST/T2FUS         */
    char             l2port;  /*   0 = HDLC, 1 = RS232-Crosslink          */
    char             morflg;  /*   "more follows flag" fuer Pakete, die   */
                              /*   durch zusaetzlichen Netzwerkheader zu  */
                              /*   lang wuerden und in 2 Frames           */
                              /*   aufgetrennt wurden                     */
                              /*     YES = das naechste Frame gehoert zu  */
                              /*           diesem Paket                   */
                              /*     NO  = sonst                          */
    unsigned char   rxdev;    /* deviation meter reading for packet recvd */
    unsigned char sig_level;  /* rx signal level ( s-meter )              */
#ifdef FIRMWARE
    char             rsvd[8];/*   (damit insgesamt Laenge wie mb)        */
    TIMEBL           btime;   /*   Buffer-Time fuer Zeit/Datum-Stamps     */
#else
    char             rsvd[14];/*   (damit insgesamt Laenge wie mb)        */
#endif

  } MBHEAD;


/* ACHTUNG: mb muss genauso lang sein wie mbhead !                        */

typedef struct mb             /* "message buffer",                        */
  {                           /* allgemeiner Datenbuffer :                */
    struct mb *nextmb;        /*   naechster Eintrag in Liste             */
    struct mb *prevmb;        /*   vorheriger Eintrag in Liste            */
    char       data[32];      /*   Daten                                  */
  } MB;



typedef struct stentry        /* "state table entry",                     */
  {                           /* ein Eintrag in der State-Table :         */
    VOID       (* func)();    /*   Zustandsuebergangsfunktion             */
    char       newstate;      /*   neuer Zustand                          */
  } STENTRY;


#ifdef FIRMWARE

typedef struct heardb              /* "heard buffer", ein Eintrag         */
  {                                /* in der Heardliste :                 */
    struct heardb   *nexthb;       /*   Zeiger auf naechsten L.-Eintrag   */
    struct heardb   *prevhb;       /*   Zeiger auf vorherigen L.-Eintrag  */
    char             hid[L2IDLEN]; /*   ID der gehoerten Station          */
    TIMEBL           hfirst;       /*   zuerst gehoert                    */
    TIMEBL           hlast;        /*   zuletzt gehoert                   */
    unsigned         hIno;         /*   Anzahl gehoerte I-Frames          */
    unsigned         hRRno;        /*   Anzahl gehoerte RR-Frames         */
    unsigned         hREJno;       /*   Anzahl gehoerte REJ-Frames        */
    unsigned         hRNRno;       /*   Anzahl gehoerte RNR-Frames        */
    char             hrsvd[5];     /*   (reserviert)                      */
  } HEARDB;

#endif
