;=====================================================================
LED0		equ     P1.6 ;  Red   LED via 7404 to +5v
LED1	   	equ     P1.7 ;  Green LED via 7404 to +5v
;----------------------------;
RxD     	equ     P3.0 ; connect to TxD IBM PC (for future)
TxD     	equ     P3.1 ; connect to RxD IBM PC via MAX232 or 
			     ; similar RS-232 transeiver
DIN		equ     P3.2 ; input from data comparator
;=====================================================================
FS_0    equ       01111100b       ; Frame Syncronisation
FS_1    equ       11010010b       ; codeword
FS_2    equ       00010101b       ;
FS_3    equ       11011000b       ;	7CD215D8
;--------------------------------------
FSI_0   equ       10000011b       ; Frame Syncronisation (inverted)
FSI_1   equ       00101101b       ; codeword
FSI_2   equ       11101010b       ;
FSI_3   equ       00100111b       ;	832DEA27
;--------------------------------------
Idle_0  equ       01111010b       ; Idle
Idle_1  equ       10001001b       ; codeword
Idle_2  equ       11000001b       ;
Idle_3  equ       10010111b       ;	7A89C197 (85763E68)
;--------------------------------------
;=====================================================================
; constants for using buffers
;
BUF_DATA_SIZE	equ	252	; Size of buffer (1..252)
LOW_FREE_MEMORY equ	10	; free buffers to drop CTS
HIGH_FREE_MEMORY equ	20	; free buffers to set  CTS
MAX_STRING_LEN	equ	8192	; maximum length of input string ;!!
;=====================================================================
;F_osc		equ	18.432   	; quartz frequency in MHz
;-----------------------
T0_512          equ     10000h-375	; (F_osc/18.432)/512 /4
T0_1200         equ     10000h-160	; (F_osc/18.432)/1200/4
T0_2400         equ     10000h-80	; (F_osc/18.432)/2400/4
T9600		equ     10000h-160	; (F_osc/18.432)/9600
;=====================================================================
;
cmp		%MACRO	t1,t2
		cjne	t1,t2,$+3
		%ENDM

Delay           %MACRO  tau
		%GENSYM lbl_delay
                mov     Task0_10ms,#tau/10
                clr	A
lbl_delay:
		WatchDog

                cjne    A,Task0_10ms,lbl_delay
                %ENDM

Message         %MACRO  text
                lcall   Msg
                db      text
                db      0
                %ENDM
;-----------------------
Red_On:		%MACRO
		setb	LED0
		%ENDM
Red_Off:	%MACRO
		clr	LED0
		%ENDM
;-----------------------
Green_On:	%MACRO
		setb	LED1
		%ENDM
Green_Off:	%MACRO
		clr	LED1
		%ENDM
;=====================================================================