/* 980117 OE1TKW Code wiederbelebt      */
/* 990207 OE1TKW clx version */
/* MINIFTZ24, COPYRIGHT BY FTZ DARMSTADT, FGR FI34, JUNE 1987
   HF-FIELD STRENGTH PREDICTION
   TRANSFORMATION FROM GW-BASIC TO TURBO-C BY OE1TKW */
/* code and structures parallel to pascal */
/* to ease up comparison with pascal version */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#define CR 13

/* CLX stuff */
#include "ftz.h"


/* Prototypes */
int FIX (float a);
int CINT(float a);
static void StartDat (void);
void sublev (void);
void readdat (void);
void decode (void);
void muf (void);
void kormu (void);
void bear (void);
void decile (void);
void fcor (void);
void angle (void);
void modang (void);

/*char *data_filename;*/
char data_filename[80];
char *ftz_filename="ftzmuf2.dat";
FILE  *point; /* FTZMUF2.DAT */
char *trace_filename="ftz.debug";
FILE *trac;
float sii;
char TestDaten = 0;
char Debug=0;
char Durchlauf1=1;
char *ch;
char *zeich;
//float PI;
float angm=3;
float sag=0;
float zkw=1;
int iproz=50;
int ianz=12;
int realen=9;
int month=1;
int jahr=98;
float zpi;
float dpi;
float ak;
float bk;
float dk=0.0062137;
float ro=6371.2;
float xlg=2.30259;
int ii,it,ilg,i,j,k,l,m,n,lt,lb,mon,mon1,mon2,m1,m2,n1,n2;
int lf1,lf2,lx,jj1,jj2,im,iv1,lw;
int imit;
int ia;
int iw;
int ian,ihope,ihopf,ihop,k5,k6,k1,k2,k3,k4;
int ilf,ilb;
float elu,x,y,gx,q,gax,ax,sn,t,bx,di,dx_f,ft,fh,xr,xk;
float dif,cm,xm3x,xcmd,xm3,bm,fak,f10,f50,f90,f4000,gyro,gcdkm;
float ufcor,ufmax,ufmin,ufqu,yy;
float u,u1,su,zxx1,zxx2,zyy1,zyy2,df,sind,bt;
float si,ffg,disdb,disfg,wal;
float v,z,elz;
float hp,xkm,as,zz,hopkm;
float w,d_f;
float ssp,ssn,x1,fy1,x2,y2,xx1,xx2,yy1,yy2;
float gcd,gcdk,hopkme,hopkmf,hop,archop,ar2,phif,dp2n,gcdko,delta,phid,b;
float dp,dn2,dn4,dfk,fluna,abklp,zx1,zx2,zy1,zy2,zgcd,btr1,btr2;
float arc,elfc,flfc,pp,cenlat,cenlg,wow,wns,xow,xns,yow,yns,btt,zb,zl;
float ww,xx,yy,gyr,gamma3,gmt,zt,cycen,xke,xn,fe,a,c,focus,d0,xm,fm2,fl2;
float clm,f9,flf,ffm,feld;
char pws='Y';          /*pw$   angle-und mode table*/
char ps='S';           /*p$    long/short Path*/
char aas;              /*a$    */
char ts[6];            /*t$  Mode*/
char mons[5] ="xxxx";              /*m$  Monatsnamen*/
char txn[13] = "Von         ";
char rxn[13] = "Nach        "; /*txn$,rxn$, Name von TX und RX */
float f[2];
float fr[3];
int   ifx[24] [4] [3] [4];
int   iv[4] [3] [3];
int   if9[4][2];
int   mvt[12] [10] [2];
int   m3c[10] [2];
int   m3t[24] [2] [2];
int   itab[12] [24];
float ftab[12]={0,3,4,5,6,7,10,12,15,18,22,26};
int   isun[12]={-212,-127,-22,97,188,233,216,141,31,-84,-184,-233};
float rd[30];
float btr[2];
float f2muf[3] [24];
float fbtrm[3] [24];
float emuf[24];
float elufy[24];
float clong[30];
float clat[30];
int   idec[26] [2]= {
 {10,8},{7,5},{5,5},{5,5},{6,7},{10,13},{13,13},{12,11},{10,9},
{9,9},{8,8},{8,7},{7,6},
{10,9},{8,7},{6,6},{7,8},{10,12},{14,13},{11,10},{9,8},
{8,8},{8,8},{7,7},{6,5},{4,3}};
int   idis[26]={1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
                25,30,35,40,45,50};
float vv[4]={1.0,1.55,2.4,5.0};
float ff[4]={0.0,-24.0,-11.0,90.0};
float em[5];
float fot[3] [24];
float hpf[24];
/***********************************************************/
static void StartDat  ()
/***********************************************************/
{ /* preset reveived data with something that makes sense */

if(TestDaten==1) /* comparison to BAS version */
{
month = 9;
jahr = 87;
ssn = 75;
ch=strcpy(txn,"DK1FW       ");
x1  = 48.2; /* TX LAt */
fy1  = 10.0; /* TX Lon, East is positive!  */
ch=strcpy(rxn,"T20AA       ");
x2 = -8.7;  /* RX Lat */
y2 = 178.6;  /* RX Lon, East is positive!*/
zkw = 1;
sag = 10; /* TX ant gain dBi */
iproz = 50;
ps = 'S';
angm = 10;
pws = 'Y';
ianz = 10;
ftab[0] =  3.0 ;
ftab[1] =  4.0 ;
ftab[2] =  5.0 ;
ftab[3] =  6.0 ;
ftab[4] =  8.0 ;
ftab[5] = 10.0 ;
ftab[6] = 12.0 ;
ftab[7] = 15.0 ;
ftab[8] = 18.0 ;
ftab[9] = 22.0 ;
}
else /* take over data from CLX */
{
month = p_monat;
jahr = p_jahr;
ssn = p_ssn;
ch = strcpy(txn,p_call1);
/*ch=strcpy(txn,"OE1TKW      ");*/
x1  = 48.2; /* TX Lat */
fy1  = 16.0; /* TX Lon, East is positive!  */
ch = strcpy(rxn,p_call2);
/*ch=strcpy(rxn,"T20AA       "); */
x2 = -8.7;  /* RX Lat */
y2 = 178.6;  /* RX Lon, East is positive!*/
x1 = p_x1; 
x2 = p_x2;
fy1 = p_y1;
y2 = p_y2;

zkw = 1;
sag = 10; /* TX ant gain dBi */
iproz = 50;
/*ps = 'S';*/
ps = *p_ps;
angm = 10;
pws = 'Y';
ianz = 10;
ftab[0] =  3.0 ;
ftab[1] =  4.0 ;
ftab[2] =  5.0 ;
ftab[3] =  6.0 ;
ftab[4] =  8.0 ;
ftab[5] = 10.0 ;
ftab[6] = 12.0 ;
ftab[7] = 15.0 ;
ftab[8] = 18.0 ;
ftab[9] = 22.0 ;
}
}

/***********************************************************/
int FIX (float a)
/***********************************************************/
/*ist sgn(a)*int(abs(a))*/
/*im Gegensatz zu INT wird bei negativen a die naechstkleinere ganze
 Zahl uebergeben*/
/*   float a; */
{
int b;
b = (int) a+0.0;
return b;
}

/***********************************************************/
int CINT(float a)
/***********************************************************/
/* Aufrunden*/
/*    float a;  */
{
int b;
if (a == 0.0 ) 
  b = 0;
else
  {
  if (a>0) 
     b= (int) (a +0.5);
     else { b = (int) (a - 0.5); }
}
return b;
}
/***********************************************************/
/*
INT (a)
  uebergibt groesste Ganzzahl, die <= a ist
float a;
{
if (a>=0.0)    return (int(a));
          else return (int(a+1));
}
  */

/***********************************************************/
void sublev ()
/***********************************************************/
/*   UP FUER NIGHT-LUF DECAY 24->23  */
{
  for (it=1; it<4; it++)
  {
    ilf=it+ilb;
    ilg=ilf-1;
    if (ilf==25)
         ilf=ilf-24;
    else
    {
      if (ilf>25)
	 { ilf=ilf-24;
           ilg=ilg-24;
	 }
    };
    if (elufy[ilf-1]>=fluna)
    {
      elu=elufy[ilg-1]*.795;
      if (elufy[ilf-1]<elu)
           elufy[ilf-1]=elu;
      if (elufy[ilf-1]<fluna)
           elufy[ilf-1]=fluna;
    }
  }
}

/***********************************************************/
void readdat ()
/***********************************************************/
{
int i,j,n,m;
char savdebug;
  savdebug = Debug; 
  Debug=0; 
  strcpy(data_filename,getenv("HOME"));
  strcat(data_filename,"/config/");
  strcat(data_filename,ftz_filename);
  if( (point = fopen(data_filename,"rt"))==0)
  {
    printf ("\n\07Datei ftzmuf2.dat nicht vorhanden!!\n");
    exit(1);
  };
  for (m=0; m<4; m++)
    for (n=0; n<2; n++)
      for (j=0; j<4; j++)
        for (i=0; i<24; i++)
        {
         fscanf(point,"%d",&ifx[i][j][n][m]);
         if (Debug) 
	 fprintf(trac,"IFX %9d %2d %2d %2d %2d\n",ifx[i][j][n][m],i,j,n,m);
        };
  for (n=0; n<2; n++)
    for (j=0; j<4; j++)
        {
          fscanf(point,"%d",&if9[j][n]);
	  if (Debug)
          fprintf(trac,"IF9 %9d %2d %2d\n",if9[j][n],j,n);
        };
  for (n=0; n<2; n++)
    for (j=0; j<10; j++)
      for (i=0; i<12; i++)
        {
          fscanf(point,"%d",&mvt[i][j][n]);
	  if (Debug)
          fprintf(trac,"MVT %9d %2d %2d %2d\n",mvt[i][j][n],i,j,n);
        };
  for (n=0; n<2; n++)
    for (j=0; j<2; j++)
      for (i=0; i<24; i++)
        {
          fscanf(point,"%d",&m3t[i][j][n]);
	  if (Debug)
          fprintf(trac,"M3T %9d %2d %2d %2d\n",m3t[i][j][n],i,j,n);
        };
  for (n=0; n<2; n++)
    for (j=0; j<10; j++)
        {
          fscanf(point,"%d",&m3c[j][n]);
          if (Debug)
          fprintf(trac,"M3C %9d %2d %2d\n",m3c[j][n],j,n);
        };
  for (n=0; n<3; n++)
    for (j=0; j<3; j++)
      for (i=0; i<4; i++)
        {
          fscanf(point,"%d",&iv[i][j][n]);
          if (Debug)   
          fprintf(trac,"IV  %9d %2d %2d %2d\n",iv[i][j][n],i,j,n);
        };
  fclose(point);
  Debug = savdebug;
}

/***********************************************************/
void decode ()
/***********************************************************/
{ /* ifx,if9,mvt dekodieren, called in muf  */
  m=0;
  lw=FIX(lf1/256);
  if (lw<0)
  {
    lf1=lf1+32768;
    lw=FIX(lf1/256) ;
    m=1;
  };
  if (lb==2)
    lf1=lf1-lw*256;
  else
  {
    lf1=lw ;
    if (m==1)
      lf1=lf1+128 ; /* Ergebnis */
  }
}

/***********************************************************/
void muf ()
/***********************************************************/
{ /* regel: beim Zufriff auf Arrays -1, falls Laufindex, 
wurde schon richtig der Index bestimmt! - der sollte aber 
sonst nirgends eingehen !! */
  x=clat[ii-1];
  y=clong[ii-1];
  if (Debug)
   fprintf(trac,"\n Std= %3d Lat= %9.3f Long= %9.3f ",it,x,y); 
  gx=x*PI/180;
  q=0.9799*sin(gx)+0.1994*cos(gx)*cos(1.204+y*PI/180);
  if (q>1)
    q=1;
  else
  {
    if (q<-1)
      q=-1;
  };
  gax=atan(q/sqrt(1-q*q))*180/PI;
  ax=fabs(gax);
  sn=ssn*0.01;
  mon=month;
  t=it+y/15;
  if (t>=24)
    t=t-24;
  if (t<0)
    t=t+24;
  lt=CINT(t);
  if (lt==0)
    lt=24;
  if (Debug) fprintf(trac,"\n lt t %3d %9.3f ",lt,t); 
  /* FOF2  */
  lb=1;
  if (gax<0)
  {
    lb=2;
    mon=mon+6;
    if (mon>12)
      mon=mon-12 ;
  };
  mon1=FIX(mon/3);
  mon2=mon1+1;
  if (mon1==0)
    mon1=4;
  if (mon2>4)
    mon2=1;
  m1=FIX(ax/10)+1;
  m2=m1+1;
  if (m2>10)
    m2=10;
  n1=FIX(ax/20)+1;
  if (n1>4)
    n1=4;
  n2=n1+1;
  bx=(n1*20-ax)/20;
  if (ax>60)
    bx=(90-ax)/30;
  di=(mon- (float) (FIX(mon/3))*3)/3;
  dx_f=(ax-m1*10+10)/10;


  for (k=1; k<3; k++)
  {
    lf1=ifx[lt-1][mon2-1][k-1][n1-1];
fprintf (trac,"\n ifx i1, i2,  i3, i4 , wert %9d %9d %9d %9d %9d",lt,mon2,k,n1,lf1);
    decode();
    lf2=lf1;
    if (Debug)
     fprintf (trac,"\nifx von Mon 2 %9d %9d ",lf2,mon2);
    lf1=ifx[lt-1][mon1-1][k-1][n1-1];
    decode();
    if (Debug)
     fprintf(trac,"\nifx von Mon1 %9d %9d ",lf1,mon1);

    ft=(lf2-lf1)*di+lf1;
    if (ax<=60)
    {
      lf1=ifx[lt-1][mon2-1][k-1][n2-1];
      decode();
      if (Debug)
       fprintf(trac,"\n2. ifx von Mon 2 %9d %9d ",lf1,mon2);
      lf2=lf1;
      lf1=ifx[lt-1][mon1-1][k-1][n2-1];
      decode();
      if (Debug)
       fprintf(trac,"\n2. ifx von Mon 1 %9d %9d ",lf1,mon1);
    }
    else
    {
      lf1=if9[mon2-1][k-1];
      decode();
      if (Debug)
       fprintf(trac,"\nif9 von mon 2 %9d %9d",lf1,mon2);
      lf2=lf1;
      lf1=if9[mon1-1][k-1];
      decode();
      if (Debug)
       fprintf(trac,"\nif9 von Mon 1 %9d %9d",lf1,mon1);
    };
    fh=(lf2-lf1)*di+lf1;
    xr=(ft-fh)*bx+fh;
    lf1=mvt[mon-1][m2-1][k-1];
    decode();
    if (Debug)
      fprintf(trac,"\nmvt von mon m2 %9d %9d %9d",lf1,mon,m2);
    lf2=lf1;
    lf1=mvt[mon-1][m1-1][k-1];
    decode();
    if (Debug)
     fprintf(trac,"\nmvt von mon m1 %9d %9d %9d",lf1,mon,m1);
 
    xk=(lf2-lf1)*dx_f+lf1;
    f[k-1]=xr*xk;
  };/*  k for 0..1 */

  f50=((f[1]-f[0])*sn+f[0])*0.001;
  if (Debug)
    fprintf(trac,"\nfoF2 (f50) = %7.2f",f50);
   /* M3000 */
  ax=fabs(x);
  lx=FIX((ax+5)/10)+1;
  dif=(lt- (float) (FIX(lt/6))*6)/6; /* Achtung !! 010199 */
  mon=month;
  if (x<=0)
  {
    mon=mon+6;
    if (mon>12)
      mon=mon-12;
  };
  cm=fabs(mon-6)/6 ;
  for (k=1; k<3; k++)
    fr[k-1]=(m3t[lt-1][1][k-1]-m3t[lt-1][0][k-1])*sn+m3t[lt-1][0][k-1];
  bx=ax ;
  if (bx>40)
    bx=40;
  bx=bx/40;
  xm3x=(fr[1]-fr[0])*bx+fr[0];
  xcmd=(m3c[lx-1][1]-m3c[lx-1][0])*cm+m3c[lx-1][0]+xm3x;
  bm=fabs(lt-12)/12;
  xm3=((xm3x-xcmd)*bm+xcmd)/100;
  if (Debug)
   fprintf(trac,"\nM3000= %8.2f",xm3);
  /* 10/90 PERCENT OF FOF2 */
  jj1=FIX(t/6);
  jj2=jj1+1;
  if (jj1==0)
    jj1=4;
  if (jj2>4)
    jj2=1;
  im=FIX((float)abs(mon-6.5)/2+1);
  bx=ax;
  if (bx>75)
    bx=75;
  if (bx<15)
    bx=15;
  for (k=1; k<4; k++)
  {
    iv1=iv[jj1-1][k-1][im-1];
    fr[k-1]=((iv[jj2-1][k-1][im-1]-iv1)*dif+iv1)*0.01;
    if (Debug) fprintf (trac,"\n iv1 fr dif %8d %8.3f %8.4f" ,iv1,fr[k-1],dif); 
  };
  if (bx<=40)
    fak=(fr[2]-fr[1])*bx/40+fr[2];
  else
    fak=(fr[1]-fr[0])*(bx-40)/35+fr[0];
  if (Debug) fprintf (trac, "\n fak %8.3f",fak);   
  f10=f50*fak;
  if (Debug)
   fprintf(trac,"\nf10 = %8.2f",f10);
  f90=f50/fak*0.96;
  /* MUF FOR 4000 KM */
  gyro=ax/100+0.8;
  if (Debug)
   fprintf(trac,"\ngyro= %8.2f",gyro);
  f4000=f50*xm3*1.1;
  if (Debug)
   fprintf(trac,"\nf4000 = %8.2f",f4000);
}

/***********************************************************/
void kormu ()
/***********************************************************/
{
float f;
  if (gcdkm>4000)
    ufcor=1;
  else
    ufcor=1+1-pow((gcdkm/4000) ,2);
  imit=CINT(12-clong[ii-1]/15);
  if (imit<1)
    imit=imit+24;
  ufmax=f2muf[ii-1][imit-1];
  ufmin=f2muf[ii-1][0];
  for (i=2; i<25; i++)
    if (f2muf[ii-1][i-1]<ufmin)
      ufmin=f2muf[ii-1][i-1];
  ufqu=yy*pow( (ufmin/ufmax) ,2);
  for (i=1; i<25; i++)
  {
    f=f2muf[ii-1][i-1];
    fbtrm[ii-1][i-1]=ufcor*f*(1.2+ww*(f/ufmax)+(pow((ufmax/f),0.3333)-1)*xx+ufqu);
  }
}

/***********************************************************/
void bear ()
/***********************************************************/
{ /* Ergebnis btr[0], btr[1] */
  u=0.5*(PI-zx1-zx2+zgcd);
  u1=u-zpi;
  su=sin(u-zgcd);
  zxx1=zx2;
  zxx2=zx1;
  zyy1=zy2;
  zyy2=zy1;
  for (i=0; i<2; i++)
  {
    df=zyy2-zyy1;
    if (fabs(df)>=PI)
    {
      if (df<0)
        df=df+dpi;
      else
        df=df-dpi;
    };
    sind=sin(u)*sin(u1+zxx1);
    if (sind==0)
      bt=180;
    else
    {
      bt=114.5916*atan(sqrt(fabs(sin(u1+zxx2)*su/sind)));
      if (df>=0)
      {
        if (df>0)
          bt=360-bt;
        else
        {
          if ((zxx1-zxx2)<0)
            bt=180;
        }
      }
    };
    btr[i]=bt;
    zxx1=zx1;
    zxx2=zx2;
    zyy1=zy1;
    zyy2=zy2;
  }
}
/***********************************************************/
void decile ()
/***********************************************************/
{ /* called by fieldstrength */
int ka,kbl,kbh;
  if (iproz!=50)
  {
    if (iproz==10)
    {
      ka=1;
      si=1;
    }
    else
    {
      ka=2;
      si=-1;
    };
    ffg=ftab[j-1]/f2muf[0][it-1];
    if (ffg>5)
      ffg=5;
    else
    {
      if (ffg<0.1)
        ffg=0.1;
    };
    if (ffg>2)
      kbl=FIX((ffg-2)*2+20);
    else
      kbl=FIX(ffg*10);
    if (kbl>25)
      kbl=25;
    kbh=kbl+1;
    disdb=idec[kbh-1][ka-1]-idec[kbl-1][ka-1];
    disfg=(ffg*10-idis[kbl-1])/(idis[kbh-1]-idis[kbl-1]);
    wal=(idec[kbl-1][ka-1]+disdb*disfg)*si;
    feld=feld+wal;
  }
}

/***********************************************************/
void fcor ()
/***********************************************************/
{ /* called by fieldstrength */
  if (gcdkm<=4000)
  {
    v=ftab[j-1]/f2muf[0][it-1];
    if (v>=1)
    {
      if (v>5)
        v=5;
      for (k=1; k<4; k++)
        if ( ! ((v<vv[k-1]) || (v>vv[k]))) break;
      z=((v-vv[k-1])/(vv[k]-vv[k-1]))*(ff[k]-ff[k-1])+ff[k-1];
      z=z*(4000-gcdkm)/4000;
      feld=feld+z;
    }
  }
}

/***********************************************************/
void angle ()
/***********************************************************/
{
  d_f=0.5*xkm/ro;
  w=atan((cos(d_f)-ro/(ro+hp))/sin(d_f))*360.0/dpi;
 iw=CINT(w);

}

/***********************************************************/
void modang ()
/***********************************************************/
/*Mode und Winkel darstellen*/
{
/*  char chx; */
   ch=strcpy(ts,"     ");
   if (!  Durchlauf1)
   { /* Mode und Elevation table */
 if (Debug) fprintf(trac,"\nFTAB,j,i,emuf: %10.5f %2d %2d %10.5f",ftab[j-1],
   j,i,emuf[i-1]);
    if (ftab[j-1]<=emuf[i-1])
    {
      hp=110;
      xkm=hopkme;
      aas='E'; ts[2]='E';
      ia=ihope;
    }
    else
    { 
      hp=1490/hpf[i-1]-176;
      xkm=hopkmf;
      aas='F'; ts[2]='F';
      ia=ihopf; /* Anzahl Hops */ 
    };
    angle(); /* liefert iw */ 
    if (iw<0)
      iw=0;
/* if (Debug)
    fprintf(trac,"\n ia, iw : %3d %3d",ia,iw); */ 
/*   chx=itoa(ia / 10,ts[0],10);
   chx=itoa(ia % 10,ts[1],10);
   chx=itoa(((iw) / 10),ts[3],10);
   chx=itoa(((iw) % 10),ts[4],10); */
  ts[0]=(ia /10 )+48; if (ts[0]=='0') ts[0]=' ';
  ts[1]=(ia % 10) +48;  
  ts[3]=((iw) /10)+48;
  ts[4]=((iw) %10)+48;
  ts[5]=0;


 /*ts=STR$(ia)+aas+RIGHT$(STR$(iw+100),2); */
    zz=1.04*pow( f2muf[0][i-1],2)/fot[0][i-1];
    if ((ftab[j-1]>zz) || (itab[j-1][i-1]<-40))
    {
      ts[0]=' ';
      ts[1]=' ';
      ts[2]='.';
      ts[3]='.';
      ts[4]='.';
      ts[5]=0;
    }
  }
  else /* field strength */
  {
   if (Debug) fprintf(trac,"\nITAB j i %10d %3d %3d",itab[j-1][i-1],j-1,i-1); 
   ts[0]=' ';
   ts[1]=' ';
   /* Vorzeichen  */
   if (itab[j-1][i-1]<0) {    ts[2]='-';} else { ts[2]=' ';} ;
/*   Zehner */ 
    if (itab[j-1][i-1]>=10 || itab[j-1][i-1]<=-10)
    { ts[3] = (abs(itab[j-1][i-1] / 10))+48; }  else ts[3]=' ';
/*    { chx = itoa(abs(itab[j-1][i-1]/10),ts[3],10); } else  { ts[3]=' '; }; */
/*   Einer  */
   ts[4]=(abs(itab[j-1][i-1] % 10))+48; 
/*     ts=RIGHT$('     '+STR$(itab(j-1][i-1)),5); */
    if (itab[j-1][i-1]<-40)
    {
      ts[0]=' ';
      ts[1]=' ';
      ts[2]='.';
      ts[3]='.';
      ts[4]='.';
    }
  ts[5]=0;
  }
}

/************************************************************/
void printheader ()
/************************************************************/
{
printf("\nCIRCUIT : %12s",txn);
printf("  - %12s",rxn);
printf("                  MONTH  : ");
switch (month)
{
case 1 : ch=strcpy(mons,"JAN.");
         break;
case 2 : ch=strcpy(mons,"FEB.");
         break;
case 3 : ch=strcpy(mons,"MAR.");
         break;
case 4 : ch=strcpy(mons,"APR.");
         break;
case 5 : ch=strcpy(mons,"MAY ");
         break;
case 6 : ch=strcpy(mons,"JUNE");
         break;
case 7 : ch=strcpy(mons,"JULY");
         break;
case 8 : ch=strcpy(mons,"AUG.");
         break;
case 9 : ch=strcpy(mons,"SEP.");
         break;
case 10: ch=strcpy(mons,"OCT.");
         break;
case 11: ch=strcpy(mons,"NOV.");
         break;
case 12: ch=strcpy(mons,"DEC.");
         break;
default: ch=strcpy(mons,"xxxx");
         break;
}
printf("   %s %2d  \n",ch,jahr);

printf("LOCATION: %4.1f",fabs(x1));
aas='N';
if (x1<0)
  aas='S';
printf("%c",aas);
printf(" %5.1f",fabs(fy1));
aas='E';
if (fy1<0)
  aas='W';
printf("%c    ",aas);
printf("%4.1f",fabs(x2));
aas='N';
if (x2<0)
  aas='S';
printf("%c",aas);
printf(" %5.1f",fabs(y2));
aas='E';
if (y2<0)
  aas='W';
printf("%c",aas);
printf("                  SSN    :        %3.0f\n",ssn);

printf("AZIMUTH : %5.1f DEG.      %5.1f DEG.",btr1,btr2);
printf("                    POWER  : %7.3f KW\n",zkw);

printf("DISTANCE: %5.0f KM",gcdkm);
printf("                                      TX-GAIN:   %5.1f DB\n",sag);
printf("MIN-ANG.:  %4.1f DEG.\n\n",angm);
}
/***********************************************************/
char CheckParams (int argc, char * argv) 
/* Pruefen der uebergeben Parameter */
{

if (argc != 8)
{ return  0; } /* not ok */
else return 1 ;
}
/***********************************************************/
void ftz_kern( int p_ssn, int p_jahr, int p_monat, float p_x1,
 float p_y1, float p_x2, float p_y2, char *p_ps,
 char *p_call1, char *p_call2)

/***********************************************************/
{

StartDat();

Debug=1;
if (Debug)
 { if ( (trac = fopen (trace_filename,"w"))==0)
   { printf ("\nTracefile open failed "); } ;
 } ;
zpi=PI/2;
dpi=PI*2;
if (Debug)
  fprintf (trac,"dpi= %10.7f",dpi);
ak=PI/180;
bk=180/PI;
if (Debug)
  fprintf(trac,"\nDATA LOADING...");

readdat(); /* FTZ-Datenfile einlesen */ 

if (Debug)
  fprintf(trac,"\nCALCULATING...");


/* GREAT CIRCLE DISTANCE */

ssp=isun[month-1]*0.1*ak;
xx1=x1*ak;
xx2=x2*ak;
yy1=fy1*ak;
yy2=y2*ak;
gcd=sin(xx1)*sin(xx2)+cos(xx1)*cos(xx2)*cos(yy2-yy1);
gcd=zpi-atan(gcd/sqrt(1-gcd*gcd));
if (gcd<0)
  gcd=PI+gcd;
gcdk=gcd;
if (ps=='L')
  gcd=2*PI-gcd;
gcdkm=gcd*ro;
if (Debug)
  {
  fprintf(trac,"\nx1  ... %7.1f",x1   );
  fprintf(trac,"\nx2  ... %7.1f",x2   );
  fprintf(trac,"\ny1  ... %7.1f",fy1   );
  fprintf(trac,"\ny2  ... %7.1f",y2   );
  fprintf(trac,"\nisun  ... %d",isun[month-1]);
  fprintf(trac,"\nGrosskreisdistanz GCDKM ... %7.1f",gcdkm);
  };
ihope=FIX(gcdkm/2000)+1;
ihopf=FIX(gcdkm/4000)+1;
if (Debug)
 { fprintf(trac,"\nAnzahl Spruenge E ihope %d",ihope);};
if (Debug)
 { fprintf (trac,"\nAnzahl Spruenge F ihopf %d",ihopf);};
xkm=gcdkm/ihope;
hp=110;
angle(); /* liefert w */
xkm=gcdkm/ihope;
while (w<angm) 
{
  ihope=ihope+1; 
  hp=110;
  xkm=gcdkm/ihope;
  angle();
} ;
xkm=gcdkm/ihopf;
hp=300;
angle();
xkm=gcdkm/ihopf;
while (w<angm) 
{
  hp=300;
  ihopf=ihopf+1;
  xkm=gcdkm/ihopf;
  angle();
} ;

if (Debug)
  { fprintf(trac,"\n Anzahl Spruenge E ihope= %d",ihope);};
if (Debug)
  { fprintf(trac,"\n Anzahl Spruenge F ihopf= %d",ihopf);};

hopkme=gcdkm/ihope;
hopkmf=gcdkm/ihopf;
if (Debug)
   { fprintf(trac,"\nkm pro Sprung E hopkme= %7.1f",hopkme); }
if (Debug)
   { fprintf (trac,"\nkm pro Sprung F hopkmf= %7.1f",hopkmf);}

rd[0]=gcd/2;
rd[1]=0.5*hopkmf/ro;
rd[2]=gcd-0.5*hopkmf/ro;
rd[3]=0.5*hopkme/ro;
rd[4]=gcd-0.5*hopkme/ro;

if (Debug)
  fprintf(trac,"\n\nluf const  ...");


/* LUF - CONSTANTS */


hop=FIX(gcdkm/3000)+1;
ihop=hop;
n=2*hop;
if (Debug)
   fprintf(trac,"\n Anzahl Spruenge LUF = %3d",ihop);
if (ihop!=1)
{
  k5=6;
  k6=n+5;
}
else
{
  k5=2;
  k6=n+1;
};

if(Debug)
 fprintf(trac,"\nk5,k6= %4d %4d",k5,k6);
archop=gcd/hop;
hopkm=gcdkm/hop;
ar2=archop/2;
phif=atan(ro*sin(ar2)/(ro+300-ro*cos(ar2)));
dp2n=ro*sin(ar2)/sin(phif);
gcdko=dp2n*hop*2;
delta=PI-phif-ar2;
phid=ro*sin(delta)/(ro+90);
phid=atan(phid/sqrt(1-phid*phid));
b=5.3/sqrt(cos(phid)*log(9500000/gcdko)); /* log nat !! */
dp=PI-delta-phid;
dn2=2*dp;
dn4=archop-dn2;
rd[k5-1]=dp;
for (i=k5; i<k6; i=i+2)
{
  rd[i]=rd[i-1]+dn4;
  rd[i+1]=rd[i]+dn2;
};

dfk=sqrt(1+0.008999999*ssn);
fluna=sqrt(gcdkm/3000);

if (Debug)
 {
   fprintf (trac,"\nr1 = %10.5f",rd[0]);
   fprintf (trac,"\nr2 = %10.5f",rd[1]);
   fprintf (trac,"\nr3 = %10.5f",rd[2]);
   fprintf (trac,"\nr4 = %10.5f",rd[3]);
   fprintf (trac,"\nr5 = %10.5f",rd[4]);
   fprintf (trac,"\nk5 = %3d",k5);
   fprintf (trac,"\nk6 = %3d",k6);
   fprintf (trac,"\n LUF nachts = %10.6f",fluna); 
  } ; 
abklp=fluna*2;

if (Debug)
  fprintf(trac,"\n\nazimut     ...");
/* AZIMUT */
zx1=xx1;
zx2=xx2;
zy1=yy1;
zy2=yy2;
zgcd=gcdk;
bear();
if (ps!='L')
{
  btr1=btr[0];
  btr2=btr[1];
}
else
{
  if (btr[0]<180)
    btr1=180+btr[0];
  else
    btr1=btr[0]-180;
  if (btr[1]<180)
    btr2=180+btr[1];
  else
    btr2=btr[1]-180;
};
if (Debug)
  {
  fprintf(trac,"\nbtr1=%7.2f",btr1);
  fprintf(trac,"\nbtr2=%7.2f",btr2);
  };

/* ELFC AND FLFC */
arc=hopkme*dk;
/* ELFC=((((((-4.368E-09*ARC+1.335E-07)*ARC-5.977E-06)*ARC+.0002625)*
  ARC)-.005039)*ARC+.03761)*ARC-.01332)*ARC+.2085 */
elfc=((-4.368E-09*arc+1.335E-07)*arc-5.977E-06)*arc+0.0002625;
elfc=(((elfc*arc-0.005039)*arc+0.03761)*arc-0.01332)*arc+0.2085;
arc=hopkmf*dk;
/* FLFC=((((((-6.713E-09*ARC+4.492E-07)*ARC-9.986E-06)*ARC+6.865E-05)*
  ARC)+9.201999E-05)*ARC+.002265)*ARC+.004699)*ARC */
flfc=((-6.713E-09*arc+4.492E-07)*arc-9.986E-06)*arc+0.00006865;
flfc=(((flfc*arc+0.00009201999)*arc+0.002265)*arc+0.004699)*arc;
if (Debug)
 { fprintf(trac,"\nelfc,flfc= %10.5f %10.5f",elfc,flfc); } ;

/* COORDINATES AND PENETRATION POINTS */
if (ihopf==1)
{
  k1=1;
  k2=1;
  k3=1;
  k4=1;
}
else
{
  k1=2;
  k2=3;
  k3=4;
  k4=5;
};

for (ii=1; ii<(k6+1); ii++)
{
  if (Debug)
    fprintf(trac,"\nk6 = %3d",k6);
  pp=rd[ii-1];
  cenlat=cos(pp)*cos(zpi-xx2)+sin(pp)*sin(zpi-xx2)*cos(btr2*ak);
  cenlat=(zpi-atan(cenlat/sqrt(1-cenlat*cenlat)))*bk;
  if (cenlat<0)
    cenlat=-90-cenlat;
  else
    cenlat=90-cenlat;
  cenlg=cos(pp)-cos(zpi-cenlat*ak)*cos(zpi-xx2);
  cenlg=cenlg/sin(zpi-cenlat*ak)/sin(zpi-xx2);
  if (cenlg>1)
    cenlg=1;
  else
  {
    if (cenlg<-1)
      cenlg=-1;
  };
  cenlg=(zpi-atan(cenlg/sqrt(1-cenlg*cenlg)))*bk;
  if ((btr2>180) && (pp<PI))
    cenlg=-cenlg;
  if ((btr2<180) && (pp>PI))
    cenlg=-cenlg;
  cenlg=yy2*bk+cenlg;
  if (cenlg>180)
    cenlg=cenlg-360;
  if (cenlg<-180)
    cenlg=cenlg+360;
  clat[ii-1]=cenlat;
  clong[ii-1]=cenlg;
  if (Debug) 
   fprintf (trac,"\nclong = %10.5f clat = %10.5f",clong[ii-1],clat[ii-1]);
}

/* W,X,Y */
wow=0.1;
wns=0.2;
xow=1.2;
xns=0.2;
yow=0.6;
yns=0.4;
zx1=xx1;
zy1=yy1;
zx2=clat[0]*ak;
zy2=clong[0]*ak;
zgcd=gcdk/2;
bear();
btt=btr[1];
if (btt>180)
  btt=btt-180;
if (btt<90)
  btt=90-btt;
else
  btt=btt-90;
zb=btt/90;
zl=1-zb;
ww=wow*zl+wns*zb;
xx=xow*zl+xns*zb;
yy=yow*zl+yns*zb;

/* F2-MUF */
if (Debug)
  fprintf(trac,"\n\nf2 muf loop    ...");

gyr=0;
for (it=1; it<25; it++)
{
  hpf[it-1]=0;
  for (ii=1; ii<(k2+1); ii++)
  {
    muf();
    if (it==1)
      gyr=gyr+gyro;
    gamma3=f50+0.5*gyro;
    f2muf[ii-1][it-1]=gamma3+flfc*(f4000-gamma3);
    if (Debug) {
    fprintf(trac,"\ng3,f4000,flfc %9.4f %9.4f %9.4f",gamma3,f4000,flfc);
    fprintf(trac,"\nf2muf i-1 t-1 %9.4f %3d %3d",f2muf[ii-1][it-1],ii-1,it-1);
     }
    gamma3=f90+0.5*gyro;
    fot[ii-1][it-1]=gamma3+flfc*(f90*xm3*1.1-gamma3);
    hpf[it-1]=hpf[it-1]+xm3;
    if (Debug) 
    fprintf(trac,"\nfot %9.4f %3d %3d ",fot[ii-1][it-1],ii-1,it-1);
  };
  hpf[it-1]=hpf[it-1]/k2;
  /*if (Debug) fprintf(trac,"\nhpf %9.4f",hpf[it-1]);*/
}
gyr=gyr/k2;
for (ii=1; ii<(k2+1); ii++)
    kormu();

/* E-MUF */
if (Debug)
  fprintf(trac,"\n\n e muf     ...");

for (it=1; it<25; it++)
{
  emuf[it-1]=0;
  if (gcdkm<=4000)
  {
    gmt=it;
    zt=(15*gmt-180)*ak;
    for (ii=k3; ii<(k4+1) ; ii++)
    {
      cenlg=clong[ii-1]*ak;
      cenlat=clat[ii-1]*ak;
      z=zt+cenlg;
      cycen=sin(cenlat)*sin(ssp)+cos(cenlat)*cos(ssp)*cos(z);
      if (cycen<0)
         cycen=0;
      cycen=zpi-cycen;
      xke=2.25+1.5*cos(cenlat)+(0.01-0.007*cos(cenlat))*ssn;
      xn=0.21+0.12*cos(cenlat)+0.0002*ssn;
      if (Debug)
        fprintf(trac,"\n xke = %9.7f xn = %9.7f",xke,xn);
      fe=xke*pow( (cos(cycen)), xn);
      em[ii-1]=fe*elfc*5;
    };
    emuf[it-1]=em[k3-1];
    if (emuf[it-1]>em[k4-1])
       emuf[it-1]=em[k4-1];
    if (Debug)
     fprintf (trac,"\nemuf = %9.7f",emuf[it-1]);
  }
}

/* LUF */
if (Debug)
  fprintf(trac,"\n\n luf       ...");

for (it=1; it<25; it++)
{
  gmt=it;
  zt=(15*gmt-180)*ak;
  elufy[it-1]=0;
  for (ii=k5; ii<(k6+1); ii++)
  {
    cenlg=clong[ii-1]*ak;
    cenlat=clat[ii-1]*ak;
    z=zt+cenlg;
  if (Debug)
     {
     fprintf (trac,"\n Stunde=%5d %5d lg=%9.4f ln=%9.4f",it,ii,cenlg,cenlat);
     };                                  
    cycen=sin(cenlat)*sin(ssp)+cos(cenlat)*cos(ssp)*cos(z);
    if (cycen<0)
       cycen=0;
    cycen=sqrt(cycen);
  if (Debug) fprintf(trac,"cycen= %9.4f",cycen);
    elufy[it-1]=elufy[it-1]+cycen;
  } ;
  if (Debug) 
fprintf(trac,"\n dfk,b,gyr,fluna: %9.4f %9.4f %9.4f %9.4f",dfk,b,gyr,fluna);
  elufy[it-1]=sqrt(elufy[it-1])*dfk*b-gyr;
  if (elufy[it-1]<fluna)
     elufy[it-1]=fluna;
  if (Debug)
    fprintf(trac,"\n vor decay: elufy: %10.5f",elufy[it-1]);
}

/* DECAY TO NIGHT-LUF */
if (Debug)
  fprintf(trac,"\n\ndecay      ...");

for (it=1; it<25; it++)
{
  if (Debug)
    fprintf(trac,"\n Std = %3d",it);
  ilf=it-1;
  if (ilf<1)
     ilf=ilf+24;
  if (elufy[ilf-1]>=elufy[it-1])
  {
    if (elufy[it-1]<=abklp)
    {
      if (elufy[it-1]==abklp)
      {
        ilb=it;
        sublev();
	goto l88;
        /*   EXIT if TRUE*/
      };
      if (elufy[ilf-1]>=abklp)
      {
        if (elufy[ilf-1]==abklp)
        {
          ilb=ilf;
          sublev();
          goto l88;
          /* EXIT if TRUE */
        };
        ilb=it;
        elz=0.795*elufy[ilf-1];/*3210*/
        elufy[ilb-1]=elz*(((abklp-elufy[ilb-1])/(elufy[ilf-1]-elufy[ilb-1]))
        *(1-0.795)+0.795);
        if (elufy[ilb-1]<fluna)
        {
          elufy[ilb-1]=fluna;
        }
        sublev();/*3230   STRUKTUR....*/
        goto l88;  
        /* EXIT if TRUE */
      }
    }
  }
}
l88: { 
  if (Debug) fprintf (trac,"\n jumpto 88 ");}; 

for (it=0; it<24; it++) 
if (Debug)
    fprintf (trac,"\n elufy nach decay= %10.5f Std=%3d",elufy[it],it+1);
    /* MUF */
if (Debug)
fprintf(trac,"\n\n muf decision ...");

for (it=1; it<25; it++)
{
  if (f2muf[k1-1][it-1]<f2muf[ 0][it-1])
      f2muf[ 0][it-1]=f2muf[k1-1][it-1];
  if (f2muf[k2-1][it-1]<f2muf[ 0][it-1])
      f2muf[ 0][it-1]=f2muf[k2-1][it-1];
  if (f2muf[ 0][it-1]<emuf[it-1])
      f2muf[ 0][it-1]=emuf[it-1];

  if (fbtrm[k1-1][it-1]<fbtrm[ 0][it-1])
      fbtrm[ 0][it-1]=fbtrm[k1-1][it-1];
  if (fbtrm[k2-1][it-1]<fbtrm[ 0][it-1])
      fbtrm[ 0][it-1]=fbtrm[k2-1][it-1];
  if (fbtrm[ 0][it-1]<emuf[it-1])
      fbtrm[ 0][it-1]=emuf[it-1];

  if (fot[k1-1][it-1]<fot[ 0][it-1])
      fot[ 0][it-1]=fot[k1-1][it-1];
  if (fot[k2-1][it-1]<fot[ 0][it-1])
      fot[ 0][it-1]=fot[k2-1][it-1];
  if (fot[ 0][it-1]<emuf[it-1])
      fot[ 0][it-1]=emuf[it-1];
}

/* FIELD STRENGTH */

a=gcdkm*PI/20000;
c=a;
if (gcdkm>20000)
  c=2*PI-a;
if (gcdkm>30000)
  c=a-PI;
/* focus ist der Antipoden-Fokusgewinn */
/* log10 ist richtig! focus=10*log10(c/sin(c))/xlg; */
focus=10*log(c/sin(c))/xlg;
if (focus>15)
  focus=15;
if(Debug) fprintf(trac,"\nfocus= %10.5f",focus);
/* d0 ist F 0 der Freiraum-Feldstaerkepegel */
/* log10 ist richtig!! d0=139.6-20*log10(gcdko)/xlg;*/
d0=139.6-20*log(gcdko)/xlg;
if (Debug) fprintf(trac,"\nd0= %10.5f",d0);
for (it=1; it<25; it++)
{
  xm=fbtrm[0][it-1];
  fm2=pow((xm+gyr) ,2);
  fl2=pow((elufy[it-1]+gyr) ,2);
  if (xm<elufy[it-1])
    clm=fl2/(fm2+fl2);
  else
    clm=fm2/(fm2+fl2);
  ftab[0]=f2muf[0][it-1];
  for (j=1; j<(ianz+1); j++)
  {
    f9=pow( (ftab[j-1]+gyr) ,2);
    flf=fl2/f9;
    ffm=f9/fm2;
    /* BECKMANN - FORMEL */
    feld=(d0*(1-clm*(flf+ffm)))-30+sag+focus+10*log10(zkw)/xlg;
    if (feld<-999)
      feld=-999;
    fcor();
    decile();
    itab[j-1][it-1]=CINT(feld);
    if (Debug) fprintf(trac,"ITAB j it %3d %3d %3d",itab[j-1][it-1],j-1,it-1); 
  }
}

/* OUTPUT of Results */

Durchlauf1=1;
printf("\nHF-FIELD STRENGTH ESTIMATED BY MINIFTZ4\n");
printheader();
printf("      FIELD STRENGTH IN DB ABOVE 1 UV/M FOR %2d",iproz);
printf(" PERCENT OF TIME\n");
printf("\n");
printf("UTC MUF  DBU  FOT  ");
for (j=2; j<(ianz+1); j++)
  printf("%4.1f ",ftab[j-1]);
printf("\n\n");
for (i=1; i<25; i++)
{
  /* Std, MUF */ 
  printf("%2d %4.1f",i,f2muf[0][i-1]);
  ftab[0]=f2muf[0][i-1];
  /* DBU */
  j=1;
  modang();
  printf("%4s",ts);
  /* FOT */
  printf(" %4.1f ",fot[0][i-1]);
  /* Frequenzen */
  for (j=2; j<(ianz+1); j++)
  {
    modang();
    printf("%4s",ts);
  };
  printf("\n");
};
printf("\n");
Durchlauf1=0;
printf("\n\nMODES AND ELEVATION ANGLES ESTIMATED BY MINIFTZ4\n");
printheader();
printf("\nMODES AND ELEVATION ANGLES\n");
printf("UTC MUF MODE  FOT  ");
for (j=2; j<(ianz+1); j++)
  printf("%4.1f ",ftab[j-1]);
printf("\n\n");
for (i=1; i<25; i++)
{
  /* Std, MUF */
  printf("%2d %4.1f",i,f2muf[0][i-1]);
  ftab[0]=f2muf[0][i-1];
  /* MOD */
  j=1;
  modang();
  printf("%4s",ts);
  /* FOT */
  printf(" %4.1f ",fot[0][i-1]);
  /* Frequenzen */ 
  for (j=2; j<(ianz+1); j++)
  {
    modang();
    printf("%4s",ts);
  };
  printf("\n");
};
if (Debug)
 { fclose(trac);} ;
/* exit(0);weil called by ftz.c */
}
