#define OUTPUT
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include <time.h>

#include "ftz.h"

char *get_date()
{
   static char d[20];
   char lit_day[4],lit_month[4],lit_year[5],rest[16];
   struct tm now;
   time_t t;

   time(&t);
   now = *gmtime(&t);

   sscanf(asctime(&now),"%s %s %s %s %s",
      lit_day,lit_month,rest,rest,lit_year);
	sprintf(d,"%2d %3s %4s",now.tm_mday,lit_month,lit_year);
	return d;
}

void write_syslog(char *text)
{
	openlog("ftz.c",0,LOG_LOCAL0);
	syslog(LOG_WARNING,text);
	closelog();
}

void write_syslog_noopen(char *filename)
{
   char msg[80];
   
   sprintf(msg,"Cannot open %s.\n",filename);
   write_syslog(msg);
}
void print_dashes(int i)
{
	i--;
	while (i--) {
		putchar('-');
	}
	putchar('\n');
}

void print_not_in_database(char *us_cl)
{
   printf("\\%04d\t%s\n",NOINDB,us_cl);
}

void print_data_not_available(char *us_cl)
{
   printf("\\%04d\t%s\n",NOAVAIL,us_cl);
}

void print_enter_location(char *us_cl)
{
   print_data_not_available(us_cl);
   printf("\\%04d\n",ENTER_LOC);
}

void print_usage(char *s)
{
   printf("\\%04d\n",USAGE);
}

/* Gibt Kopfzeilen bei SH/FTZ aus */
void print_header(int mode,char *call)
{
   switch(mode)
   {
      case F_FTZ:
         printf("\\%04d\t%s\n",FTZ_HEAD,get_date());

         print_dashes(70);

     /*    printf("\\%04d\n",SUN_LOC); */

         print_dashes(70);
         break;
      case F_FTZ6:
         printf("\\%04d\t%s\n",FTZ6_HEAD,call);

         print_dashes(78);

     /*    printf("\\%04d\n",HEAD_LOC); */
         print_dashes(78);
         break;
   }         
}

/* Gibt Fusszeile bei SH/FTZ aus */

/* ------------------------------------- */
/* 1 locations found                     */
void print_foot(int count,int mode)
{
   switch(mode)
   {
      case F_FTZ:
         print_dashes(70);
                  break;
      case F_FTZ6:
         print_dashes(78);
         break;
   }         
   printf("\n FTZMUF2 clx version by OE1TKW. \n");
}


