/************************/
/* Defines  		*/
/************************/

#define F_NIL		0       /* Dummy-Funktion   */
#define PI M_PI
#define MAXLOCATION 1000
#define DEFAULT_FTZ_DATA "B=1.8/G=-10.0/A=8/P=100 B=3.5/G=-6.2/A=9/P=100 B=7/G=-3.6/A=10/P=100 \
B=10.1/G=-3.7/A=10/P=100 B=14/G=-3.0/A=10/P=100 B=18/G=-3.0/A=10/P=100 \
B=21/G=-3.0/A=10/P=100 B=24.9/G=-3.0/A=10/P=100 B=28/G=-3.0/A=10/P=100\0"
#define PP 10


typedef struct  /* enthlt Stationsprofil */
{
	float mhz[PP];
	float gain[PP];
	float minang[PP];
	float power[PP];
} Station_Profile;

/********************************************/
/* Globale Variablen                        */
/********************************************/

#ifndef MAIN
extern int program_function;	/* legt die Funktion des Programms fest */
extern int     d;      /* Tag im Jahr */
extern Date    date;   /* Datum       */
extern Location target_location;
extern Location user_location;
extern int p_ssn;
extern int p_jahr;
extern int p_monat;
extern float p_x1;
extern float p_x2;
extern float p_y1;
extern float p_y2;
extern char *p_ps;
extern char *p_call1;
extern char *p_call2;
extern struct tm now;
extern time_t tim;
#endif


/********************************************/
/* Globale Funktionen                       */
/********************************************/

Location pg_lookup_us_data(char *user_call);
int pg_lookup_ssn();
Station_Profile pg_lookup_stn_profile();
void ftz_kern(int p_ssn,int p_jahr,int p_monat, float p_x1,
     float p_y1, float p_x2, float p_y2, char *p_ps, char *p_call1, 
     char *p_call2);
/* float angm(float f); geht noch nicht, da in ftz_kern.c noch nicht umgestellt */
float zkw(float f);
float sag(float f);
