#define OUTPUT
#include <syslog.h>

#include "sun.h"

char *get_date()
{
   static char d[20];
   char lit_day[4],lit_month[4],lit_year[5],rest[16];
   struct tm now;
   time_t t;

   time(&t);
   now = *gmtime(&t);


   sscanf(asctime(&now),"%s %s %s %s %s",
      lit_day,lit_month,rest,rest,lit_year);
   sprintf(d,"%2d %3s %4s",now.tm_mday,lit_month,lit_year);
   return d;
}

char *get_date_and_time()
{
   static char d[20];
   char lit_day[4],lit_month[4],lit_year[5],rest[16];
   struct tm now;
   time_t t;

   time(&t);
   now = *gmtime(&t);


   sscanf(asctime(&now),"%s %s %s %s %s",
      lit_day,lit_month,rest,rest,lit_year);
   sprintf(d,"%2d %3s %4s, %02d:%02dz",now.tm_mday,lit_month,lit_year,now.tm_hour,now.tm_min);
   return d;
}

void write_syslog(char *text)
{
	openlog("sun.c",0,LOG_LOCAL0);
	syslog(LOG_WARNING,text);
	closelog();
}

void write_syslog_noopen(char *filename)
{
   char msg[80];
   
   sprintf(msg,"Cannot open %s.\n",filename);
   write_syslog(msg);
}

void print_dashes(int i)
{
	i--;
	while (i--) {
		putchar('-');
	}
	putchar('\n');
}

void print_not_in_database(char *us_cl)
{
   printf("\\%04d\t%s\n",NOINDB,us_cl);
}

void print_data_not_available(char *us_cl)
{
   printf("\\%04d\t%s\n",NOAVAIL,us_cl);
}

void print_enter_location(char *us_cl)
{
   print_data_not_available(us_cl);
   printf("\\%04d\n",ENTER_LOC);
}

void print_usage(char *s)
{
   printf("\\%04d\t%s\n",USAGE,s);
}

void print_sh_trigpoint_usage(char *s)
{
   printf("\\%04d\t%s\n",USAGE_TRIG,s);
}

void print_sh_ftzmuf_usage(char *s)
{
   printf("\\%04d\t%s\n",USAGE_FTZ,s);
}

void print_trigpoint_err()
{
   printf("\\%04d\n",ERR_TRIG);
}

void print_sunrise_sunset(char *us_cl,char *location,char *sr,char *ss)
{
   printf("\\%04d\t%s\t%s\t%s\t%s\n",OUT_SUN,us_cl,location,sr,ss);
}

void print_moonrise_moonset(char *us_cl,char *location,char *sr,char *ss, char *az, char *el)
{
   printf("\\%04d\t%s\t%s\t%s\t%s\t%s\t%s\n",
	OUT_MOON,us_cl,location,sr,ss,az,el);
}


void print_grayline(char *us_cl,char *location,char *dwn,char *sr,char *ss,char *dsk)
{
   printf("\\%04d\t%s\t%s\t%s\t%s\t%s\t%s\n",OUT_GRAY,us_cl,location,dwn,sr,ss,dsk);
   /* printf("These times are not correct - we are working on the problem\n"); */
}

void print_coordinates(Location l, char *locator)
{
   int lat_deg,lat_min,lon_deg,lon_min;
   char ns,ew;
   char string[16];

/*   printf("LON: %f6.2, LAT: %f6.2\n",l.loc.lon,l.loc.lat); */

   if ( l.loc.lon < 0 ) { ew = 'W'; } else { ew = 'E'; }
   if ( l.loc.lat < 0 ) { ns = 'S'; } else { ns = 'N'; }
   lat_deg = abs((int) l.loc.lat);
   lon_deg = abs((int) l.loc.lon);
   lon_min = abs(rint((l.loc.lon - (int) l.loc.lon)*60.0));
   lat_min = abs(rint((l.loc.lat - (int) l.loc.lat)*60.0));

   sprintf(string,"%2d %02d %c %3d %02d %c",
	lat_deg,lat_min,ns,lon_deg,lon_min,ew);
   /* printf("STRING: >>%s<<\n",string); */

   printf("\\%04d\t%s\t%s\t%s\t%s\n",OUT_COORD,l.pref,l.name,string,locator);
}

void print_trigpoint(char *locator,int qtf,int km)
{
   printf("\\%04d\t%s\t%d\t%d\n",OUT_TRIG,locator,qtf,km);
}


void print_heading(char *us_cl,char *location,int qtf1,int km,int miles,int qtf)
{
   printf("\\%04d\t%s\t%s\t%d\t%d\t%d\t%d\n",
	OUT_HEADING,us_cl,location,qtf1,km,miles,qtf);
   if (km>8000)
   {
      qtf1=qtf1-180;
      if (qtf1<0)	qtf1+=360;
      qtf=qtf-180;
      if (qtf<0)	qtf+=360;
      km=2*3.141592*6371.299-km+0.5;
      miles=km/1.609;  	   
      printf("\\%04d\t%s\t%d\t%d\t%d\t%d\n",
	OUT_HEAD_LP,us_cl,qtf1,km,miles,qtf);
      
   }
}


/* Gibt Kopfzeilen bei SH/SUN ..SH/HEAD aus */
													 
/* Sunrise/Sunset Times for 1. Dec 1998  */
/* ------------------------------------- */
/* Location             Sunrise Sunset   */
/* ------------------------------------- */
void print_header(int mode,char *s)
{
   switch(mode)
   {
      case SUN:
         printf("\\%04d\t%s\n",SUN_HEAD,get_date());

         print_dashes(70);

         printf("\\%04d\n",SUN_LOC);

         print_dashes(70);
         break;

      case GRAYLINE:
         printf("\\%04d\t%s\n",GRAY_HEAD,get_date());

         print_dashes(78);

         printf("\\%04d\n",GRAY_LOC);

         print_dashes(78);
         break;

      case HEADING:
         printf("\\%04d\t%s\n",HEAD_HEAD,s);

         print_dashes(78);

         printf("\\%04d\n",HEAD_LOC);
         print_dashes(78);
         break;

      case COORDINATES:
         print_dashes(78);

         printf("\\%04d\n",COORD_HEAD);
         print_dashes(78);
         break;

      case TRIGPOINT:
         print_dashes(78);

         printf("\\%04d\t%s\n",TRIG_HEAD,s);
         print_dashes(78);
         break;

      case MOON:
         printf("\\%04d\t%s\t%5.1f\n",MOON_HEAD,get_date_and_time(),moon_phase());

         print_dashes(78);

         printf("\\%04d\n",MOON_LOC);

         print_dashes(78);
         break;

      case F_FTZ:
         printf("\\%04d\t%s\n",FTZ_HEAD,get_date_and_time());
         break;

      case F_FTZ6:
         printf("\\%04d\t%s\n",FTZ6_HEAD,get_date());
         break;

   }         
}

/* Gibt Fusszeile bei SH/SUN aus */

/* ------------------------------------- */
/* 1 locations found                     */
void print_foot(int count,int mode)
{
   switch(mode)
   {
      case SUN:
         print_dashes(70);
         printf("\\%04d\t%d\n",COUNT,count);
         break;

      case TRIGPOINT:
         print_dashes(78);
         break;

      case F_FTZ:
      case F_FTZ6:
         print_dashes(70);
         printf("FTZMUF2 clx version by OE1TKW.\n");
         break;

      default:
         print_dashes(78);
         printf("\\%04d\t%d\n",COUNT,count);
         break;
   }         
}


