/*
 * 6pack.h	Define the 6pack device driver interface and constants.
 *
 * NOTE:	THIS FILE WILL BE MOVED TO THE LINUX INCLUDE DIRECTORY
 *		AS SOON AS POSSIBLE!
 *
 * Version:	@(#)6pack.h	0.2.0	05/14/97
 *
 * Fixes:
 *
 * Author:	Andreas Knsgen <ajk@iehk.rwth-aachen.de>
 *
 *		This file is derived from slip.h, written by
 *		Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */

#ifndef _LINUX_6PACK_H
#define _LINUX_6PACK_H

#include <linux/config.h>

/* is this still needed for 6pack? */
# define SL_MODE_DEFAULT SL_MODE_SLIP

/* The definition of the line discipline should later be moved
   to asm/termios.h */
#ifndef N_6PACK
#define N_6PACK (N_AX25+1)
#endif

#define SIXPACK_VERSION    "Revision: 0.2.0"

/* sixpack priority commands */

#define SEOF 0x40         /* start and end of a 6pack frame */
#define TX_URUN 0x48      /* transmit overrun */
#define RX_ORUN 0x50      /* receive overrun */
#define RX_BUF_OVL 0x58   /* receive buffer overflow */

#define SIXPACK_CHK 0xFF  /* valid checksum of a 6pack frame */

/* masks to get certain bits out of the status bytes sent by the TNC */

#define CMD_MASK 0xC0
#define CHN_MASK 0x07
#define PRIO_CMD_MASK 0x80
#define STD_CMD_MASK 0x40
#define PRIO_DATA_MASK 0x38
#define TX_MASK 0x20
#define RX_MASK 0x10
#define RX_DCD_MASK 0x18
#define LEDS_ON 0x78
#define LEDS_OFF 0x60
#define CON 0x08
#define STA 0x10
#define FOUND_TNC 0xe9

#define CON_ON	0x68

#define DCD_MASK 0x08
#define DAMA_OFF 0

/* default level 2 parameters */
#define TX_DELAY 25    /* in 10 ms */
#define PERSISTANCE 50 /* in 256ths */
#define SLOTTIME 10    /* in 10 ms */
#define INITIAL_RESYNC_TIMEOUT 150 /* in 10 ms */
#define RESYNC_TIMEOUT 500 /* in 10 ms */

/* 6pack configuration. */
#define SP_NRUNIT	256		/* MAX number of 6pack channels;
					   This can be overridden with
					   insmod -oslip_maxdev=nnn	*/
#define SP_MTU		296		/* 296; I am used to 600- FvK	*/


struct sixpack {
  int			magic;

  /* Various fields. */
  struct tty_struct	*tty;		/* ptr to TTY structure		*/
  struct device		*dev;		/* easy for intr handling	*/

  /* These are pointers to the malloc()ed frame buffers. */
  unsigned char		*rbuff;		/* receiver buffer		*/
  int                   rcount;         /* received chars counter       */
  unsigned char		*xbuff;		/* transmitter buffer		*/
  unsigned char         *xhead;         /* pointer to next byte to XMIT */
  int                   xleft;          /* bytes left in XMIT queue     */

  unsigned char		raw_buf[4];
  unsigned char		cooked_buf[400];

  unsigned int		rx_count;
  unsigned int		rx_count_cooked;

  /* SLIP interface statistics. */
  unsigned long		rx_packets;	/* inbound frames counter	*/
  unsigned long         tx_packets;     /* outbound frames counter      */
  unsigned long         rx_errors;      /* Parity, etc. errors          */
  unsigned long         tx_errors;      /* Planned stuff                */
  unsigned long         rx_dropped;     /* No memory for skb            */
  unsigned long         tx_dropped;     /* When MTU change              */
  unsigned long         rx_over_errors; /* Frame bigger then SLIP buf.  */

  /* Detailed SLIP statistics. */

  int			mtu;		/* Our mtu (to spot changes!)   */
  int                   buffsize;       /* Max buffers sizes            */

  unsigned char		flags;		/* Flag values/ mode etc	*/
#define SPF_INUSE	0		/* Channel in use               */
#define SPF_ESCAPE	1               /* ESC received                 */
#define SPF_ERROR	2               /* Parity, etc. error           */
#define SPF_KEEPTEST	3		/* Keepalive test flag		*/
#define SPF_OUTWAIT	4		/* is outpacket was flag	*/

  unsigned char		mode;		/* SLIP mode			*/
#define SL_MODE_SLIP	0
#define SL_MODE_AX25	4
#define SL_MODE_ADAPTIVE 8
#ifdef CONFIG_SLIP_SMART  
  unsigned char		outfill;	/* # of sec between outfill packet */
  unsigned char		keepalive;	/* keepalive seconds		*/
  struct timer_list	outfill_timer;
  struct timer_list	keepalive_timer;
#endif  

/* 6pack stuff */
  
  unsigned char tx_delay;
  unsigned char persistance;
  unsigned char slottime;
  unsigned char duplex;
  unsigned char led_state;
  unsigned char status;
  unsigned char status1;
  unsigned char status2;
  unsigned char tx_enable;
  unsigned char tnc_ok;
  
/*  unsigned char retval; */

  struct timer_list tx_t;
  struct timer_list resync_t;
}; /* struct sixpack */



#define SIXPACK_MAGIC 0x5304

extern int sixpack_init(struct device *dev);

#endif	/* _LINUX_SLIP.H */
